/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.ui.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.jankenpoi.sudokuki.SudokuGrid;
import net.jankenpoi.sudokuki.preferences.UserPreferences;
import net.jankenpoi.sudokuki.ui.swing.Images;

public class SwingMultiGrid
extends JPanel
implements Printable {
    private static final long serialVersionUID = 1L;
    private static final int offX = 2;
    private static final int offY = 2;
    private static final int CELL_SIZE = 22;
    private int FONT_SIZE = 18;
    private SudokuGrid su1;
    private SudokuGrid su2;
    private SudokuGrid su3;
    private SudokuGrid su4;
    private static String[] digits = new String[]{"", "1", "2", "3", "4", "5", "6", "7", "8", "9", "", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "", "\u0661", "\u0662", "\u0663", "\u0664", "\u0665", "\u0666", "\u0667", "\u0668", "\u0669"};
    private Strip[] rows = new Strip[]{new Strip(2, 24), new Strip(24, 46), new Strip(46, 68), new Strip(69, 91), new Strip(91, 113), new Strip(113, 135), new Strip(136, 158), new Strip(158, 180), new Strip(180, 202)};
    private Strip[] columns = new Strip[]{new Strip(2, 24), new Strip(24, 46), new Strip(46, 68), new Strip(69, 91), new Strip(91, 113), new Strip(113, 135), new Strip(136, 158), new Strip(158, 180), new Strip(180, 202)};

    SwingMultiGrid(SudokuGrid sudokuGrid, SudokuGrid sudokuGrid2, SudokuGrid sudokuGrid3, SudokuGrid sudokuGrid4) {
        this.setPreferredSize(new Dimension(this.columns[this.columns.length - 1].getEnd() - this.columns[0].getStart() + 4 + 1, this.rows[this.rows.length - 1].getEnd() - this.rows[0].getStart() + 4 + 1));
        this.su1 = sudokuGrid;
        this.su2 = sudokuGrid2;
        this.su3 = sudokuGrid3;
        this.su4 = sudokuGrid4;
    }

    private Point getPosition(Graphics2D graphics2D, int n, int n2, String string) {
        if (0 > n || n >= 9 || 0 > n2 || n2 >= 9) {
            throw new IllegalArgumentException();
        }
        FontMetrics fontMetrics = this.getFontMetrics(graphics2D.getFont());
        int n3 = fontMetrics.getHeight();
        int n4 = fontMetrics.stringWidth(string);
        int n5 = this.columns[n2].getStart() + (22 - n4) / 2;
        int n6 = this.rows[n].getStart() + (22 + n3 / 2) / 2;
        return new Point(n5, n6 + 1);
    }

    private void paintGridNumbers(Graphics2D graphics2D, SudokuGrid sudokuGrid, int n) {
        graphics2D.setColor(Color.BLACK);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Font font = new Font("Serif", 1, this.FONT_SIZE - (n == 1 ? 4 : 0));
        graphics2D.setFont(font);
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                String string = this.getValueAsStringAt(sudokuGrid, i, j, n);
                Point point = this.getPosition(graphics2D, i, j, string);
                graphics2D.drawString(string, point.x, point.y);
            }
        }
    }

    private String getValueAsStringAt(SudokuGrid sudokuGrid, int n, int n2, int n3) {
        int n4 = sudokuGrid.getValueAt(n, n2);
        String string = digits[n4 + 10 * n3];
        return string;
    }

    private void paintGridBoard(Graphics2D graphics2D) {
        int n;
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(this.columns[0].getStart(), this.rows[0].getStart(), this.columns[this.columns.length - 1].getEnd() - 1, this.rows[this.rows.length - 1].getEnd() - 1);
        graphics2D.setColor(new Color(0xEEEEEE));
        graphics2D.fillRect(this.columns[3].getStart(), this.rows[0].getStart(), this.columns[5].getEnd() - this.columns[3].getStart(), this.rows[this.rows.length - 1].getEnd());
        graphics2D.fillRect(this.columns[0].getStart(), this.rows[3].getStart(), this.columns[this.columns.length - 1].getEnd(), this.rows[5].getEnd() - this.rows[3].getStart());
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(this.columns[3].getStart(), this.rows[3].getStart(), this.columns[5].getEnd() - this.columns[3].getStart(), this.rows[5].getEnd() - this.rows[3].getStart());
        graphics2D.setColor(Color.BLACK);
        for (n = 0; n < 9; ++n) {
            graphics2D.drawLine(this.columns[0].getStart(), this.rows[n].getStart(), this.columns[this.columns.length - 1].getEnd(), this.rows[n].getStart());
            graphics2D.drawLine(this.columns[0].getStart(), this.rows[n].getEnd(), this.columns[this.columns.length - 1].getEnd(), this.rows[n].getEnd());
        }
        for (n = 0; n < 9; ++n) {
            graphics2D.drawLine(this.columns[n].getStart(), this.rows[0].getStart(), this.columns[n].getStart(), this.rows[this.rows.length - 1].getEnd());
            graphics2D.drawLine(this.columns[n].getEnd(), this.rows[0].getStart(), this.columns[n].getEnd(), this.rows[this.rows.length - 1].getEnd());
        }
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawRect(this.columns[0].getStart() - 1, this.rows[0].getStart() - 1, this.columns[this.columns.length - 1].getEnd() - this.columns[0].getStart() + 2, this.rows[this.rows.length - 1].getEnd() - this.rows[0].getStart() + 2);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n != 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Font font = new Font("Serif", 0, 24);
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.translate(0, n2);
        graphics2D.drawString("Sudokuki - essential sudoku game", 0, 0);
        graphics2D.translate(0, n2);
        font = new Font("Serif", 0, 20);
        graphics2D.setFont(font);
        n2 = graphics2D.getFontMetrics().getHeight();
        graphics2D.drawString("http://sudokuki.sourceforge.net/", 0, n2);
        graphics2D.translate(240, -40);
        ImageIcon imageIcon = Images.ICON_APPLICATION_LOGO_SMALL;
        graphics2D.drawImage(imageIcon.getImage(), 130, 0, this);
        graphics2D.translate(-240, 140);
        int n3 = UserPreferences.getInstance().getInteger("numbersMode", 0);
        this.paintGridBoard(graphics2D);
        this.paintGridNumbers(graphics2D, this.su1, n3);
        graphics2D.translate(230, 0);
        this.paintGridBoard(graphics2D);
        this.paintGridNumbers(graphics2D, this.su2, n3);
        graphics2D.translate(-230, 250);
        this.paintGridBoard(graphics2D);
        this.paintGridNumbers(graphics2D, this.su3, n3);
        graphics2D.translate(230, 0);
        this.paintGridBoard(graphics2D);
        this.paintGridNumbers(graphics2D, this.su4, n3);
        return 0;
    }

    private class Strip {
        private int start;
        private int end;

        Strip(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        int getStart() {
            return this.start;
        }

        int getEnd() {
            return this.end;
        }
    }
}

