/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.query;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.sourceforge.sxdbutils.query.Query;
import jp.sourceforge.sxdbutils.query.QueryBuilder;
import jp.sourceforge.sxdbutils.query.SimpleQueryBuilder;
import org.apache.commons.lang.StringUtils;

public class SimpleUpdateBuilder
implements QueryBuilder {
    private final String tableName;
    private Map updateColumnMap = new LinkedHashMap();
    private Map whereColumnMap = new LinkedHashMap();
    private String versionColumnName;
    private Object versionColumnValue;
    private static final BigDecimal BIGDECIMAL_ONE = new BigDecimal("1");

    public SimpleUpdateBuilder addUpdateColumn(String columnName, Object value) {
        this.updateColumnMap.put(columnName, value);
        return this;
    }

    public SimpleUpdateBuilder addUpdateColumn(Map columnMap) {
        this.updateColumnMap.putAll(columnMap);
        return this;
    }

    public SimpleUpdateBuilder addWhereColumn(String columnName, Object value) {
        this.whereColumnMap.put(columnName, value);
        return this;
    }

    public SimpleUpdateBuilder setVersionColumn(String columnName, Object value) {
        this.versionColumnName = columnName;
        this.versionColumnValue = value;
        return this;
    }

    public SimpleUpdateBuilder(String tableName) {
        this.tableName = tableName;
    }

    public Query toQuery() {
        SimpleQueryBuilder builder = new SimpleQueryBuilder(256);
        builder.append("update ").append(this.tableName).append(" set ");
        boolean colflg = false;
        Iterator iterator = this.updateColumnMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (this.versionColumnName != null && this.versionColumnName.equalsIgnoreCase((String)entry.getKey())) continue;
            if (colflg) {
                builder.append(',');
            }
            colflg = true;
            builder.append((String)entry.getKey()).append("=?").bind(entry.getValue());
        }
        if (StringUtils.isNotEmpty((String)this.versionColumnName)) {
            if (colflg) {
                builder.append(',');
            }
            builder.append(this.versionColumnName).append("=?").bind(SimpleUpdateBuilder.getNextVersion(this.versionColumnValue));
        }
        builder.append(" where ");
        boolean whereflg = false;
        Iterator iterator2 = this.whereColumnMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            if (whereflg) {
                builder.append(" and ");
            }
            whereflg = true;
            builder.append((String)entry.getKey()).append("=?").bind(entry.getValue());
        }
        if (StringUtils.isNotEmpty((String)this.versionColumnName) && this.versionColumnValue != null) {
            if (whereflg) {
                builder.append(" and ");
            }
            builder.append(this.versionColumnName).append("=?").bind(this.versionColumnValue);
        }
        return builder.toQuery();
    }

    static Object getNextVersion(Object current) {
        if (current instanceof Integer) {
            Integer i = (Integer)current;
            return new Integer(i + 1);
        }
        if (current instanceof Long) {
            Long l = (Long)current;
            return new Long(l + 1L);
        }
        if (current instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)current;
            return bd.add(BIGDECIMAL_ONE);
        }
        if (current instanceof Date) {
            return new Date();
        }
        return null;
    }
}

