package jp.sourceforge.sxdbutils.types;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.commons.lang.StringUtils;

/**
 * DB側がCHAR/VARCHARでフラグ管理されているときのValueType
 * 
 * @author chinpei
 * 
 */
public class BooleanCharType extends AbstractValueType {
	private static final String TRUE = "1";
	private static final String FALSE = "0";

	private final boolean primitive;

	public BooleanCharType(boolean primitive) {
		this.primitive = primitive;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see dbutilsx.types.ValueType#getValue(java.sql.ResultSet, int)
	 */
	public Object getValue(ResultSet rset, int columnIndex) throws SQLException {
		String s = rset.getString(columnIndex);
		if (StringUtils.isBlank(s))
			return primitive ? Boolean.FALSE : null;
		return StringUtils.equals(s, FALSE) ? Boolean.FALSE : Boolean.TRUE;
	}

	public Object toBindParameterValue(Object value) {
		return ((Boolean) value).booleanValue() ? TRUE : FALSE;
	}
}
