package jp.sourceforge.sxdbutils.util;

import org.apache.commons.lang.StringUtils;

public class NameConvertUtils {
	private NameConvertUtils() {
	}

	public static String camel(String src) {

		String[] strings = StringUtils.split(src, '_');
		if (strings.length == 1)
			return src;

		for (int i = 0; i < strings.length; i++) {
			strings[i] = strings[i].toLowerCase();
			if (i != 0)
				strings[i] = StringUtils.capitalize(strings[i]);
		}
		return StringUtils.join(strings);
	}

	public static String camelToColumnName(String camelString) {
		StringBuffer buffer = new StringBuffer();
		String[] tokens = StringUtils
				.splitByCharacterTypeCamelCase(camelString);
		for (int i = 0; i < tokens.length; i++) {
			if (i != 0)
				buffer.append('_');
			String token = tokens[i];
			buffer.append(token);
		}
		return buffer.toString().toLowerCase();
	}

}
