package jp.sourceforge.sxdbutils.tiger.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;

import jp.sourceforge.sxdbutils.tiger.SxResultSetHandler;
import jp.sourceforge.sxdbutils.tiger.SxRowProcessor;
import jp.sourceforge.sxdbutils.tiger.processors.ValueRowProcessor;

/**
 * 結果をMapで返すハンドラです。特定の項目がキーになります。
 * 
 * @author chinpei
 * 
 */
public class KeyedHandler<K, V> implements SxResultSetHandler<Map<K, V>> {

	protected final SxRowProcessor<K> keyProcessor;

	protected final SxRowProcessor<V> valueProcessor;

	public KeyedHandler(String keyColumnName, Class<K> type,
			SxRowProcessor<V> processor) {
		this(new ValueRowProcessor<K>(keyColumnName, type), processor);
	}

	public KeyedHandler(String keyColumnName, SxRowProcessor<V> processor) {
		this(new ValueRowProcessor<K>(keyColumnName), processor);
	}

	public KeyedHandler(int keyColumnIndex, Class<K> keyType,
			SxRowProcessor<V> processor) {
		this(new ValueRowProcessor<K>(keyColumnIndex, keyType), processor);
	}

	public KeyedHandler(int columnIndex, SxRowProcessor<V> processor) {
		this(new ValueRowProcessor<K>(columnIndex), processor);
	}

	public KeyedHandler(SxRowProcessor<K> keyProcessor,
			SxRowProcessor<V> processor) {
		this.keyProcessor = keyProcessor;
		this.valueProcessor = processor;
	}

	public Map<K, V> handle(ResultSet rs) throws SQLException {
		Map<K, V> result = createMap();

		if (rs.next()) {
			keyProcessor.init(rs.getMetaData());
			valueProcessor.init(rs.getMetaData());
			do {
				result
						.put(keyProcessor.process(rs), valueProcessor
								.process(rs));
			} while (rs.next());
		}
		return result;
	}

	protected Map<K, V> createMap() {
		return new LinkedHashMap<K, V>();
	}

}
