package jp.sourceforge.sxdbutils.tiger.bean;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.List;

import jp.sourceforge.sxdbutils.bean.ConstantAnnoNameMapping;
import jp.sourceforge.sxdbutils.bean.NameMapping;
import jp.sourceforge.sxdbutils.util.OthersUtils;
import jp.sourceforge.sxdbutils.util.ReflectionUtil;

/**
 * 定数アノテーションにより、カラム名が指定できる {@link NameMapping}です。
 * 
 * @author chinpei
 * 
 */
public class AnnoNameMapping extends ConstantAnnoNameMapping {
	@SuppressWarnings("unchecked")
	public AnnoNameMapping(Class beanClass) {
		super(beanClass);
	}

	@SuppressWarnings("unchecked")
	public AnnoNameMapping(Class beanClass, NameMapping defaultNameMapping) {
		super(beanClass, defaultNameMapping);
	}

	@Override
	protected String getColumnNameFromAnnotation(Field field) {
		Column columnAnno = field.getAnnotation(Column.class);

		if (columnAnno == null)
			return field.getName();

		return OthersUtils.isBlank(columnAnno.name()) ? field.getName()
				: columnAnno.name();

	}

	@SuppressWarnings("unchecked")
	@Override
	protected void readAnnotationFieldsToList(Class beanClass, List list) {
		if ("java.lang.Object".equals(beanClass.getName()))
			return;
		readAnnotationFieldsToList(beanClass.getSuperclass(), list);
		PropertyDescriptor[] propertyDescriptors = ReflectionUtil
				.propertyDescriptors(beanClass);
		for (int i = 0; i < propertyDescriptors.length; i++) {
			PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
			if ("class".equals(propertyDescriptor.getName())) {
				continue;
			}
			String name = propertyDescriptor.getName();
			try {
				Field field = beanClass.getDeclaredField(name);
				if (field.getAnnotation(Column.class) != null) {
					list.add(field);
				}
			} catch (SecurityException e) {
				throw new RuntimeException(e);
			} catch (NoSuchFieldException e) {
				throw new RuntimeException(e);
			}
		}

	}
}
