package jp.sourceforge.sxdbutils.tiger.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;

import jp.sourceforge.sxdbutils.tiger.SxResultSetHandler;
import jp.sourceforge.sxdbutils.tiger.SxRowProcessor;

/**
 * 最初の1行のみを処理するハンドラです。
 * 1行も取得できなかった場合はnullを返します。
 * @author chinpei
 *
 */
public class SingleHandler<S> implements SxResultSetHandler<S> {

	protected final SxRowProcessor<S> processor;

	public SingleHandler(SxRowProcessor<S> processor) {
		this.processor = processor;
	}

	public S handle(ResultSet rs) throws SQLException {
		if (rs.next()) {
			processor.init(rs.getMetaData());
			return processor.process(rs);
		}
		return null;

	}

}
