package jp.sourceforge.sxdbutils.tiger.processors;

import jp.sourceforge.sxdbutils.bean.NameMapping;
import jp.sourceforge.sxdbutils.tiger.SxRowProcessor;

/**
 * Beanにマッピングする {@link SxRowProcessor}。 カラム名とプロパティ名の名前が、 {@link NameMapping}
 * によって一致したものがマッピングされます。 デフォルトでは、キャメル形式でマッピングされます。
 * 
 * @author chinpei
 * 
 */
public class BeanRowProcessor<S> extends SxRowProcessorDelegate<S> {


	public BeanRowProcessor(Class<S> beanClass) {
		super(
				new jp.sourceforge.sxdbutils.processors.BeanRowProcessor(
						beanClass));
	}

	public BeanRowProcessor(Class<S> beanClass, NameMapping nameMapping) {
		super(new jp.sourceforge.sxdbutils.processors.BeanRowProcessor(
				beanClass, nameMapping));
	}

}
