package jp.sourceforge.sxdbutils.tiger.bean;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.sourceforge.sxdbutils.bean.ColumnNameMapping;
import jp.sourceforge.sxdbutils.bean.NameMapping;
import jp.sourceforge.sxdbutils.bean.OverwriteNameMapping;
import jp.sourceforge.sxdbutils.util.CaseInsensitiveHashMap;
import jp.sourceforge.sxdbutils.util.OthersUtils;
import jp.sourceforge.sxdbutils.util.ReflectionUtil;

/**
 * 定数アノテーションにより、カラム名が指定できる {@link NameMapping}です。
 * 
 * @author chinpei
 * 
 */
public class AnnoNameMapping implements NameMapping {

	private static final NameMapping DEFAULT_COMVERSION = new ColumnNameMapping();

	private final OverwriteNameMapping delegateNameMapping;

	public AnnoNameMapping(Class<?> beanClass) {
		this(beanClass, DEFAULT_COMVERSION);
	}

	public AnnoNameMapping(Class<?> beanClass, NameMapping defaultNameMapping) {
		Map<String, String> columnToPropertyMap = new HashMap<String, String>();
		Field[] fields = getAnnotationFields(beanClass);
		for (int i = 0; i < fields.length; i++) {
			Field field = fields[i];
			String columnName = getColumnNameFromAnnotation(field);
			columnToPropertyMap.put(field.getName(), columnName);
		}
		this.delegateNameMapping = new OverwriteNameMapping(
				columnToPropertyMap, defaultNameMapping);
	}

	private final Field[] getAnnotationFields(Class<?> beanClass) {
		List<Object> list = new ArrayList<Object>();
		readAnnotationFieldsToList(beanClass, list);
		return (Field[]) list.toArray(new Field[list.size()]);
	}

	private String getColumnNameFromAnnotation(Field field) {
		Column columnAnno = field.getAnnotation(Column.class);

		if (columnAnno == null)
			return field.getName();

		return OthersUtils.isBlank(columnAnno.name()) ? field.getName()
				: columnAnno.name();

	}

	private void readAnnotationFieldsToList(Class<?> beanClass,
			List<Object> list) {
		if ("java.lang.Object".equals(beanClass.getName()))
			return;
		readAnnotationFieldsToList(beanClass.getSuperclass(), list);
		PropertyDescriptor[] propertyDescriptors = ReflectionUtil
				.propertyDescriptors(beanClass);
		for (int i = 0; i < propertyDescriptors.length; i++) {
			PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
			if ("class".equals(propertyDescriptor.getName())) {
				continue;
			}
			String name = propertyDescriptor.getName();
			try {
				Field field = beanClass.getDeclaredField(name);
				if (field.getAnnotation(Column.class) != null) {
					list.add(field);
				}
			} catch (SecurityException e) {
				throw new RuntimeException(e);
			} catch (NoSuchFieldException e) {
				throw new RuntimeException(e);
			}
		}

	}

	public String toIntermediateName(PropertyDescriptor propertyDescriptor) {
		return this.delegateNameMapping.toIntermediateName(propertyDescriptor);
	}

	@SuppressWarnings("unchecked")
	public final Map createIntermediateMap() {
		return new CaseInsensitiveHashMap();
	}

	public String toIntermediateName(String columnName) {
		return this.delegateNameMapping.toIntermediateName(columnName);
	}

	public String toColumnName(PropertyDescriptor propertyDescriptor) {
		return this.delegateNameMapping.toColumnName(propertyDescriptor);
	}
}
