package jp.sourceforge.sxdbutils.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;

import jp.sourceforge.sxdbutils.SxRowProcessor;
import jp.sourceforge.sxdbutils.processors.ValueRowProcessor;

import org.apache.commons.dbutils.ResultSetHandler;

/**
 * 結果をMapで返すハンドラです。特定の項目がキーになります。
 * 
 * @author chinpei
 * 
 */
public class KeyedHandler implements ResultSetHandler {

	protected final SxRowProcessor keyProcessor;

	protected final SxRowProcessor valueProcessor;

	protected SxRowProcessor getKeyProcessor() {
		if (keyProcessor == null) {
			throw new IllegalStateException("キーを処理するSxRowProcessorが指定されていません。"
					+ "引数なしのコンストラクタを使用する場合、"
					+ "必ずgetKeyProcessorとgetValueProcessorメソッドをオーバーライドしてください。");
		}

		return keyProcessor;
	}

	protected SxRowProcessor getValueProcessor() {
		if (valueProcessor == null) {
			if (keyProcessor == null) {
				throw new IllegalStateException(
						"値を処理するSxRowProcessorが指定されていません。"
								+ "引数なしのコンストラクタを使用する場合、"
								+ "必ずgetKeyProcessorとgetValueProcessorメソッドをオーバーライドしてください。");
			}

		}
		return valueProcessor;
	}

	public KeyedHandler() {
		this.keyProcessor = null;
		this.valueProcessor = null;
	}

	public KeyedHandler(String keyColumnName, Class type,
			SxRowProcessor processor) {
		this(new ValueRowProcessor(keyColumnName, type), processor);
	}

	public KeyedHandler(String keyColumnName, SxRowProcessor processor) {
		this(new ValueRowProcessor(keyColumnName), processor);
	}

	public KeyedHandler(int keyColumnIndex, Class keyType,
			SxRowProcessor processor) {
		this(new ValueRowProcessor(keyColumnIndex, keyType), processor);
	}

	public KeyedHandler(int columnIndex, SxRowProcessor processor) {
		this(new ValueRowProcessor(columnIndex), processor);
	}

	public KeyedHandler(SxRowProcessor keyProcessor, SxRowProcessor processor) {
		this.keyProcessor = keyProcessor;
		this.valueProcessor = processor;
	}

	public Object handle(ResultSet rs) throws SQLException {
		Map result = createMap();
		SxRowProcessor kproc = getKeyProcessor();
		SxRowProcessor vproc = getValueProcessor();
		if (rs.next()) {
			kproc.init(rs.getMetaData());
			vproc.init(rs.getMetaData());
			do {
				result.put(kproc.process(rs), vproc.process(rs));
			} while (rs.next());
		}
		return result;
	}

	protected Map createMap() {
		return new LinkedHashMap();
	}

}
