package jp.sourceforge.sxdbutils.template;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import jp.sourceforge.sxdbutils.query.Query;
import jp.sourceforge.sxdbutils.query.QueryFactory;
import jp.sourceforge.sxdbutils.SxQueryRunner;

public class EntityPersistenceHelper {

	public int execute(Connection connection, QueryFactory factory, Object entity)
			throws SQLException {
		SxQueryRunner runner = new SxQueryRunner();
		return runner.update(connection, factory.toQuery(entity));
	}

	public int[] execute(Connection connection, QueryFactory factory,
			Collection entities) throws SQLException {
		List queries = new ArrayList();
		for (Iterator iterator = entities.iterator(); iterator.hasNext();) {
			Object entity = (Object) iterator.next();
			Query q = factory.toQuery(entity);
			queries.add(q);
		}
		int[] result = new int[queries.size()];
		SxQueryRunner runner = new SxQueryRunner();
		for (int i = 0; i < queries.size(); i++) {
			result[i] = runner.update(connection, (Query) queries.get(i));
		}
		return result;

	}

	public int[] executeBatch(Connection connection, QueryFactory factory,
			Collection entities) throws SQLException {
		Object[][] batchParams = new Object[entities.size()][];
		int i = 0;
		for (Iterator iterator = entities.iterator(); iterator.hasNext();) {
			Object entity = (Object) iterator.next();
			batchParams[i++] = factory.toBindParameters(entity);
		}
		SxQueryRunner runner = new SxQueryRunner();
		return runner.batch(connection, factory.getSql(), batchParams);
	}

}
