package jp.sourceforge.sxdbutils.rstable;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class LocalCachedResultSet implements ResultSet {

	private final ResultTable resultTable;
	private int index = -1;

	public LocalCachedResultSet(ResultTable resultTable) {
		this.resultTable = resultTable;
	}

	public boolean absolute(int row) throws SQLException {
		if (row == 0) {
			index = -1;
			return false;
		}
		index = (row > 0) ? row - 1 : resultTable.size() - row - 1;
		if (0 <= index && index < resultTable.size()) {
			return true;
		}
		return false;
	}

	public void afterLast() throws SQLException {
		index = resultTable.size();
	}

	public void beforeFirst() throws SQLException {
		index = -1;
	}

	public void cancelRowUpdates() throws SQLException {
		//		throw new SQLFeatureNotSupportedException
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void clearWarnings() throws SQLException {
	}

	public void close() throws SQLException {
	}

	public void deleteRow() throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public int findColumn(String columnName) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public boolean first() throws SQLException {
		return absolute(1);
	}

	public Array getArray(int i) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public Array getArray(String colName) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public InputStream getAsciiStream(int columnIndex) throws SQLException {
		String string = resultTable.getString(index, columnIndex);
		return new ByteArrayInputStream(string.getBytes());
	}

	public InputStream getAsciiStream(String columnName) throws SQLException {
		String string = resultTable.getString(index, columnName);
		return new ByteArrayInputStream(string.getBytes());
	}

	public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {

		BigDecimal bd = resultTable.getBigDecimal(index, columnIndex);
		bd.setScale(scale);
		return bd;
	}

	public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
		return resultTable.getBigDecimal(index, columnIndex);
	}

	public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
		BigDecimal bd = resultTable.getBigDecimal(index, columnName);
		bd.setScale(scale);
		return bd;
	}

	public BigDecimal getBigDecimal(String columnName) throws SQLException {
		return resultTable.getBigDecimal(index, columnName);
	}

	public InputStream getBinaryStream(int columnIndex) throws SQLException {
		return new ByteArrayInputStream(resultTable.getBytes(index, columnIndex));
	}

	public InputStream getBinaryStream(String columnName) throws SQLException {
		return new ByteArrayInputStream(resultTable.getBytes(index, columnName));
	}

	public Blob getBlob(int i) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public Blob getBlob(String colName) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public boolean getBoolean(int columnIndex) throws SQLException {
		return resultTable.getBoolean(index, columnIndex);
	}

	public boolean getBoolean(String columnName) throws SQLException {
		return resultTable.getBoolean(index, columnName);
	}

	public byte getByte(int columnIndex) throws SQLException {
		return resultTable.getByte(index, columnIndex);
	}

	public byte getByte(String columnName) throws SQLException {
		return resultTable.getByte(index, columnName);
	}

	public byte[] getBytes(int columnIndex) throws SQLException {
		return resultTable.getBytes(index, columnIndex);
	}

	public byte[] getBytes(String columnName) throws SQLException {
		return resultTable.getBytes(index, columnName);
	}

	public Reader getCharacterStream(int columnIndex) throws SQLException {
		return new StringReader(resultTable.getString(index, columnIndex));
	}

	public Reader getCharacterStream(String columnName) throws SQLException {
		return new StringReader(resultTable.getString(index, columnName));
	}

	public Clob getClob(int i) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public Clob getClob(String colName) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public int getConcurrency() throws SQLException {
		return ResultSet.CONCUR_READ_ONLY;
	}

	public String getCursorName() throws SQLException {
		return this.getClass().getName();
	}

	public Date getDate(int columnIndex, Calendar cal) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public Date getDate(int columnIndex) throws SQLException {
		return resultTable.getSqlDate(index, columnIndex);
	}

	public Date getDate(String columnName, Calendar cal) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public Date getDate(String columnName) throws SQLException {
		return resultTable.getSqlDate(index, columnName);
	}

	public double getDouble(int columnIndex) throws SQLException {
		return resultTable.getDouble(index, columnIndex);
	}

	public double getDouble(String columnName) throws SQLException {
		return resultTable.getDouble(index, columnName);
	}

	public int getFetchDirection() throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public int getFetchSize() throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public float getFloat(int columnIndex) throws SQLException {
		return resultTable.getFloat(index, columnIndex);
	}

	public float getFloat(String columnName) throws SQLException {
		return resultTable.getFloat(index, columnName);
	}

	public int getInt(int columnIndex) throws SQLException {
		return resultTable.getInt(index, columnIndex);
	}

	public int getInt(String columnName) throws SQLException {
		return resultTable.getInt(index, columnName);
	}

	public long getLong(int columnIndex) throws SQLException {
		return resultTable.getLong(index, columnIndex);
	}

	public long getLong(String columnName) throws SQLException {
		return resultTable.getLong(index, columnName);
	}

	public ResultSetMetaData getMetaData() throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public Object getObject(int columnIndex) throws SQLException {
		return resultTable.getObject(index, columnIndex);
	}

	public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public Object getObject(String columnName) throws SQLException {
		return resultTable.getObject(index, columnName);
	}

	public Ref getRef(int i) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public Ref getRef(String colName) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public int getRow() throws SQLException {
		return index + 1;
	}

	public short getShort(int columnIndex) throws SQLException {
		return resultTable.getShort(index, columnIndex);
	}

	public short getShort(String columnName) throws SQLException {
		return resultTable.getShort(index, columnName);
	}

	public Statement getStatement() throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public String getString(int columnIndex) throws SQLException {
		return resultTable.getString(index, columnIndex);
	}

	public String getString(String columnName) throws SQLException {
		return resultTable.getString(index, columnName);
	}

	public Time getTime(int columnIndex, Calendar cal) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public Time getTime(int columnIndex) throws SQLException {
		return resultTable.getTime(index, columnIndex);
	}

	public Time getTime(String columnName, Calendar cal) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public Time getTime(String columnName) throws SQLException {
		return resultTable.getTime(index, columnName);
	}

	public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public Timestamp getTimestamp(int columnIndex) throws SQLException {
		return resultTable.getTimestamp(index, columnIndex);
	}

	public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public Timestamp getTimestamp(String columnName) throws SQLException {
		return resultTable.getTimestamp(index, columnName);
	}

	public int getType() throws SQLException {
		return ResultSet.TYPE_FORWARD_ONLY;
	}

	public InputStream getUnicodeStream(int columnIndex) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public InputStream getUnicodeStream(String columnName) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public URL getURL(int columnIndex) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public URL getURL(String columnName) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public SQLWarning getWarnings() throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void insertRow() throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public boolean isAfterLast() throws SQLException {
		return index >= resultTable.size();
	}

	public boolean isBeforeFirst() throws SQLException {
		return index < 0;
	}

	public boolean isFirst() throws SQLException {
		return index == 0;
	}

	public boolean isLast() throws SQLException {
		return resultTable.size() == index + 1;
	}

	public boolean last() throws SQLException {
		return absolute(resultTable.size());
	}

	public void moveToCurrentRow() throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void moveToInsertRow() throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public boolean next() throws SQLException {
		return absolute(index + 2);
	}

	public boolean previous() throws SQLException {
		return absolute(index);
	}

	public void refreshRow() throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public boolean relative(int rows) throws SQLException {
		return absolute(index + 1 + rows);
	}

	public boolean rowDeleted() throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public boolean rowInserted() throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public boolean rowUpdated() throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void setFetchDirection(int direction) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void setFetchSize(int rows) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateArray(int columnIndex, Array x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateArray(String columnName, Array x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateBlob(int columnIndex, Blob x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateBlob(String columnName, Blob x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateBoolean(int columnIndex, boolean x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateBoolean(String columnName, boolean x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateByte(int columnIndex, byte x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateByte(String columnName, byte x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateBytes(int columnIndex, byte[] x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateBytes(String columnName, byte[] x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateClob(int columnIndex, Clob x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateClob(String columnName, Clob x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateDate(int columnIndex, Date x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateDate(String columnName, Date x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateDouble(int columnIndex, double x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateDouble(String columnName, double x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateFloat(int columnIndex, float x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateFloat(String columnName, float x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateInt(int columnIndex, int x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateInt(String columnName, int x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateLong(int columnIndex, long x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateLong(String columnName, long x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateNull(int columnIndex) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateNull(String columnName) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateObject(int columnIndex, Object x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateObject(String columnName, Object x, int scale) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateObject(String columnName, Object x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateRef(int columnIndex, Ref x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateRef(String columnName, Ref x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateRow() throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateShort(int columnIndex, short x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateShort(String columnName, short x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateString(int columnIndex, String x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateString(String columnName, String x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateTime(int columnIndex, Time x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateTime(String columnName, Time x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
		throw new SQLException("SQLFeatureNotSupportedException.");
	}

	public boolean wasNull() throws SQLException {
		// TODO Auto-generated method stub
		return false;
	}

}
