/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.sxdbutils.TypeMappings;
import jp.sourceforge.sxdbutils.ValueType;
import jp.sourceforge.sxdbutils.query.MapQueryFactory;
import jp.sourceforge.sxdbutils.query.QueryFactory;
import jp.sourceforge.sxdbutils.util.ColumnInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapQueryFactoryBuilder {
    protected final String tableName;
    protected Map<String, ValueType> columns = new LinkedHashMap<String, ValueType>();
    protected Set<String> updateKeyColumnSet;

    public MapQueryFactoryBuilder(String tableName) {
        this.tableName = tableName;
    }

    public MapQueryFactoryBuilder addColumn(String columnName) {
        this.columns.put(columnName, TypeMappings.OBJECT_TYPE);
        return this;
    }

    public MapQueryFactoryBuilder addColumn(String columnName, int sqlType) {
        this.columns.put(columnName, TypeMappings.getValueType(sqlType));
        return this;
    }

    public MapQueryFactoryBuilder addColumn(String columnName, Class<?> valueClass) {
        this.columns.put(columnName, TypeMappings.getValueType(valueClass));
        return this;
    }

    public MapQueryFactoryBuilder addColumn(String columnName, int sqlType, Class<?> valueClass) {
        this.columns.put(columnName, TypeMappings.getValueType(valueClass, sqlType));
        return this;
    }

    public MapQueryFactoryBuilder addColumns(String[] columnNames) {
        for (int i = 0; i < columnNames.length; ++i) {
            this.addColumn(columnNames[i]);
        }
        return this;
    }

    public MapQueryFactoryBuilder addColumns(Collection<String> columnNames) {
        Iterator<String> iterator = columnNames.iterator();
        while (iterator.hasNext()) {
            this.addColumn(iterator.next());
        }
        return this;
    }

    public MapQueryFactoryBuilder updateKeyColumn(String columnNames) {
        if (this.updateKeyColumnSet == null) {
            this.updateKeyColumnSet = new LinkedHashSet<String>();
        }
        this.updateKeyColumnSet.add(columnNames.toLowerCase());
        return this;
    }

    private boolean isUpdateKey(String columnName) {
        if (this.updateKeyColumnSet == null) {
            return false;
        }
        return this.updateKeyColumnSet.contains(columnName.toLowerCase());
    }

    public QueryFactory<Map<String, Object>> buildUpdate() {
        ColumnInfo[] columnInfos = this.toColumnInfos();
        ArrayList<ColumnInfo> updateColumnInfos = new ArrayList<ColumnInfo>();
        ArrayList<ColumnInfo> whereColumnInfos = new ArrayList<ColumnInfo>();
        StringBuffer columnBuffer = new StringBuffer(columnInfos.length * 7);
        columnBuffer.append("update ").append(this.tableName).append(" set ");
        boolean flg = false;
        for (int i = 0; i < columnInfos.length; ++i) {
            ColumnInfo columnInfo = columnInfos[i];
            if (this.isUpdateKey(columnInfo.getColumnName())) {
                whereColumnInfos.add(columnInfo);
                continue;
            }
            if (flg) {
                columnBuffer.append(',');
            } else {
                flg = true;
            }
            columnBuffer.append(columnInfo.getColumnName()).append("=?");
            updateColumnInfos.add(columnInfo);
        }
        StringBuffer whereBuffer = null;
        if (!whereColumnInfos.isEmpty()) {
            Iterator iterator = whereColumnInfos.iterator();
            while (iterator.hasNext()) {
                if (whereBuffer == null) {
                    whereBuffer = new StringBuffer(" where ");
                } else {
                    whereBuffer.append(" and ");
                }
                ColumnInfo columnInfo = (ColumnInfo)iterator.next();
                whereBuffer.append(columnInfo.getColumnName()).append("=?");
            }
        }
        ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>(updateColumnInfos);
        list.addAll(whereColumnInfos);
        if (whereBuffer != null) {
            columnBuffer.append(whereBuffer);
        }
        String sql = columnBuffer.toString();
        return new MapQueryFactory(sql, list.toArray(new ColumnInfo[list.size()]));
    }

    public QueryFactory<Map<String, Object>> buildInsert() {
        ColumnInfo[] columnInfos = this.toColumnInfos();
        StringBuffer columnBuffer = new StringBuffer(columnInfos.length * 7);
        StringBuffer valueBuffer = new StringBuffer(columnInfos.length * 2);
        columnBuffer.append("insert into ").append(this.tableName).append("(");
        valueBuffer.append(" values ( ");
        boolean flg = false;
        for (int i = 0; i < columnInfos.length; ++i) {
            if (flg) {
                columnBuffer.append(',');
                valueBuffer.append(',');
            } else {
                flg = true;
            }
            ColumnInfo columnInfo = columnInfos[i];
            columnBuffer.append(columnInfo.getColumnName());
            valueBuffer.append('?');
        }
        columnBuffer.append(" ) ");
        valueBuffer.append(" ) ");
        String sql = columnBuffer.append(valueBuffer).toString();
        return new MapQueryFactory(sql, columnInfos);
    }

    protected ColumnInfo[] toColumnInfos() {
        ColumnInfo[] result = new ColumnInfo[this.columns.size()];
        int i = 0;
        for (Map.Entry<String, ValueType> entry : this.columns.entrySet()) {
            result[i++] = new ColumnInfo(entry.getKey(), entry.getValue());
        }
        return result;
    }
}

