/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.extras.dao;

import java.sql.SQLException;
import java.util.List;
import jp.sourceforge.sxdbutils.extras.dao.AbstractAttributeSelectTemplate;
import jp.sourceforge.sxdbutils.extras.dao.CRUDOperation;
import jp.sourceforge.sxdbutils.query.AttributeQueryFactoryBuilder;
import jp.sourceforge.sxdbutils.query.QueryFactory;
import jp.sourceforge.sxdbutils.template.EntityPersistenceHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAttributeCLUDTemplate<E, B extends AttributeQueryFactoryBuilder<E>>
extends AbstractAttributeSelectTemplate<E>
implements CRUDOperation<E> {
    private final Object updateFoctoryLock = new Object();
    private QueryFactory<E> updateFactory;
    private final Object insertFoctoryLock = new Object();
    private QueryFactory<E> insertFactory;
    private final Object deleteFoctoryLock = new Object();
    private QueryFactory<E> deleteFactory;

    protected EntityPersistenceHelper<E> getEntityPersistenceHelper() {
        return new EntityPersistenceHelper();
    }

    protected abstract B createQueryFactoryBuilder();

    protected abstract void updateConfig(B var1);

    protected abstract void insertConfig(B var1);

    protected abstract void deleteConfig(B var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureUpdateFactory() {
        Object object = this.updateFoctoryLock;
        synchronized (object) {
            if (this.updateFactory == null) {
                B builder = this.createQueryFactoryBuilder();
                this.updateConfig(builder);
                this.updateFactory = ((AttributeQueryFactoryBuilder)builder).buildUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInsertFactory() {
        Object object = this.insertFoctoryLock;
        synchronized (object) {
            if (this.insertFactory == null) {
                B builder = this.createQueryFactoryBuilder();
                this.insertConfig(builder);
                this.insertFactory = ((AttributeQueryFactoryBuilder)builder).buildInsert();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDeleteFactory() {
        Object object = this.deleteFoctoryLock;
        synchronized (object) {
            if (this.deleteFactory == null) {
                B builder = this.createQueryFactoryBuilder();
                this.deleteConfig(builder);
                this.deleteFactory = ((AttributeQueryFactoryBuilder)builder).buildDelete();
            }
        }
    }

    @Override
    public int update(E entity) throws SQLException {
        this.ensureUpdateFactory();
        return this.getEntityPersistenceHelper().execute(this.getConnection(), this.updateFactory, entity);
    }

    @Override
    public int[] update(List<E> entites) throws SQLException {
        this.ensureUpdateFactory();
        return this.getEntityPersistenceHelper().executeBatch(this.getConnection(), this.updateFactory, entites);
    }

    @Override
    public int insert(E entity) throws SQLException {
        this.ensureInsertFactory();
        return this.getEntityPersistenceHelper().execute(this.getConnection(), this.insertFactory, entity);
    }

    @Override
    public int[] insert(List<E> entites) throws SQLException {
        this.ensureInsertFactory();
        return this.getEntityPersistenceHelper().executeBatch(this.getConnection(), this.insertFactory, entites);
    }

    @Override
    public int delete(E entity) throws SQLException {
        this.ensureDeleteFactory();
        return this.getEntityPersistenceHelper().execute(this.getConnection(), this.deleteFactory, entity);
    }

    @Override
    public int[] delete(List<E> entites) throws SQLException {
        this.ensureDeleteFactory();
        return this.getEntityPersistenceHelper().executeBatch(this.getConnection(), this.deleteFactory, entites);
    }
}

