/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.processors;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.sxdbutils.SxRowProcessor;
import jp.sourceforge.sxdbutils.TypeMappings;
import jp.sourceforge.sxdbutils.ValueType;
import jp.sourceforge.sxdbutils.mapping.ColumnNameMapping;
import jp.sourceforge.sxdbutils.mapping.NameMapping;
import jp.sourceforge.sxdbutils.meta.AttributeDescpriotr;
import jp.sourceforge.sxdbutils.meta.BasicResultSetToObjectEntry;
import jp.sourceforge.sxdbutils.meta.PropertyAttributeDescpritor;
import jp.sourceforge.sxdbutils.meta.ResultSetToObjectEntry;
import jp.sourceforge.sxdbutils.util.CaseInsensitiveHashMap;
import jp.sourceforge.sxdbutils.util.JdbcMetaUtil;
import jp.sourceforge.sxdbutils.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AttributeRowProcessor<E>
implements SxRowProcessor<E> {
    protected final Class<E> baseClass;
    protected final NameMapping nameMapping;
    private static final NameMapping DEFAULT_NAME_MAPPING = new ColumnNameMapping();
    protected ResultSetToObjectEntry[] bindingEntries;

    public AttributeRowProcessor(Class<E> baseClass) {
        this(baseClass, DEFAULT_NAME_MAPPING);
    }

    public AttributeRowProcessor(Class<E> clazz, NameMapping nameMapping) {
        this.baseClass = clazz;
        this.nameMapping = nameMapping;
    }

    @Override
    public void init(ResultSetMetaData rsmd) throws SQLException {
        Map<String, AttributeDescpriotr> attributeDescpriotrMap = this.createAttributeDescpriotrMap();
        ArrayList<ResultSetToObjectEntry> list = new ArrayList<ResultSetToObjectEntry>();
        for (int i = 0; i < rsmd.getColumnCount(); ++i) {
            ResultSetToObjectEntry bindingEntry = this.getBindingEntry(rsmd, i + 1, attributeDescpriotrMap);
            if (bindingEntry == null) continue;
            list.add(bindingEntry);
        }
        this.bindingEntries = list.toArray(new ResultSetToObjectEntry[list.size()]);
    }

    protected Map<String, AttributeDescpriotr> createAttributeDescpriotrMap() {
        HashMap<String, AttributeDescpriotr> attributeDescpriotrNameMap = new HashMap<String, AttributeDescpriotr>();
        this.putDescriptorToMap(this.baseClass, attributeDescpriotrNameMap);
        CaseInsensitiveHashMap<AttributeDescpriotr> attributeDescpriotrMap = new CaseInsensitiveHashMap<AttributeDescpriotr>();
        for (Map.Entry entry : attributeDescpriotrNameMap.entrySet()) {
            attributeDescpriotrMap.put(this.nameMapping.toIntermediateNameFromAttrName((String)entry.getKey()), (AttributeDescpriotr)entry.getValue());
        }
        return attributeDescpriotrMap;
    }

    @Override
    public E process(ResultSet rs) throws SQLException {
        Object entity = ReflectionUtil.newInstance(this.baseClass);
        ResultSetToObjectEntry bindingEntry = null;
        for (int i = 0; i < this.bindingEntries.length; ++i) {
            bindingEntry = this.bindingEntries[i];
            bindingEntry.set(entity, rs);
        }
        return (E)entity;
    }

    protected abstract void putDescriptorToMap(Class<E> var1, Map<String, AttributeDescpriotr> var2);

    protected ResultSetToObjectEntry getBindingEntry(ResultSetMetaData rsmd, int columnIndex, Map<String, AttributeDescpriotr> attributeDescpriotrMap) throws SQLException {
        String columnName = JdbcMetaUtil.getColumnName(rsmd, columnIndex);
        AttributeDescpriotr attrDescpriotr = attributeDescpriotrMap.get(this.nameMapping.toIntermediateNameFromColumnName(columnName));
        if (attrDescpriotr == null) {
            return null;
        }
        if (!attrDescpriotr.isWriteable()) {
            return null;
        }
        int sqlType = rsmd.getColumnType(columnIndex);
        ValueType valueType = this.getValueType(attrDescpriotr, sqlType);
        if (valueType == null) {
            return null;
        }
        BasicResultSetToObjectEntry propertySetter = new BasicResultSetToObjectEntry(columnName, valueType, sqlType, columnIndex, attrDescpriotr);
        return propertySetter;
    }

    protected Map<String, AttributeDescpriotr> attributeDescpriotrNameMap() {
        HashMap<String, AttributeDescpriotr> attributeDescpriotrNameMap = new HashMap<String, AttributeDescpriotr>();
        PropertyAttributeDescpritor.putDescriptorToMap(this.baseClass, attributeDescpriotrNameMap);
        return attributeDescpriotrNameMap;
    }

    protected ValueType getValueType(AttributeDescpriotr attrDescriptor, int sqlType) {
        return TypeMappings.getValueType(attrDescriptor.getType(), sqlType);
    }

    protected ValueType getValueType(Class<E> type, int sqlType) {
        return TypeMappings.getValueType(type, sqlType);
    }

    public Class<E> getBaseClass() {
        return this.baseClass;
    }
}

