/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.rstable;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import jp.sourceforge.sxdbutils.rstable.ResultColumnMetaData;
import jp.sourceforge.sxdbutils.util.JdbcMetaUtil;

public class BasicResultColumnMetaData
implements ResultColumnMetaData {
    private final String columnName;
    private final String columnClassName;
    private final String catalogName;
    private final int columnDisplaySize;
    private final int columnType;
    private final String columnTypeName;
    private final int precision;
    private final int scale;
    private final String schemaName;
    private final String tableName;
    private final boolean signed;

    public BasicResultColumnMetaData(ResultSetMetaData meta, int columnNo) throws SQLException {
        this.columnName = JdbcMetaUtil.getColumnName(meta, columnNo).toUpperCase();
        this.columnClassName = meta.getColumnClassName(columnNo);
        this.catalogName = meta.getCatalogName(columnNo);
        this.columnDisplaySize = meta.getColumnDisplaySize(columnNo);
        this.columnType = meta.getColumnType(columnNo);
        this.columnTypeName = meta.getColumnTypeName(columnNo);
        this.precision = meta.getPrecision(columnNo);
        this.scale = meta.getScale(columnNo);
        this.schemaName = meta.getSchemaName(columnNo);
        this.tableName = meta.getTableName(columnNo);
        this.signed = meta.isSigned(columnNo);
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getColumnClassName() {
        return this.columnClassName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public int getColumnDisplaySize() {
        return this.columnDisplaySize;
    }

    public int getColumnType() {
        return this.columnType;
    }

    public String getColumnTypeName() {
        return this.columnTypeName;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isSigned() {
        return this.signed;
    }
}

