<?php

require_once dirname(__FILE__) . '/../SyL_XmlReader.php';

/**
 * XML RPCNGXgʃp[T[NX
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRpcClientReader.php,v 1.1 2007/03/17 13:53:07 seasonstream Exp $
 * @link      http://www.syl.jp/
 */
class SyL_XmlRpcClientReader extends SyL_XmlReader
{
    /**
     * G[tO
     * 
     * @access private
     * @var bool
     */
    var $error = false;
    /**
     * G[R[h
     * 
     * @access private
     * @var int
     */
    var $error_code = 0;
    /**
     * G[bZ[W
     * 
     * @access private
     * @var string
     */
    var $error_message = '';
    /**
     * ʒl
     * 
     * @access private
     * @var mixed
     */
    var $value = null;

    /**
     * XMLf[^e擾nh\bh
     * I[o[Ch
     *
     * @access protected
     * @param string XML͒̃pX
     * @param string XML̃^Ȏl
     * @param string XML̃^O̒l
     */
    function getElement($current_path, $attribute, $text)
    {
        static $depth = 0;
        static $keys = array();
        static $fault_string = '';

//echo $current_path . "<br>";

        switch ($current_path) {
        // =============================
        // G[n
        // =============================
        case '/methodResponse/fault':
            $this->error = true;
            break;
        case '/methodResponse/fault/value/struct/member/name':
            $fault_string = $text;
            break;
        case '/methodResponse/fault/value/struct/member/value':
        case '/methodResponse/fault/value/struct/member/value/int':
        case '/methodResponse/fault/value/struct/member/value/i4':
        case '/methodResponse/fault/value/struct/member/value/string':
            if ($text !== null) {
                switch ($fault_string) {
                case 'faultCode':   $this->error_code    = $text; break;
                case 'faultString': $this->error_message = $text; break;
                }
            }
            break;

        // =============================
        // n
        // =============================
        case '/methodResponse/params':
            $this->error = false;
            break;

        case '/methodResponse/params/param/value';
            if ($text !== null) {
                $key = $this->getCurrentKey($keys);
                if ($key !== null) {
                    $this->value[$key] = $text;
                } else {
                    $this->value = $text;
                }
            }
            break;
        case '/methodResponse/params/param/value/dateTime.iso8601':
            if (preg_match('/^(\d{4})(\d{2})(\d{2})T(\d{2}:\d{2}:\d{2})$/', $this->value, $matches)) {
                $text = $matches[1] . '/' . $matches[2] . '/' . $matches[3] . ' ' . $matches[4];
            }
        case '/methodResponse/params/param/value/string':
        case '/methodResponse/params/param/value/base64':
            $key = $this->getCurrentKey($keys);
            if ($key !== null) {
                $this->value[$key] = $text;
            } else {
                $this->value = $text;
            }
            break;
        case '/methodResponse/params/param/value/i4':
        case '/methodResponse/params/param/value/int':
            $key = $this->getCurrentKey($keys);
            if ($key !== null) {
                $this->value[$key] = (int)$text;
            } else {
                $this->value = (int)$text;
            }
            break;
        case '/methodResponse/params/param/value/double':
            $key = $this->getCurrentKey($keys);
            if ($key !== null) {
                $this->value[$key] = (float)$text;
            } else {
                $this->value = (float)$text;
            }
            break;
        case '/methodResponse/params/param/value/boolean':
            $key = $this->getCurrentKey($keys);
            if ($key !== null) {
                $this->value[$key] = (bool)$text;
            } else {
                $this->value = (bool)$text;
            }
            break;
        case '/methodResponse/params/param/value/array':
            $keys[] = -1;
        case '/methodResponse/params/param/value/struct':
            $key = $this->getCurrentKey($keys, $depth);
            if ($key !== null) {
                $this->value[$key] = array();
            } else {
                $this->value = array();
            }
            break;
        case '/methodResponse/params/param/value/struct/member/name':
            $keys[] = (string)$text;
            break;

        default:
echo $current_path . "\n";
            if (preg_match('/^(\/methodResponse\/params\/param\/value)\/(struct\/member|array\/data)\/(.*)value$/', $current_path, $matches)) {
                if ($text !== null) {
                    $current_path = $matches[1] . '/string';
                    $this->getElement($current_path, $attribute, $text);
                }
            } else if (preg_match('/^(\/methodResponse\/params\/param\/value)\/(struct\/member|array\/data)\/(.*)value\/(string|i4|int|double|boolean|dateTime\.iso8601|base64)$/', $current_path, $matches)) {
                $current_path = $matches[1] . '/' . $matches[4];
                $this->getElement($current_path, $attribute, $text);
            } else if (preg_match('/^(\/methodResponse\/params\/param\/value)\/(struct\/member|array\/data)\/(.*)value\/(array|struct)$/', $current_path, $matches)) {
                $depth++;
                $current_path = $matches[1] . '/' . $matches[4];
echo " -- " . $current_path . "\n";
echo $depth . "\n";
                $this->getElement($current_path, $attribute, $text);
                $depth--;
            } else if (preg_match('/^(\/methodResponse\/params\/param\/value)\/(struct\/member|array\/data)\/(.*)value\/(struct\/member|array\/data)\/value\/(string|i4|int|double|boolean|dateTime\.iso8601|base64)$/', $current_path, $matches)) {
                $current_path = $matches[1] . '/' . $matches[5];
echo " -- " . $current_path . "\n";
echo $depth . "\n";
                $this->getElement($current_path, $attribute, $text);
            }
        }
    }

    /**
     * Jg̃L[l擾
     *
     * @access private
     * @param array L[lz
     */
    function getCurrentKey(&$keys)
    {
        if (count($keys) > 0) {
            $key = $keys[count($keys)-1];
            return is_int($key) ? ++$keys[count($keys)-1] : $key;
        } else {
            return null;
        }
    }

    /**
     * G[
     *
     * @access public
     * @return bool true: G[Afalse: G[Ȃ
     */
    function isError()
    {
        return $this->error;
    }

    /**
     * G[R[h擾
     *
     * @access public
     * @return string G[R[h
     */
    function getErrorCode()
    {
        return $this->error_code;
    }

    /**
     * G[bZ[W擾
     *
     * @access public
     * @return string G[bZ[W
     */
    function getErrorMessage()
    {
        return $this->error_message;
    }

    /**
     * XMLRPC̖߂l擾
     *
     * @access public
     * @return mixed XMLRPC̖߂l
     */
    function getValue()
    {
        return $this->value;
    }
}

?>
