<?php 

/*
 * postLDAPadmin
 *
 * Copyright (C) 2006,2007 DesigNET, INC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
/***********************************************************
 * Mail
 *
 * $RCSfile: index.php,v $
 * $Revision: 1.00 $
 * $Date: 2015/12/07 13:21:00 $
 **********************************************************/
include_once("lib/dglibcommon");
include_once("../initial");
include_once("lib/dglibpage");
include_once("lib/dglibsess");
include_once("lib/dglibsylas");

/********************************************************
 * ƥڡ
 ********************************************************/

define("TMPLFILE",         "maillogsearch.tmpl");
define("OPERATION",        "MAIL logsearch");
define("SELECT_GROUP_SQL", "SELECT loggroup.group_id, loggroup.group_name, loginfo.log_type, loginfo.facility_name ". 
                           "FROM loggroup JOIN loginfo ON loggroup.log_id=loginfo.log_id WHERE log_type='mail';");
define("SELECT_FACILITY_SQL", "SELECT loginfo.facility_name, loginfo.search_tab, loginfo.app_name " .
                              "FROM loggroup JOIN loginfo ON loggroup.log_id=loginfo.log_id WHERE group_id=%s;");
define("MAIL_SEARCH_SQL",   "SELECT DeviceReportedTime, FromHost, Message " .
                            "FROM %s " .
                            "AND FromHost IN (SELECT hosts.host_name From hosts JOIN search_hosts on hosts.host_id=search_hosts.host_id WHERE group_id=%s)" .
                            " ORDER BY DeviceReportedTime desc LIMIT %s ;");

/*********************************************************
 * set_tag_data($post, &$tag)
 *
 * ΥåȤ򤹤
 *
 * []
 *       $post       ϤäƤ
 *       $tag               
 * [֤]
 *       ʤ
 **********************************************************/
function set_tag_data($post, &$tag)
{
    /*24դ*/
    $daylist = getdate(time() - 86400);

    /*   */
    $javascript = <<<EOD
    function allSubmit(url, page) {
        document.search_condition.action = url;
        document.search_condition.page.value = page;
        document.search_condition.submit();
    }
EOD;

    /*̤Ѥ륿򥻥åȤ*/
    /*<<TITLE>>,<<MESSAGE>>,<<SK>>,<<TOPIC>>,<<TAB>>*/
    set_tag_common($tag, $javascript);

    /* Υ쥯ȥܥå */
    if (isset($post["loggroup"])) {
        $selected_log =$post["loggroup"];
    } else {
        $selected_log = -1;
    }
    $ret = make_mail_log_option($selected_log, $option);
    if ($ret === FALSE) {
        return FALSE;
    }
    $tag["<<LOG>>"] = $option;

    /* ԤΥƥȥܥå */
    if (isset($post["sendaddr"])) {
        $tag["<<SEARCH_FROM>>"] = escape_html($post["sendaddr"]);
    }

    /* 襢ɥ쥹Υƥȥܥå */
    if (isset($post["reciveaddr"])) {
        $tag["<<SEARCH_TO>>"] = escape_html($post["reciveaddr"]);
    }

    /*ԥɥ쥹ꥹȥܥå*/
    if (isset($post["sendrule"])) {
        $list = $post["sendrule"];
    } else {
        $list = "0";
    }
    $tag["<<FROM_RULE>>"] = make_checked_list($list);
    /*襢ɥ쥹ꥹȥܥå*/
    if (isset($post["reciverule"])) {
        $list = $post["reciverule"];
    } else {
        $list = "0";
    }
    $tag["<<TO_RULE>>"] = make_checked_list($list);

    /* ϻ֥쥯ȥܥå */
    $option = array("0" => "",
                    "1" => "",
                    "2" => "",
                    "3" => "",
                    "4" => "",
                    "5" => ""
                   );
    if (isset($post["starttime"])) {
        $starttime =$post["starttime"];
    } else {

        /*24λ֤򥻥å*/
        $starttime = array("0" => strval($daylist["year"]),
                           "1" => strval($daylist["mon"]),
                           "2" => strval($daylist["mday"]),
                           "3" => strval($daylist["hours"]),
                           "4" => strval($daylist["minutes"]),
                           "5" => strval($daylist["seconds"])
                          );
    }

    make_time_select_option($starttime, $option);
    $tag["<<START_YEAR_OPTION>>"]   = $option["0"];
    $tag["<<START_MONTH_OPTION>>"]  = $option["1"];
    $tag["<<START_DATE_OPTION>>"]   = $option["2"];
    $tag["<<START_HOUR_OPTION>>"]   = $option["3"];
    $tag["<<START_MINUTE_OPTION>>"] = $option["4"];
    $tag["<<START_SECOND_OPTION>>"] = $option["5"];

    /* λ֤Υ쥯ȥܥå */
    $option = array("0" => "",
                    "1" => "",
                    "2" => "",
                    "3" => "",
                    "4" => "",
                    "5" => ""
                   );
    if (isset($post["endtime"])) {
        $endtime =$post["endtime"];
 } else {

        /*--ǯ--------ʬ--äɽ*/
        $endtime = array("0" => -2,
                         "1" => -2,
                         "2" => -2,
                         "3" => -2,
                         "4" => -2,
                         "5" => -2
                        );
    }
    make_time_select_option($endtime, $option);
    $tag["<<END_YEAR_OPTION>>"]     = $option["0"];
    $tag["<<END_MONTH_OPTION>>"]    = $option["1"];
    $tag["<<END_DATE_OPTION>>"]     = $option["2"];
    $tag["<<END_HOUR_OPTION>>"]     = $option["3"];
    $tag["<<END_MINUTE_OPTION>>"]   = $option["4"];
    $tag["<<END_SECOND_OPTION>>"]   = $option["5"];

    return TRUE;
}

/*********************************************************
 * make_hidden
 *
 * hiddenΥե
 *
 * []
 *       $post               Ϥ줿
 *       $tag                ֤
 *
 * [֤]
 *       TRUE                
 *       FALSE               ۾
 **********************************************************/
function make_hidden($post, &$tag)
{
    /* ֤ͤѿ */
    $loggroup   = $post["loggroup"];
    $sendaddr   = escape_html($post["sendaddr"]);
    $reciveaddr   = escape_html($post["reciveaddr"]);
    $start      = $post["starttime"];
    $end        = $post["endtime"];
    $s_year     = $start[0];
    $s_month    = $start[1];
    $s_date     = $start[2];
    $s_hour     = $start[3];
    $s_minute   = $start[4];
    $s_second   = $start[5];
    $e_year     = $end[0];
    $e_month    = $end[1];
    $e_date     = $end[2];
    $e_hour     = $end[3];
    $e_minute   = $end[4];
    $e_second   = $end[5];
    $sesskey    = escape_html($post["sk"]);

    /*hidden*/
    $hidden = <<<EOD
  <form method="post" name="search_condition">
  <input type="hidden" name="page">
  <input type="hidden" name="loggroup" value="$loggroup">
  <input type="hidden" name="sendaddr" value="$sendaddr">
  <input type="hidden" name="reciveaddr" value="$reciveaddr">
  <input type="hidden" name="starttime[0]" value="$s_year">
  <input type="hidden" name="starttime[1]" value="$s_month">
  <input type="hidden" name="starttime[2]" value="$s_date">
  <input type="hidden" name="starttime[3]" value="$s_hour">
  <input type="hidden" name="starttime[4]" value="$s_minute">
  <input type="hidden" name="starttime[5]" value="$s_second">
  <input type="hidden" name="endtime[0]" value="$e_year">
  <input type="hidden" name="endtime[1]" value="$e_month">
  <input type="hidden" name="endtime[2]" value="$e_date">
  <input type="hidden" name="endtime[3]" value="$e_hour">
  <input type="hidden" name="endtime[4]" value="$e_minute">
  <input type="hidden" name="endtime[5]" value="$e_second">
  <input type="hidden" name="sk" value="$sesskey">
  <input type="hidden" name="next_button" value="search">
</form>
    
EOD;

    $tag["<<HIDDEN>>"] =  $hidden;
    return;
}

/*********************************************************
 * set_loop_tag
 *
 * 롼ץ
 *
 * []
 *       $page               ڡ
 *       $looptag            롼ץ
 *       $sesskey            å󥭡
 *       $post               $_POST
 *
 * [֤]
 *       TRUE                
 *       FALSE               ۾
 **********************************************************/
function set_loop_tag($page, &$looptag, $sesskey, $post)
{
    global $web_conf;

    /* 롼ץ */
    $start = ($page - 1) * $web_conf['sylas']['displaylines'];
    $end   = ($web_conf['sylas']['displaylines'] - 1) + $start;
    $k = 0; 

    for ( ; $start <= $end ; $start++) {
        
        if (isset($_SESSION["result"][$start]) === FALSE) {
            break;
        }

        /* 롼ץͤ */
        $log_date = date("Y-m-d H:i:s" , $_SESSION["result"][$start]["date"]);
        $looptag[$k]["<<LOG_DATE>>"] = $log_date;
        $looptag[$k]["<<LOG_FROM>>"] = $_SESSION["result"][$start]["from"];
        $looptag[$k]["<<LOG_TO>>"] = $_SESSION["result"][$start]["to"];
        $looptag[$k]["<<LOG_STATUS>>"] = $_SESSION["result"][$start]["status"];

        /*ܺ٥ܥ*/
        $looptag[$k]["<<MORE>>"] =  "<button class=\"mail_button\" type=\"submit\" name=\"more\" value=\"".$k."\">ܺ</button>";
        $looptag[$k]["<<E_SESS>>"] = $sesskey;

        /*QIDå*/
        if (strpos($_SESSION["result"][$start]["qid"], "NOQUEUE") === FALSE) {
            $looptag[$k]["<<S_SY>>"] = "--";
            $looptag[$k]["<<S_SM>>"] = "--";
            $looptag[$k]["<<S_SD>>"] = "--";
            $looptag[$k]["<<S_SH>>"] = "--";
            $looptag[$k]["<<S_SMI>>"] = "--";
            $looptag[$k]["<<S_SS>>"] = "--";
                
            $looptag[$k]["<<E_SY>>"] = "--";
            $looptag[$k]["<<E_SM>>"] = "--";
            $looptag[$k]["<<E_SD>>"] = "--";
            $looptag[$k]["<<E_SH>>"] = "--";
            $looptag[$k]["<<E_SMI>>"] = "--";
            $looptag[$k]["<<E_SS>>"] = "--";
            $looptag[$k]["<<QID>>"] = $_SESSION["result"][$start]["qid"];
        } else {

            $half_date = explode(" ", $log_date);
            $half_date2 = explode("-", $half_date[0]);
            $half_time = explode(":", $half_date[1]);
            $s_year = preg_replace("/^0/", "", $half_date2[0]); 
            $s_mon = preg_replace("/^0/", "", $half_date2[1]);
            $s_day = preg_replace("/^0/", "", $half_date2[2]);
            $s_hour = preg_replace("/^0/", "", $half_time[0]);
            $s_min = preg_replace("/^0/", "", $half_time[1]);
            $s_sec = preg_replace("/^0/", "", $half_time[2]);

            $looptag[$k]["<<S_SY>>"] = $s_year;
            $looptag[$k]["<<S_SM>>"] = $s_mon;
            $looptag[$k]["<<S_SD>>"] = $s_day;
            $looptag[$k]["<<S_SH>>"] = $s_hour;
            $looptag[$k]["<<S_SMI>>"] = $s_min;
            $looptag[$k]["<<S_SS>>"] = $s_sec;
            $looptag[$k]["<<E_SY>>"] = $s_year;
            $looptag[$k]["<<E_SM>>"] = $s_mon;
            $looptag[$k]["<<E_SD>>"] = $s_day;
            $looptag[$k]["<<E_SH>>"] = $s_hour;
            $looptag[$k]["<<E_SMI>>"] = $s_min;
            $looptag[$k]["<<E_SS>>"] = $s_sec;
            $looptag[$k]["<<QID>>"] = "NOQUEUE";
        }
        $looptag[$k]["<<HOSTNAME>>"] = $_SESSION["result"][$start]["host"];
        $looptag[$k]["<<E_LOG>>"] = $post["loggroup"];
        $k++;
    }
    return;
}

/*  */
$tag["<<TITLE>>"]               = "";
$tag["<<JAVASCRIPT>>"]          = "";
$tag["<<SK>>"]                  = "";
$tag["<<TOPIC>>"]               = "";
$tag["<<MESSAGE>>"]             = "";
$tag["<<TAB>>"]                 = "";
$tag["<<LOG>>"]                 = "";
$tag["<<SEARCH_FROM>>"]         = "";
$tag["<<SEARCH_TO>>"]           = "";
$tag["<<FROM_RULE>>"]           = "";
$tag["<<TO_RULE>>"]             = "";
$tag["<<STATUS>>"]              = "";
$tag["<<START_YEAR_OPTION>>"]   = "";
$tag["<<START_MONTH_OPTION>>"]  = "";
$tag["<<START_DATE_OPTION>>"]   = "";
$tag["<<START_HOUR_OPTION>>"]   = "";
$tag["<<START_MINUTE_OPTION>>"] = "";
$tag["<<START_SECOND_OPTION>>"] = "";
$tag["<<END_YEAR_OPTION>>"]     = "";
$tag["<<END_MONTH_OPTION>>"]    = "";
$tag["<<END_DATE_OPTION>>"]     = "";
$tag["<<END_HOUR_OPTION>>"]     = "";
$tag["<<END_MINUTE_OPTION>>"]   = "";
$tag["<<END_SECOND_OPTION>>"]   = "";
$tag["<<SEARCH_COUNT>>"]        = 0;/*..*/
$tag["<<COMMENT_START>>"]       = "<!--";
$tag["<<COMMENT_END>>"]         = "-->";
$tag["<<PRE>>"]                 = "";
$tag["<<NEXT>>"]                = "";
$tag["<<HIDDEN>>"]              = "";
$page = 0;
/*********************************************************
 * make_chcked_list()
 *
 * Υꥹȥ쥯ȥܥåΥץ
 * 
 *
 * []
 *       $list              $_POSTϤäƤ
 *       
 *
 * [֤]
 *      $optionlist 
 **********************************************************/
function make_checked_list($list)
{
    $selected = array("0" => "",
                      "1" => "",
                     );
    $optionlist = "";
    if($list === "0"){
        $selected[0] = " selected";
    } else {
        $selected[1] = " selected";
    }  
    $optionlist .= "<option value=0 ".$selected[0].">Ȱפ</option>\n";
    $optionlist .= "<option value=1 ".$selected[1].">ޤ</option>\n";
    return $optionlist;
}

/*********************************************************
 * make_mail_log_option()
 *
 * 롼פΥ쥯ȥܥåΥץ
 * (mail)
 *
 * []
 *       $post_group_id      selectedˤ
 *       $option
 *
 * [֤]
 *       ʤ
 **********************************************************/
function make_mail_log_option($post_group_id, &$option)
{

    /* 롼׾MySQL */
    $ret = get_data(SELECT_GROUP_SQL, $data);
    if ($ret === FALSE) {
        return FALSE;
    }

    /*μबmailΥ롼פ¸ߤʤȤ*/
    $option = "";
    if (isset($data[0]) === FALSE) {
        /* 쥯ȥܥå */
        $option .= "<option value=\"-1\" selected>----------</option>";
    } else {
        /*μबmailΥ롼פ¸ߤȤ*/
        foreach ($data as $one_data) {
            $group_name = escape_html($one_data["group_name"]);
            $group_id   = escape_html($one_data["group_id"]);
            /* POSTϤäƤͤƱ(ݻ) */
            if ($one_data["group_id"] === $post_group_id) {
                $select = " selected";
            } else {
                $select = "";
            }
            $option .= "<option value=\"".$group_id."\"".$select.">".$group_name."</option>";
        }
    }
    return TRUE;
}

/*********************************************************
 * check_mail_search_condition()
 *
 * mailθå
 *
 * []
 *       $post               Ϥ줿
 *
 * [֤]
 *       TRUE                
 *       FALSE               ۾
 **********************************************************/
function check_mail_search_condition($post)
{
    global $msgarr;
    global $err_msg;
    global $log_msg;

    /**/
    $start = "";
    $end = "";

    /*Υå*/
    if (isset($post["loggroup"]) === FALSE || $post["loggroup"] == "-1") {
        $err_msg = $msgarr['28014'][SCREEN_MSG];
        return FALSE;
    }
      
    $strmaxlen = 256;
    /*ԥɥ쥹ϤƤȤʸʸå*/
    if (isset($post["sendaddr"])) {
        $ret = check_string($post["sendaddr"], $strmaxlen);
        if($ret !== 0) {
            /*retͤ1,2(ʸʸ泌顼)ΤȤ顼å*/
            $err_msg = $msgarr['41005'][SCREEN_MSG];
            return FALSE;
        }
    } else {
        $err_msg = $msgarr['41005'][SCREEN_MSG];
        return FALSE;
    } 

    /*Ծå*/
    if (isset($post["sendrule"]) === FALSE) {
        $err_msg = $msgarr['41005'][SCREEN_MSG];
        return FALSE;
    }

    /*襢ɥ쥹ϤƤȤʸʸå*/
    if (isset($post["reciveaddr"])) {
        $ret = check_string($post["reciveaddr"], $strmaxlen);
        if($ret !== 0) {
            /*retͤ1,2(ʸʸ泌顼)ΤȤ顼å*/
            $err_msg = $msgarr['41006'][SCREEN_MSG];
            return FALSE;
        }
    } else {
        $err_msg = $msgarr['41006'][SCREEN_MSG];
        return FALSE;
    }

    if (isset($post["reciverule"]) === FALSE) {
        $err_msg = $msgarr['41006'][SCREEN_MSG];
        return FALSE;
    }

    /*֤Υå*/
    /**/
    if (isset($post["starttime"])) {
        $start_arr = $post["starttime"];
    } else {
        $err_msg = $msgarr['41008'][SCREEN_MSG];
        return FALSE;
    }
    $ret = check_time_format($start_arr, START);
    if ($ret === FALSE) {
        $err_msg = $msgarr['41008'][SCREEN_MSG];
        return FALSE;
    }
    /*λ*/
    if (isset($post["endtime"])) {
        $end_arr = $post["endtime"];
    } else {
        $err_msg = $msgarr['41009'][SCREEN_MSG];
        return FALSE;
    }
    $ret = check_time_format($end_arr, END);
    if ($ret === FALSE) {
        $err_msg = $msgarr['41009'][SCREEN_MSG];
        return FALSE;
    }

    /*ϤȽλå*/

    /*λǯꤵƤʤȤ*/
    if ($end_arr[0] === "--") {
        /*ǯ*/
        $end_arr[0] = date("Y");
    }

    /*ꤵƤʤ*/
    if ($end_arr[1] === "--") {
        $end_arr[1] = 12;
    }

    /*ꤵƤʤ*/
    if ($end_arr[2] === "--") {
        $end_arr[2] = date("t", strtotime($end_arr[0]. "-" .$end_arr[1]));
    }

    /*ꤵƤʤ*/
    if ($end_arr[3] === "--") {
        $end_arr[3] = 23;
    }

    /*ʬꤵƤʤ*/
    if ($end_arr[4] === "--") {
        $end_arr[4] = 59;
    }

    /*äꤵƤʤ*/
    if ($end_arr[5] === "--") {
        $end_arr[5] = 59;
    }
        
    $start = sprintf("%04d%02d%02d%02d%02d%02d", $start_arr[0], $start_arr[1], $start_arr[2], $start_arr[3], $start_arr[4], $start_arr[5]);
    $end = sprintf("%04d%02d%02d%02d%02d%02d", $end_arr[0], $end_arr[1], $end_arr[2], $end_arr[3], $end_arr[4], $end_arr[5]);

    if ($start > $end) {
        $err_msg = $msgarr['28018'][SCREEN_MSG];
        return FALSE;
    }
    return TRUE;
}

/*********************************************************
 * check_string()
 *
 * mail̤ͥåԤʤ
 *
 * []
 *        $string      ʸ
 *        $maxlen      ʸĹ
 *
 * [֤]
 *       0             
 *       1             ʸĹ顼
 *       2             ʸ泌顼
**********************************************************/
function check_string($string, $maxlen)
  {
     $length = strlen($string);
     if ($length > $maxlen) {
         return 1;
     }

     /* Ⱦѱ羮ʸ국Τߵ */
     $num = "0123456789";
     $sl = "abcdefghijklmnopqrstuvwxyz";
     $ll = strtoupper($sl);
     $sym = "!#$%&'*+-/=?^_{}~.@";
     $allow_letter = $num . $sl . $ll . $sym;
     if (strspn($string, $allow_letter) !== $length) {
         return 2;
     }

     return 0;
}


/*********************************************************
 * exec_mail_search
 *
 * ͥå򤷡˹פ
 *
 * []
 *       $post               ϤäƤ
 *
 * [֤]
 *       0               
 *       1               ϥå
 *       2               mysql
 **********************************************************/
function exec_mail_search($post)
{
    global $web_conf;
    global $msgarr;
    global $err_msg;
    global $log_msg;

    /*å*/
    $_SESSION = array();

    /**/
    $data_count = 0;
    $maxsearch = 0;
    $num_key = 0;
    $num = array();
    $num_data = array();
    $session = array();
    $noqsession = array();
    $noqkey = 0;
 
    /*ͥå*/
    $ret = check_mail_search_condition($post);
    if ($ret === FALSE) {
        return(1);
    }

    /*MySQL³*/
    $conn = MySQL_connect_server();
    if ($conn === FALSE) {
        return(2);
    }

    /* פ "MYSQL" ξ */
    if ($web_conf['sylas']['searchtype'] === MYSQL) {

        /*MailSQL*/
        make_mail_search_sql($post, $search_sql, $conn);

        /*MySQL*/
        $result = MySQL_exec_query($conn, $search_sql);
        if ($result === FALSE) {
            mysqli_close($conn);
            return(2);
        }

        /*MySQLϿ줿ơ֥ξ˳Ǽ*/
        MySQL_get_data($result, $data);
        mysqli_close($conn);

    /* פ "elasticsearch" ξ */
    } else if ($web_conf['sylas']['searchtype'] === ELASTICSEARCH) {

        /* 롼פ򸡺 */
        $ret = get_loggroup($conn, $post['loggroup'], $groupdata);
        mysqli_close($conn);

        /* ƥ२顼(MYSQL³顼) */
        if ($ret === 2) {
            result_log(OPERATION . ":NG:" . $log_msg);
            return(1);

        /* 롼פ¸ߤ */
        } else if ($ret === 0) {

            $gettype = "mail";
            /* elasticsearchǡ */
            $elastic_data = get_elasticdata($groupdata, $post, $gettype);

            /* оݤelasticsearchФ³Ǥʤä */
            if ($elastic_data === NULL) {
                $err_msg = sprintf($msgarr['50000'][SCREEN_MSG], LOG_NAME_DISP);
                $log_msg = sprintf($msgarr['50000'][LOG_MSG], LOG_NAME_LOG);
                result_log(OPERATION . ":NG:" . $log_msg);
                syserr_display();
                return(1);
            }

            /* elasticserach֤ͤjsonǥ(Ϣ) */
            $xmlarr = json_decode($elastic_data);
            /* jsonǥɤɬפͤ */
            $data = extract_values($xmlarr);

            /* Ի */
            if ($data === false) {
                return(1);
            }
        }
    }

    /*ǡ١Ǥη$maxsearch*/
    $maxsearch = count($data);

    if ($maxsearch >= $web_conf['sylas']['maxsearchcount']) {     
        unset($data[$maxsearch -1]);
    }

    /*$sessionǼ*/
    foreach($data as $value) {

        if (preg_match("/(^NOQUEUE): (.*)from=<(.*)> to=<(.*)> proto/", $value["Message"], $NOQID)) {
            $session[$value["FromHost"]][$NOQID[1].$noqkey]["from"] = escape_html($NOQID[3]);
            $session[$value["FromHost"]][$NOQID[1].$noqkey]["to"] = escape_html($NOQID[4]);
            $session[$value["FromHost"]][$NOQID[1].$noqkey]["status"] = escape_html($NOQID[2]);
            $session[$value["FromHost"]][$NOQID[1].$noqkey]["date"] = escape_html(strtotime($value["DeviceReportedTime"]));
            $noqkey++;
       /*QIDɽ*/
       } elseif (preg_match("/^([A-F 0-9]*): /", $value["Message"], $QID)) {

            /*QID뤫ɤ*/
            if (isset($session[$value["FromHost"]][$QID[1]]) === FALSE) {

                /* QIDޤĤʤä顢˥å */
                $session[$value["FromHost"]][$QID[1]]["from"] = "";
                $session[$value["FromHost"]][$QID[1]]["to"] = "";
                $session[$value["FromHost"]][$QID[1]]["status"] = "";
                $session[$value["FromHost"]][$QID[1]]["date"] = escape_html(strtotime($value["DeviceReportedTime"]));
            }

            /*fromɽ*/
            if (preg_match("/from=<(.*)>/", $value["Message"], $from)) {
                $session[$value["FromHost"]][$QID[1]]["from"] = escape_html($from[1]);
            }

            /*toɽ*/
            if (preg_match("/to=<(.*)>, /", $value["Message"], $to)) {
                $session[$value["FromHost"]][$QID[1]]["to"] = escape_html($to[1]);
            }

            /*statusɽ*/
            if (preg_match("/status=(.*)/", $value["Message"], $status)) {
                $session[$value["FromHost"]][$QID[1]]["status"] = escape_html($status[1]);
            }
        }
    }

    /*ѿ*/
    foreach ($session as $num_HOST => $num_val1) {
        foreach ($num_val1 as $num_qid => $num_val2) {
            $num[$num_key]["host"] = $num_HOST;
            $num[$num_key]["qid"] = $num_qid;
            $num[$num_key]["from"] = $num_val2["from"];
            $num[$num_key]["to"] = $num_val2["to"];
            $num[$num_key]["date"] = $num_val2["date"];
            $num[$num_key]["status"] = $num_val2["status"];
            $num_key++;
        }
    }

    /*Ƚ*/
    foreach ($num as $key_num => $value_num) {
            $num_data[$key_num] = $value_num["date"];
    }

    /*߽˥*/
    array_multisort($num_data, SORT_DESC, $num);

    /*׽*/
    foreach ($num as $key_num => $val1) {

        /*Ծ׽*/
        if ($post["sendaddr"] !== "") {
            if ($post["sendrule"] === "0") {
                if ($post["sendaddr"] !== $val1["from"]) {
                     continue;
                }
            } elseif (strstr($val1["from"], $post["sendaddr"]) === FALSE) {
                continue;
            }
        }
 
        /*׽*/
        if ($post["reciveaddr"] !== "") {
            if ($post["reciverule"] === "0") {
                if ($post["reciveaddr"] !== $val1["to"]) {
                    continue;
                }
            } elseif (strstr($val1["to"], $post["reciveaddr"]) === FALSE) {
                continue;
            }
        }

        /*åǼ*/
        $_SESSION["result"][$data_count]["from"] = $val1["from"];
        $_SESSION["result"][$data_count]["to"] = $val1["to"];
        $_SESSION["result"][$data_count]["date"] = $val1["date"];
        $_SESSION["result"][$data_count]["status"] = $val1["status"];
        $_SESSION["result"][$data_count]["host"] = $val1["host"];
        $_SESSION["result"][$data_count]["qid"] = $val1["qid"];
        $data_count++;
    }

    /*ɽ*/
    if ($maxsearch <=  $web_conf['sylas']['maxsearchcount']) {
        $err_msg = sprintf($msgarr['41000'][SCREEN_MSG], $data_count);
    } else {
        $err_msg = sprintf($msgarr['41001'][SCREEN_MSG], $web_conf['sylas']['maxsearchcount'], $data_count);
    }

    return(0);
}

/*********************************************************
 * make_mail_search_sql()
 *
 * θSQL
 *
 * []
 *       $post              POST
 *       $sql               Ϥ줿
 *
 * [֤]
 *       ʤ 
 **********************************************************/
function make_mail_search_sql($post, &$sql, $conn)
{
    global $web_conf;
    
    /**/ 
    $end = "";
    $start = "";
    $search_time = "";
    $check_count = $web_conf['sylas']['maxsearchcount'] + 1;
    $search_sql = array();
    $facility_arr = array();
    $app_name = "";

    /* ־ʬ */
    $start_arr = $post["starttime"];
    $end_arr = $post["endtime"];
    /*ϤȽλå*/
    /*ǯꤵƤʤȤ*/
    if ($start_arr[0] !== "--") {
        /*ꤵƤʤ*/
        if ($start_arr[1] === "--") {
            $start_arr[1] = 1;
        }

        /*ꤵƤʤ*/
        if ($start_arr[2] === "--") { 
             $start_arr[2] = 1;
        }

        /*ꤵƤʤ*/
        if ($start_arr[3] === "--") { 
            $start_arr[3] = 0;
        }

        /*ʬꤵƤʤ*/
        if ($start_arr[4] === "--") { 
            $start_arr[4] = 0;
        }

        /*äꤵƤʤ*/
        if ($start_arr[5] === "--") { 
            $start_arr[5] = 0;
        }
        $start = sprintf("DeviceReportedTime >= \"%04d%02d%02d%02d%02d%02d\"", $start_arr[0], $start_arr[1], $start_arr[2], $start_arr[3], $start_arr[4], $start_arr[5]);
    } 

    /*λǯꤵƤʤȤ*/
    if ($end_arr[0] !== "--") {
        /*ꤵƤʤ*/
        if ($end_arr[1] === "--") {
            $end_arr[1] = 12;
        }

        /*ꤵƤʤ*/
        if ($end_arr[2] === "--") {
            $end_arr[2] = date("t", strtotime($end_arr[0]. "-" .$end_arr[1]));
        }

        /*ꤵƤʤ*/
        if ($end_arr[3] === "--") { 
            $end_arr[3] = 23;
        }

        /*ʬꤵƤʤ*/
        if ($end_arr[4] === "--") { 
            $end_arr[4] = 59;
        }

        /*äꤵƤʤ*/
        if ($end_arr[5] === "--") { 
            $end_arr[5] = 59;
        }
        $end = sprintf("DeviceReportedTime <= \"%04d%02d%02d%02d%02d%02d\"", $end_arr[0], $end_arr[1], $end_arr[2], $end_arr[3], $end_arr[4], $end_arr[5]);
    }
    if ($start_arr[0] === "--" && $end_arr[0] !== "--") {
        $search_time = " WHERE " . $end;
    } elseif ($start_arr[0] !== "--" && $end_arr[0] === "--") {
        $search_time = " WHERE " . $start;
    } elseif ($start_arr[0] !== "--" && $end_arr[0] !== "--") {
        $search_time = " WHERE " . $start . " AND " . $end;
    } else {
        $search_time = "WHERE";
    }

    $mysql_facilitynumbers = array(
                         "kern"     => 0,
                         "user"     => 1,
                         "mail"     => 2,
                         "daemon"   => 3,
                         "auth"     => 4,
                         "security" => 4,
                         "syslog"   => 5,
                         "lpr"      => 6,
                         "news"     => 7,
                         "uucp"     => 8,
                         "cron"     => 9,
                         "authpriv" => 10,
                         "ftp"      => 11,
                         "local0"   => 16,
                         "local1"   => 17,
                         "local2"   => 18,
                         "local3"   => 19,
                         "local4"   => 20,
                         "local5"   => 21,
                         "local6"   => 22,
                         "local7"   => 23);

    $sql_str = sprintf(SELECT_FACILITY_SQL,$post["loggroup"]); 
    $ret = get_data($sql_str, $data);
    if ($ret === FALSE) {
        return FALSE;
    }

    /*եƥ*/
    /* եƥʸ󤫤ֹѴ
    * (ǡ١ˤֹϿƤ) */
    $facilitynames = explode(" ", $data[0]["facility_name"]);

    foreach ($facilitynames as $facility_num => $facility_name) {
        if (isset ($mysql_facilitynumbers["$facility_name"])){
            $facility_arr[] = "Facility=". $mysql_facilitynumbers["$facility_name"];
        }
    }
    $facility_values = implode(" OR ", $facility_arr);
    if ($facility_values !== "") {
       $facility_values = " AND (" . $facility_values . ")";
    }
    
   /*ơ֥*/
   if ($data[0]["search_tab"] === "") {
       $search_tab =  mysqli_real_escape_string($conn, $web_conf["sylas"]["defaultsearchtable"]);
   } else {
       $search_tab = mysqli_real_escape_string($conn, $data[0]["search_tab"]);
   }

   /*ץꥱ*/
   if ($data[0]["app_name"] !== "") {
       $app_name = " AND SysLogTag LIKE \"". mysqli_real_escape_string($conn, $data[0]["app_name"])."%\"";
   }

   /*ơ֥ȴ֤ȥեƥȥץꥱ*/
   $tab_time_facility_app = $search_tab . $search_time . $facility_values. $app_name;   

   /* SQL */
   $sql = sprintf(MAIL_SEARCH_SQL, $tab_time_facility_app, $post["loggroup"], $check_count);

   return;
}

/*********************************************************
 * get_mailpage
 *
 * ڡڡμ
 *
 * []
 *       $data_count        ɽ
 *       $page              ڡ
 *       $tag               
 * [֤]
 *       ʤ
 **********************************************************/
function get_mailpage($data_count, $page, &$tag)
{
    global $web_conf;

        /* ɽ(0ڡɽ)ξ硢ä˲⤷ʤ */
    if ($page === 0) {
        return;
    }
    /* =====  ===== */

    /* ڡ */
    $all_page = ceil($data_count / $web_conf["sylas"]["displaylines"]);
    if ($all_page === 0) {
        $all_page = 1;
    }

    /* ڡʾοϤäƤǸΥڡɽ */
    if ($page >= $all_page) {
        $page = $all_page;
    }
    /* ǽΥڡǤʤڡɽ */
    if ($page > 1) {
        $previous_page = $page - 1;
        $tag["<<PRE>>"] = "<a href=\"#\" onClick=\"allSubmit('index.php', '$previous_page')\">ڡ</a>";
    }

    /* ǸΥڡǤʤмڡɽ */
    if ($page !== $all_page) {
        $next_page = $page + 1;
        $tag["<<NEXT>>"] = "<a href=\"#\" onClick=\"allSubmit('index.php', '$next_page')\">ڡ</a>";
    }
    /* ڡֹ֤ */
    $tag["<<PAGE_NUM>>"] = $page;

    return;
}

/****************************************
*                               *
****************************************/

/* ե롢ִեɹåå */
$ret = init();
if ($ret === FALSE) {
    syserr_display();
    exit (1);
}
$looptag = array();


/****************************************
*                main                   *
****************************************/

/* ܥ󤬲줿Ȥ */
if (isset($_POST["search_button"])) {

    /*å󳫻*/
    session_start();

    /**/
    $data_count = 0;
    $page = 1;

    /*å*/
    $ret = exec_mail_search($_POST);
    if ($ret === 2) {
        result_log(OPERATION . ":NG:" . $log_msg);
        syserr_display();
        exit(1);
    } 
    if ($ret !== 1) {

        if (isset($_SESSION["result"])) {
            /*$_SESSION$data_count*/
            $data_count = count($_SESSION["result"]);
        }
        $tag["<<COMMENT_START>>"]       = "";
        $tag["<<COMMENT_END>>"]         = "";
        $tag["<<SEARCH_COUNT>>"]        = $data_count;
        
        /* 롼ץκ */
        set_loop_tag($page, $looptag, $sesskey, $_POST);

        /* ɽη */
        get_mailpage($data_count, $page, $tag);

        /*hidden*/
        /* ݻhidden */
        make_hidden($_POST, $tag);
    }
}

/* ڡ⤷ϼڡ줿Ȥ */
if (isset($_POST["next_button"])) {

    /*å󳫻*/
    session_start();

    /**/
    $data_count = 0;

    /* ڡϤäƤȤPOST줿ͤ *
     * ϤäƤƤʤ1ڡ */
    if (isset($_POST["page"])) {
        $page = $_POST["page"];
    } else {
        $page = "1";
    } 

    if (isset($_SESSION["result"])) {
        /*$_SESSION$data_count*/
        $data_count = count($_SESSION["result"]);
    }
    $tag["<<COMMENT_START>>"]       = "";
    $tag["<<COMMENT_END>>"]         = "";
    $tag["<<SEARCH_COUNT>>"]        = $data_count;

    /* 롼ץκ */
    set_loop_tag($page, $looptag, $sesskey, $_POST);

    /* ɽη */
    get_mailpage($data_count, $page, $tag);

    /*hidden*/
    /* ݻhidden */
    make_hidden($_POST, $tag);
}

/***********************************************************
 * ɽ
 **********************************************************/

/*   */
$ret = set_tag_data($_POST, $tag);
if ($ret === FALSE) {
    result_log(OPERATION . ":NG:" . $log_msg);
    syserr_display();
    exit(1);
}

/* ڡν */
$ret = display(TMPLFILE, $tag, $looptag, "<<STARTLOOP>>", "<<ENDLOOP>>");
if ($ret === FALSE) {
    result_log(OPERATION . ":NG:" . $log_msg);
    syserr_display();
    exit(1);
}

?>
