%{

/* $Id: rpn.y,v 1.1.1.1 2007/04/18 16:16:05 kohju Exp $ */

#include <stdio.h>
#include <string.h>
#include "rpn.h"

int yylex(void);
%}
%union {
    double       dval;
    unsigned int uival;
    LPSYMTBL	 symbol;
}

/* ȡϡ̤ͥ򸽤魯ʪʤΤǡ촹ˤϺٿդ򤹤뤳ȡ*/
%token	TERM
%token <dval>   NUMBER
%token <uival>	STRINGS
%token <uival>	QSTRINGS
%token <symbol> FUNC SYMBOL
%token LP
%token RP
%right COMMA
%left  AND OR
%right EQ NEQ GT GTE LT LTE
%right SUBSTITUTE
%left SUBOP ADDOP DOT
%left MULOP DIVOP
%nonassoc UMINUS
%nonassoc NOT

%type <dval> expression

%%

stpc.list	: stpc
		| stpc.list stpc
		  ;

stpc		: substitution TERM 
			{
			  printf("\n");
			  exp_num=1;
			}
		| TERM ;


substitution    : SYMBOL SUBSTITUTE expression {
		  printf("=>%s",$1->name);}
		| expression
		;

expression	: expression COMMA expression { exp_num++; }
		| expression AND expression{
                  printf("EXEC[:and,2]");}
		| expression OR  expression{
                  printf("EXEC[:or,2]");}
		| expression GT expression{
                  printf("EXEC[:gt,2]");}
		| expression GTE expression{
                  printf("EXEC[:ge,2]");}
		| expression LT expression{
                  printf("EXEC[:lt,2]");}
		| expression LTE expression{
                  printf("EXEC[:le,2]");}
		| expression EQ expression{
                  printf("EXEC[:eq,2]");}
		| expression NEQ expression{
                  printf("EXEC[:ne,2]");}
		| expression ADDOP expression {
                  printf("EXEC[:add,2]");}
		| expression SUBOP expression {
                  printf("EXEC[:sub,2]");}
		| expression MULOP expression {
                  printf("EXEC[:mul,2]");}
		| expression DIVOP expression {
                  printf("EXEC[:div,2]");}
		| SUBOP expression %prec UMINUS {
		  printf("NUM[%e]",(float)-1);
                  printf("EXEC[:mul,2]");}
		| NOT expression {
		  printf("EXEC[:not,1]");}
		| LP expression RP {
		}
		| NUMBER {	/*  */
		  printf("NUM[%e]",(float)$1);}
		| STRINGS {	/* ʸ */
		  printf("STR[%s]",tblstr[$1]);}
		| QSTRINGS {	/* 󥰥륯Ȥ줿ʸ */
		  printf("QSTR[%s]",tblstr[$1]);}
		| SYMBOL {		/* ѿ */
		  printf("VAR[%s]",$1->name);}
		| SYMBOL LP expression RP { /* ؿ */
                  printf("EXEC[%s,%d]",$1->name,exp_num);
		  exp_num=1;}
		| SYMBOL LP RP { /* ؿ */
                  printf("EXEC[%s,0]",$1->name);
		  exp_num=1;}
		| expression DOT SYMBOL { /* short function "var.func" */
		  printf("EXEC[%s,%d]",$3->name,exp_num);
		  exp_num=1;}
		;

%%
