<?php
/************************************************************************
	UebiMiau is a GPL'ed software developed by 
	 - Aldoir Ventura - aldoir@users.sourceforge.net
	 - http://uebimiau.sourceforge.net So Paulo - Brasil
   		
	***********************************************************************
	Version 3.2.0 Upgrades and templates developed by
	 - Todd Henderson - Lead Developer - http://tdah.us 
	 - Dave Rodgers - Developer - http://www.manvel.net 
	 - Laurent (AdNovea) - Developer - http://adnovea.free.fr
	 
	***********************************************************************
	 - Special thanks to the developers at 
	codeworxtech.com, tinymce.moxiecode.com
	telaen.org, phptoys.com, winged.info, ngcoders.com
	without help this project wouldn't be possible 
	
	***********************************************************************/

/**
 * This file provides a support for static smtp authentication calls
 * All parameters must be sended via POST and the 'action' is mandatory
 */
require("./inc/config/config.system.php");

session_name('Uebimiau');
session_start();

require(SYS_LIB);


// common session check, exit if no auth
$SS = new Session();
$sess = $SS->Load();

if(!$sess["auth"]) {
	echo "error: your session seems expired";
	die();
}

// cheking for main param
if(isset($_POST['action'])) {
	
	// config
	require(CFG_APPS);

	$prefs = load_prefs();
		
	$action = $_POST['action'];
	switch($action) {
	
		// send a read receipt
		case "sendReceipt":
			if(!isset($_POST['recipient']))
				break;

			$recipient = $_POST['recipient'];			
			$receiptSubj = $_POST['receipt_subj'];
			$receiptMsg = $_POST['receipt_msg'];
			
			require(CLASS_UEBI);
			$UM = new Uebimiau();

			require(CLASS_PHPMAILER);
		        require(CLASS_PHPMAILER_EXTRA);

			// init mailer
		        $mail = new PHPMailer_extra;
		       	$mail->PluginDir = "SYS_INC";
			$mail->SetLanguage("en",PATH_LANG_PHPMAILER);
			$mail->CharSet = $default_char_set;
			$mail->Hostname = getenv("SERVER_NAME");
			$mail->Host = $smtp_server;
			$mail->WordWrap = 76;
			$mail->Priority = 3;
			$mail->SMTPDebug = false;
			$mail->Mailer = $mailer_type;
			if ($phpmailer_sendmail != "") {
				$mail->Sendmail = $phpmailer_sendmail;
			}
			if ($phpmailer_timeout != 0) {
				$mail->Timeout = $phpmailer_timeout;
        		}

			// for password authenticated servers
			$mail->SMTPAuth = $use_password_for_smtp;
			$mail->Username = $sess["user"];
			$mail->Password = $sess["pass"];
                  
                 
			// build the email
			$mail->From = ($allow_modified_from && !empty($prefs["reply-to"]))?$prefs["reply-to"]:$sess["email"];
			$mail->FromName = $UM->mime_encode_headers($prefs["real-name"]);
			$mail->AddReplyTo($prefs["reply-to"], $UM->mime_encode_headers($prefs["real-name"]));			
			$mail->AddAddress($recipient);
			
			$mail->Subject = $UM->mime_encode_headers(stripslashes($receiptSubj));
			$mail->Body = stripslashes($receiptText);

			// send
			if($mail->Send() === true) {
				echo "success: receipt sent";
			}			
			else {
				echo "error: " . $mail->ErrorInfo;
			}

			break;

		// just refresh the session timeout
		case "pingSession":
			// refresh time
		        $sess["start"] = time();
		        // save
		        $SS->Save($sess);

		        echo "success: session refreshed";
		
			break;
		
		default:
			echo "error: this action does not exist";
	}

} else {
	// no action, no fun
	echo "error: no action specified";
}

?>
