/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.tadotter.actions;

import com.hisagisoft.eclipse.tadotter.Activator;
import com.hisagisoft.eclipse.tadotter.prefs.PrefsConstants;
import com.hisagisoft.eclipse.tadotter.views.TrackView;
import java.util.logging.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class FontAction
extends Action {
    private static Logger logger = Logger.getLogger(FontAction.class.getName());
    private IPreferenceStore store;

    public FontAction() {
        this.setImageDescriptor(Activator.getImageDescriptor("icons/e16/font.gif"));
        this.setToolTipText("Font");
        this.setId("font");
        this.store = Activator.getDefault().getPreferenceStore();
    }

    public void run() {
        logger.fine("FONT Action - start");
        IWorkbenchWindow window = null;
        try {
            window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            TrackView view = (TrackView)window.getActivePage().showView("com.hisagisoft.eclipse.tadotter.TrackView");
            Control control = view.getControl();
            FontDialog fd = new FontDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            fd.setFontList(control.getFont().getFontData());
            FontData fontData = fd.open();
            logger.fine("fontData = " + fontData);
            if (fontData != null) {
                control.setFont(new Font(null, fontData));
                control.redraw();
                this.store.setValue(PrefsConstants.FONT_TABLE, fontData.toString());
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        logger.fine("FONT Action - end");
    }
}

