/*
 * Decompiled with CFR 0.152.
 */
package com.hisagisoft.eclipse.tadotter.views;

import com.hisagisoft.common.Constants;
import com.hisagisoft.common.History;
import com.hisagisoft.common.ISelectable;
import com.hisagisoft.eclipse.common.actions.CopyToClipActions;
import com.hisagisoft.eclipse.common.actions.HistoryAction;
import com.hisagisoft.eclipse.tadotter.Activator;
import com.hisagisoft.eclipse.tadotter.prefs.PrefsConstants;
import com.hisagisoft.eclipse.tadotter.views.DoubleClickListener;
import com.hisagisoft.tadotter.Service;
import com.hisagisoft.tadotter.model.Twitter;
import com.hisagisoft.tadotter.model.TwitterList;
import java.text.SimpleDateFormat;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public class TrackView
extends ViewPart {
    private static Logger logger = Logger.getLogger(TrackView.class.getName());
    public static final String ID = "com.hisagisoft.eclipse.tadotter.TrackView";
    private TableViewer viewer;
    private Service service;
    private HistoryAction<TwitterList> prevAction;
    private HistoryAction<TwitterList> nextAction;
    private IStatusLineManager statusLine;
    private static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd EEEE HH:mm:ss");
    private IPreferenceStore store;

    public void createPartControl(Composite parent) {
        logger.fine("createPartControl - START");
        this.service = Service.getInstance();
        this.store = Activator.getDefault().getPreferenceStore();
        this.statusLine = this.getViewSite().getActionBars().getStatusLineManager();
        this.viewer = new TableViewer(parent, 68352);
        final Table table = this.viewer.getTable();
        table.setLinesVisible(true);
        FontData fontData = null;
        String fontDataValue = this.store.getString(PrefsConstants.FONT_TABLE);
        fontData = fontDataValue == null || fontDataValue.length() == 0 ? new FontData() : new FontData(fontDataValue);
        table.setFont(new Font(null, fontData));
        TableColumn colSeq = new TableColumn(table, 16384);
        colSeq.setText("");
        colSeq.setWidth(30);
        TableColumn colName = new TableColumn(table, 16384);
        colName.setText("Name");
        colName.setWidth(100);
        TableColumn colMsg = new TableColumn(table, 16384);
        colMsg.setText("Message");
        colMsg.setWidth(448);
        table.setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.viewer.addDoubleClickListener((IDoubleClickListener)new DoubleClickListener());
        final ISelectable selectableTable = new ISelectable(){

            public Object getSelection() {
                if (this.isEmpty()) {
                    return Constants.OBJECT_ZERO_ARRAY;
                }
                return table.getSelection()[0].getData();
            }

            public boolean isEmpty() {
                TableItem[] items = table.getSelection();
                if (items == null || items.length == 0) {
                    return true;
                }
                Object obj = items[0].getData();
                if (!(obj instanceof Twitter)) {
                    return true;
                }
                Twitter t = (Twitter)obj;
                return t.getType() != Twitter.Type.REAL_TWEET;
            }

            public String toString() {
                if (this.isEmpty()) {
                    return null;
                }
                Twitter t = (Twitter)this.getSelection();
                String url = Twitter.getUserTimelineUrl((String)t.getUserName());
                return url;
            }

            public Object[] getSelections() {
                throw new UnsupportedOperationException();
            }
        };
        final CopyToClipActions copyAction = new CopyToClipActions("\u30b3\u30d4\u30fc");
        copyAction.setSelectable(selectableTable);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)copyAction);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    copyAction.setEnabled(false);
                    if (!selectableTable.isEmpty()) {
                        logger.fine("selected Twitter's url = " + selectableTable.toString());
                        copyAction.setEnabled(true);
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        });
        table.setMenu(menuManager.createContextMenu((Control)table));
        this.prevAction = new HistoryAction(HistoryAction.Type.PREV);
        this.prevAction.setHistory((History<TwitterList>)this.service.getHistory());
        this.prevAction.setViewer((Viewer)this.viewer);
        this.nextAction = new HistoryAction(HistoryAction.Type.NEXT);
        this.nextAction.setHistory((History<TwitterList>)this.service.getHistory());
        this.nextAction.setViewer((Viewer)this.viewer);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.prevAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.nextAction);
        logger.fine("createPartControl - END");
    }

    public void setInput(TwitterList input) {
        this.viewer.setInput((Object)input);
    }

    public Control getControl() {
        return this.viewer.getTable();
    }

    public void setFocus() {
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return null;
            }
            return ((TwitterList)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null) {
                return;
            }
            try {
                TwitterList input = (TwitterList)newInput;
                if (TrackView.this.service.getHistory().hasPrev((Object)input)) {
                    TrackView.this.prevAction.setEnabled(true);
                } else {
                    TrackView.this.prevAction.setEnabled(false);
                }
                if (TrackView.this.service.getHistory().hasNext((Object)input)) {
                    TrackView.this.nextAction.setEnabled(true);
                } else {
                    TrackView.this.nextAction.setEnabled(false);
                }
                String timestamp = DATE_FORMAT.format(input.getTimestamp());
                TrackView.this.statusLine.setMessage(String.valueOf(input.sizeOfRealTweet()) + "\u4ef6\u30bf\u30c9\u30c3\u30bf\u30fc " + timestamp);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    class TableLabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Twitter t = (Twitter)element;
            switch (columnIndex) {
                case 0: {
                    if (t.getType() != Twitter.Type.REAL_TWEET) {
                        return null;
                    }
                    return String.valueOf(t.getSeq() + 1);
                }
                case 1: {
                    return t.getUserName();
                }
                case 2: {
                    return t.getMessage();
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

