/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.layout;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.WindowTrimProxy;
import org.eclipse.ui.internal.layout.IWindowTrim;
import org.eclipse.ui.internal.layout.SizeCache;
import org.eclipse.ui.internal.layout.TrimDescriptor;

public class TrimArea {
    private static final IWindowTrim defaultData = new WindowTrimProxy(null, null, null, 0, true);
    private int fId;
    private String fDisplayName;
    private ArrayList fTrim = new ArrayList();
    private int fControlModifiers;
    private int fTrimSize;

    static void filterResizable(List input, List resizable, List nonResizable, boolean width) {
        Iterator iter = input.iterator();
        while (iter.hasNext()) {
            SizeCache next = (SizeCache)iter.next();
            if (!next.getControl().isVisible()) continue;
            if (TrimArea.isResizable(next.getControl(), width)) {
                resizable.add(next);
                continue;
            }
            nonResizable.add(next);
        }
    }

    static boolean isResizable(Control control, boolean horizontally) {
        IWindowTrim data = TrimArea.getData(control);
        if (!data.isResizeable()) {
            return false;
        }
        if (horizontally) {
            return data.getWidthHint() == -1;
        }
        return data.getHeightHint() == -1;
    }

    private static IWindowTrim getData(Control control) {
        IWindowTrim data = (IWindowTrim)control.getLayoutData();
        if (data == null) {
            data = defaultData;
        }
        return data;
    }

    private static Point computeSize(SizeCache toCompute, int widthHint, int heightHint) {
        IWindowTrim data = TrimArea.getData(toCompute.getControl());
        if (widthHint == -1) {
            widthHint = data.getWidthHint();
        }
        if (heightHint == -1) {
            heightHint = data.getHeightHint();
        }
        if (widthHint == -1 || heightHint == -1) {
            return toCompute.computeSize(widthHint, heightHint);
        }
        return new Point(widthHint, heightHint);
    }

    static int getSize(SizeCache toCompute, int hint, boolean width) {
        if (width) {
            return TrimArea.computeSize((SizeCache)toCompute, (int)-1, (int)hint).x;
        }
        return TrimArea.computeSize((SizeCache)toCompute, (int)hint, (int)-1).y;
    }

    private static int maxDimension(List caches, int hint, boolean width) {
        if (hint == -1) {
            int result = 0;
            Iterator iter = caches.iterator();
            while (iter.hasNext()) {
                SizeCache next = (SizeCache)iter.next();
                result = Math.max(TrimArea.getSize(next, -1, width), result);
            }
            return result;
        }
        ArrayList resizable = new ArrayList(caches.size());
        ArrayList nonResizable = new ArrayList(caches.size());
        TrimArea.filterResizable(caches, resizable, nonResizable, width);
        int result = 0;
        int usedHeight = 0;
        Iterator iter = nonResizable.iterator();
        while (iter.hasNext()) {
            SizeCache next = (SizeCache)iter.next();
            Point nextSize = TrimArea.computeSize(next, -1, -1);
            if (width) {
                result = Math.max(result, nextSize.x);
                usedHeight += nextSize.y;
                continue;
            }
            result = Math.max(result, nextSize.y);
            usedHeight += nextSize.x;
        }
        if (resizable.size() > 0) {
            int individualHint = (hint - usedHeight) / resizable.size();
            iter = resizable.iterator();
            while (iter.hasNext()) {
                SizeCache next = (SizeCache)iter.next();
                result = Math.max(result, TrimArea.getSize(next, individualHint, width));
            }
        }
        return result;
    }

    public TrimArea(int id, String displayName) {
        this.fId = id;
        this.fDisplayName = displayName;
        this.fControlModifiers = 256;
    }

    public boolean isEmpty() {
        return this.fTrim.isEmpty();
    }

    public List getTrims() {
        ArrayList<IWindowTrim> trim = new ArrayList<IWindowTrim>(this.fTrim.size());
        Iterator d = this.fTrim.iterator();
        while (d.hasNext()) {
            TrimDescriptor desc = (TrimDescriptor)d.next();
            trim.add(desc.getTrim());
        }
        return trim;
    }

    public List getDescriptors() {
        return (List)this.fTrim.clone();
    }

    public void setTrimSize(int size) {
        this.fTrimSize = size;
    }

    public int getTrimSize() {
        return this.fTrimSize;
    }

    public int calculateTrimSize(int wHint, int hHint) {
        int size = 0;
        if (!this.fTrim.isEmpty()) {
            size = this.getTrimSize();
        }
        if (size == -1) {
            int hint = this.isVertical() ? hHint : wHint;
            size = TrimArea.maxDimension(this.getCaches(), hint, this.isVertical());
        }
        return size;
    }

    public boolean isVertical() {
        return (this.fControlModifiers & 0x200) == 512 || this.fControlModifiers == 16384 || this.fControlModifiers == 131072;
    }

    public int getId() {
        return this.fId;
    }

    public String getDisplayName() {
        return this.fDisplayName;
    }

    public void addTrim(TrimDescriptor desc) {
        this.fTrim.add(desc);
    }

    public void addTrim(TrimDescriptor desc, TrimDescriptor beforeMe) {
        int idx = this.fTrim.indexOf(beforeMe);
        if (idx == -1) {
            this.fTrim.add(desc);
        } else {
            ListIterator<TrimDescriptor> i = this.fTrim.listIterator(idx);
            i.add(desc);
        }
    }

    public void removeTrim(TrimDescriptor desc) {
        this.fTrim.remove(desc);
    }

    public boolean contains(TrimDescriptor desc) {
        return this.fTrim.contains(desc);
    }

    public List getCaches() {
        ArrayList<SizeCache> result = new ArrayList<SizeCache>(this.fTrim.size());
        Iterator d = this.fTrim.iterator();
        while (d.hasNext()) {
            TrimDescriptor desc = (TrimDescriptor)d.next();
            if (desc.getDockingCache() != null) {
                result.add(desc.getDockingCache());
            }
            result.add(desc.getCache());
        }
        return result;
    }

    public int getControlModifiers() {
        return this.fControlModifiers;
    }

    public void setControlModifiers(int mod) {
        this.fControlModifiers = mod;
    }
}

