/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchWindow;

public final class ActiveShellSourceProvider
extends AbstractSourceProvider {
    private static final String[] PROVIDED_SOURCE_NAMES = new String[]{"activeShell", "activeWorkbenchWindow", "activeWorkbenchWindowShell", "activeWorkbenchWindow.isCoolbarVisible", "activeWorkbenchWindow.isPerspectiveBarVisible"};
    private final Display display;
    private Shell lastActiveShell = null;
    private Shell lastActiveWorkbenchWindowShell = null;
    private WorkbenchWindow lastActiveWorkbenchWindow = null;
    private Boolean lastCoolbarVisibility = Boolean.FALSE;
    private Boolean lastPerspectiveBarVisibility = Boolean.FALSE;
    private final IPropertyChangeListener propertyListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("coolbarVisible".equals(event.getProperty())) {
                Object newValue = event.getNewValue();
                if (newValue == null || !(newValue instanceof Boolean)) {
                    return;
                }
                if (!ActiveShellSourceProvider.this.lastCoolbarVisibility.equals(newValue)) {
                    ActiveShellSourceProvider.this.fireSourceChanged(32768, "activeWorkbenchWindow.isCoolbarVisible", newValue);
                    ActiveShellSourceProvider.this.lastCoolbarVisibility = (Boolean)newValue;
                }
            } else if ("perspectiveBarVisible".equals(event.getProperty())) {
                Object newValue = event.getNewValue();
                if (newValue == null || !(newValue instanceof Boolean)) {
                    return;
                }
                if (!ActiveShellSourceProvider.this.lastPerspectiveBarVisibility.equals(newValue)) {
                    ActiveShellSourceProvider.this.fireSourceChanged(32768, "activeWorkbenchWindow.isPerspectiveBarVisible", newValue);
                    ActiveShellSourceProvider.this.lastPerspectiveBarVisibility = (Boolean)newValue;
                }
            }
        }
    };
    private final Listener listener = new Listener(){

        public final void handleEvent(Event event) {
            boolean perspectiveBarChanged;
            Boolean newCoolbarVisibility;
            if (!(event.widget instanceof Shell)) {
                if (ActiveShellSourceProvider.access$5()) {
                    ActiveShellSourceProvider.this.logDebuggingInfo("ASSP: passOnEvent: " + event.widget);
                }
                return;
            }
            if (ActiveShellSourceProvider.access$5()) {
                ActiveShellSourceProvider.this.logDebuggingInfo("\tASSP:lastActiveShell: " + ActiveShellSourceProvider.this.lastActiveShell);
                ActiveShellSourceProvider.this.logDebuggingInfo("\tASSP:lastActiveWorkbenchWindowShell" + ActiveShellSourceProvider.this.lastActiveWorkbenchWindowShell);
            }
            Map currentState = ActiveShellSourceProvider.this.getCurrentState();
            Shell newActiveShell = (Shell)currentState.get("activeShell");
            WorkbenchWindow newActiveWorkbenchWindow = (WorkbenchWindow)currentState.get("activeWorkbenchWindow");
            Shell newActiveWorkbenchWindowShell = (Shell)currentState.get("activeWorkbenchWindowShell");
            Boolean bl = newActiveWorkbenchWindow == null ? ActiveShellSourceProvider.this.lastCoolbarVisibility : (newCoolbarVisibility = newActiveWorkbenchWindow.getCoolBarVisible() ? Boolean.TRUE : Boolean.FALSE);
            Boolean newPerspectiveBarVisibility = newActiveWorkbenchWindow == null ? ActiveShellSourceProvider.this.lastPerspectiveBarVisibility : (newActiveWorkbenchWindow.getPerspectiveBarVisible() ? Boolean.TRUE : Boolean.FALSE);
            boolean shellChanged = newActiveShell != ActiveShellSourceProvider.this.lastActiveShell;
            boolean windowChanged = newActiveWorkbenchWindowShell != ActiveShellSourceProvider.this.lastActiveWorkbenchWindowShell;
            boolean coolbarChanged = newCoolbarVisibility != ActiveShellSourceProvider.this.lastCoolbarVisibility;
            boolean bl2 = perspectiveBarChanged = newPerspectiveBarVisibility != ActiveShellSourceProvider.this.lastPerspectiveBarVisibility;
            if (shellChanged && windowChanged) {
                HashMap<String, Object> sourceValuesByName = new HashMap<String, Object>(5);
                sourceValuesByName.put("activeShell", newActiveShell);
                sourceValuesByName.put("activeWorkbenchWindow", newActiveWorkbenchWindow);
                sourceValuesByName.put("activeWorkbenchWindowShell", newActiveWorkbenchWindowShell);
                int sourceFlags = 17408;
                if (coolbarChanged) {
                    sourceValuesByName.put("activeWorkbenchWindow.isCoolbarVisible", newCoolbarVisibility);
                    sourceFlags |= 0x8000;
                }
                if (perspectiveBarChanged) {
                    sourceValuesByName.put("activeWorkbenchWindow.isPerspectiveBarVisible", newPerspectiveBarVisibility);
                    sourceFlags |= 0x8000;
                }
                if (ActiveShellSourceProvider.access$5()) {
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active shell changed to " + newActiveShell);
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active workbench window changed to " + newActiveWorkbenchWindow);
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active workbench window shell changed to " + newActiveWorkbenchWindowShell);
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active workbench window coolbar visibility " + newCoolbarVisibility);
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active workbench window perspective bar visibility " + newPerspectiveBarVisibility);
                }
                ActiveShellSourceProvider.this.fireSourceChanged(sourceFlags, sourceValuesByName);
                ActiveShellSourceProvider.this.hookListener(ActiveShellSourceProvider.this.lastActiveWorkbenchWindow, newActiveWorkbenchWindow);
            } else if (shellChanged) {
                if (ActiveShellSourceProvider.access$5()) {
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active shell changed to " + newActiveShell);
                }
                ActiveShellSourceProvider.this.fireSourceChanged(1024, "activeShell", newActiveShell);
            } else if (windowChanged) {
                HashMap<String, Object> sourceValuesByName = new HashMap<String, Object>(4);
                sourceValuesByName.put("activeWorkbenchWindow", newActiveWorkbenchWindow);
                sourceValuesByName.put("activeWorkbenchWindowShell", newActiveWorkbenchWindowShell);
                int sourceFlags = 17408;
                if (coolbarChanged) {
                    sourceValuesByName.put("activeWorkbenchWindow.isCoolbarVisible", newCoolbarVisibility);
                    sourceFlags |= 0x8000;
                }
                if (perspectiveBarChanged) {
                    sourceValuesByName.put("activeWorkbenchWindow.isPerspectiveBarVisible", newPerspectiveBarVisibility);
                    sourceFlags |= 0x8000;
                }
                if (ActiveShellSourceProvider.access$5()) {
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active workbench window changed to " + newActiveWorkbenchWindow);
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active workbench window shell changed to " + newActiveWorkbenchWindowShell);
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active workbench window coolbar visibility " + newCoolbarVisibility);
                    ActiveShellSourceProvider.this.logDebuggingInfo("Active workbench window perspective bar visibility " + newPerspectiveBarVisibility);
                }
                ActiveShellSourceProvider.this.fireSourceChanged(sourceFlags, sourceValuesByName);
                ActiveShellSourceProvider.this.hookListener(ActiveShellSourceProvider.this.lastActiveWorkbenchWindow, newActiveWorkbenchWindow);
            }
            ActiveShellSourceProvider.this.lastActiveShell = newActiveShell;
            ActiveShellSourceProvider.this.lastActiveWorkbenchWindowShell = newActiveWorkbenchWindowShell;
            ActiveShellSourceProvider.this.lastActiveWorkbenchWindow = newActiveWorkbenchWindow;
            ActiveShellSourceProvider.this.lastCoolbarVisibility = newCoolbarVisibility;
            ActiveShellSourceProvider.this.lastPerspectiveBarVisibility = newPerspectiveBarVisibility;
        }
    };
    private final Workbench workbench;
    static /* synthetic */ Class class$0;

    public ActiveShellSourceProvider(Workbench workbench) {
        this.workbench = workbench;
        this.display = workbench.getDisplay();
        this.display.addFilter(26, this.listener);
    }

    public final void dispose() {
        this.display.removeFilter(26, this.listener);
        this.hookListener(this.lastActiveWorkbenchWindow, null);
        this.lastActiveWorkbenchWindow = null;
        this.lastActiveWorkbenchWindowShell = null;
        this.lastActiveShell = null;
    }

    public final Map getCurrentState() {
        IContextService contextService;
        int shellType;
        HashMap<String, Object> currentState = new HashMap<String, Object>(4);
        Shell newActiveShell = this.display.getActiveShell();
        currentState.put("activeShell", newActiveShell);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.contexts.IContextService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((shellType = (contextService = (IContextService)this.workbench.getService(clazz)).getShellType(newActiveShell)) != 0) {
            IWorkbenchWindow newActiveWorkbenchWindow = this.workbench.getActiveWorkbenchWindow();
            Shell newActiveWorkbenchWindowShell = newActiveWorkbenchWindow == null ? null : newActiveWorkbenchWindow.getShell();
            currentState.put("activeWorkbenchWindow", newActiveWorkbenchWindow);
            currentState.put("activeWorkbenchWindowShell", newActiveWorkbenchWindowShell);
        }
        return currentState;
    }

    public final String[] getProvidedSourceNames() {
        return PROVIDED_SOURCE_NAMES;
    }

    private void hookListener(WorkbenchWindow lastActiveWorkbenchWindow, WorkbenchWindow newActiveWorkbenchWindow) {
        if (lastActiveWorkbenchWindow != null) {
            lastActiveWorkbenchWindow.removePropertyChangeListener(this.propertyListener);
        }
        if (newActiveWorkbenchWindow != null) {
            newActiveWorkbenchWindow.addPropertyChangeListener(this.propertyListener);
        }
    }

    static /* synthetic */ boolean access$5() {
        return AbstractSourceProvider.DEBUG;
    }
}

