/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.wpf.OS;

public class FileTransfer
extends ByteArrayTransfer {
    private static FileTransfer _instance = new FileTransfer();
    private static int TYPEID = FileTransfer.getTypeId();

    public static FileTransfer getInstance() {
        return _instance;
    }

    static int getTypeId() {
        int format = OS.DataFormats_FileDrop();
        String name = FileTransfer.createJavaString(format);
        OS.GCHandle_Free(format);
        return FileTransfer.registerType(name);
    }

    private FileTransfer() {
    }

    boolean checkFile(Object object) {
        if (object == null || !(object instanceof String[]) || ((String[])object).length == 0) {
            return false;
        }
        String[] strings = (String[])object;
        int i = 0;
        while (i < strings.length) {
            if (strings[i] == null || strings[i].length() == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkFile(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String[] fileNames = (String[])object;
        int length = fileNames.length;
        int pStringId = OS.String_typeid();
        int pStringArray = OS.Array_CreateInstance(pStringId, length);
        int i = 0;
        while (i < length) {
            int pString = FileTransfer.createDotNetString(fileNames[i]);
            OS.Array_SetValue(pStringArray, pString, i);
            OS.GCHandle_Free(pString);
            ++i;
        }
        transferData.pValue = pStringArray;
        OS.GCHandle_Free(pStringId);
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0) {
            return null;
        }
        int pStringArray = transferData.pValue;
        int length = OS.Array_GetLength(pStringArray, 0);
        String[] fileNames = new String[length];
        int i = 0;
        while (i < length) {
            int pString = OS.Array_GetValue(pStringArray, i);
            fileNames[i] = FileTransfer.createJavaString(pString);
            OS.GCHandle_Free(pString);
            ++i;
        }
        return fileNames;
    }
}

