/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.wpf.OS;

public class RTFTransfer
extends ByteArrayTransfer {
    private static RTFTransfer _instance = new RTFTransfer();
    private static int TYPEID = RTFTransfer.getTypeId();

    public static RTFTransfer getInstance() {
        return _instance;
    }

    static int getTypeId() {
        int format = OS.DataFormats_Rtf();
        String name = RTFTransfer.createJavaString(format);
        OS.GCHandle_Free(format);
        return RTFTransfer.registerType(name);
    }

    private RTFTransfer() {
    }

    boolean checkRTF(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkRTF(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.pValue = RTFTransfer.createDotNetString((String)object);
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0) {
            return null;
        }
        return RTFTransfer.createJavaString(transferData.pValue);
    }
}

