/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.wpf.OS;

public final class Color
extends Resource {
    public int handle;

    Color() {
    }

    public Color(Device device, int red, int green, int blue) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, red, green, blue);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Color(Device device, RGB rgb) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (rgb == null) {
            SWT.error(4);
        }
        this.init(device, rgb.red, rgb.green, rgb.blue);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        OS.GCHandle_Free(this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        return this.device == color.device && (this.handle & 0xFFFFFF) == (color.handle & 0xFFFFFF);
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.Color_B(this.handle) & 0xFF;
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.Color_G(this.handle) & 0xFF;
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.Color_R(this.handle) & 0xFF;
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB(OS.Color_R(this.handle) & 0xFF, OS.Color_G(this.handle) & 0xFF, OS.Color_B(this.handle) & 0xFF);
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Device device, int red, int green, int blue) {
        if (red > 255 || red < 0 || green > 255 || green < 0 || blue > 255 || blue < 0) {
            SWT.error(5);
        }
        this.device = device;
        this.handle = OS.Color_FromArgb((byte)-1, (byte)red, (byte)green, (byte)blue);
        if (this.handle == 0) {
            SWT.error(2);
        }
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + "}";
    }

    public static Color wpf_new(Device device, int handle) {
        if (device == null) {
            device = Device.getDevice();
        }
        Color color = new Color();
        color.handle = handle;
        color.device = device;
        return color;
    }
}

