/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.internal.wpf.PROCESS_INFORMATION;
import org.eclipse.swt.internal.wpf.SHELLEXECUTEINFOW;
import org.eclipse.swt.internal.wpf.STARTUPINFOW;

public final class Program {
    String name;
    String command;
    String iconName;
    static final String[] ARGUMENTS = new String[]{"%1", "%l", "%L"};

    Program() {
    }

    static int createDotNetString(String string) {
        if (string == null) {
            return 0;
        }
        int length = string.length();
        char[] buffer = new char[length + 1];
        string.getChars(0, length, buffer, 0);
        return OS.gcnew_String(buffer);
    }

    static String createJavaString(int ptr) {
        int charArray = OS.String_ToCharArray(ptr);
        char[] chars = new char[OS.String_Length(ptr)];
        OS.memcpy(chars, charArray, chars.length * 2);
        OS.GCHandle_Free(charArray);
        return new String(chars);
    }

    public static Program findProgram(String extension) {
        if (extension == null) {
            SWT.error(4);
        }
        if (extension.length() == 0) {
            return null;
        }
        if (extension.charAt(0) != '.') {
            extension = "." + extension;
        }
        if (extension.length() > 255) {
            return null;
        }
        int key = Program.createDotNetString(extension);
        int classesRoot = OS.Registry_ClassesRoot();
        int registryKey = OS.RegistryKey_OpenSubKey(classesRoot, key);
        OS.GCHandle_Free(key);
        OS.GCHandle_Free(classesRoot);
        if (registryKey == 0) {
            return null;
        }
        Program program = null;
        int value = OS.RegistryKey_GetValue(registryKey, 0);
        if (value != 0) {
            program = Program.getProgram(value);
            OS.GCHandle_Free(value);
        }
        OS.GCHandle_Free(registryKey);
        return program;
    }

    public static String[] getExtensions() {
        String[] extensions = new String[1024];
        int classesRoot = OS.Registry_ClassesRoot();
        int subKeys = OS.RegistryKey_GetSubKeyNames(classesRoot);
        OS.GCHandle_Free(classesRoot);
        int count = 0;
        int length = OS.ICollection_Count(subKeys);
        int i = 0;
        while (i < length) {
            int key = OS.IList_default(subKeys, i);
            String extension = Program.createJavaString(key);
            OS.GCHandle_Free(key);
            if (extension.length() > 0 && extension.charAt(0) == '.') {
                if (count == extensions.length) {
                    String[] newExtensions = new String[extensions.length + 1024];
                    System.arraycopy(extensions, 0, newExtensions, 0, extensions.length);
                    extensions = newExtensions;
                }
                extensions[count++] = extension;
            }
            ++i;
        }
        OS.GCHandle_Free(subKeys);
        if (count != extensions.length) {
            String[] newExtension = new String[count];
            System.arraycopy(extensions, 0, newExtension, 0, count);
            extensions = newExtension;
        }
        return extensions;
    }

    static int getKeyValue(int key, boolean expand) {
        int value = OS.RegistryKey_GetValue(key, 0);
        if (value != 0 && expand) {
            int expandedValue = OS.Environment_ExpandEnvironmentVariables(value);
            OS.GCHandle_Free(value);
            value = expandedValue;
        }
        return value;
    }

    static Program getProgram(int key) {
        int classesRoot = OS.Registry_ClassesRoot();
        int registryKey = OS.RegistryKey_OpenSubKey(classesRoot, key);
        OS.GCHandle_Free(classesRoot);
        int name = Program.getKeyValue(registryKey, false);
        String programName = Program.createJavaString(name == 0 ? key : name);
        OS.GCHandle_Free(name);
        int shellCommand = Program.createDotNetString("shell");
        int shellKey = OS.RegistryKey_OpenSubKey(registryKey, shellCommand);
        OS.GCHandle_Free(shellCommand);
        int command = 0;
        if (shellKey != 0 && (command = Program.getKeyValue(shellKey, true)) == 0) {
            int openCommand = Program.createDotNetString("open");
            int openKey = OS.RegistryKey_OpenSubKey(shellKey, openCommand);
            if (openKey != 0) {
                int commandCommand = Program.createDotNetString("command");
                int commandKey = OS.RegistryKey_OpenSubKey(openKey, commandCommand);
                if (commandKey != 0) {
                    command = Program.getKeyValue(commandKey, true);
                    OS.GCHandle_Free(commandKey);
                }
                OS.GCHandle_Free(commandCommand);
                OS.GCHandle_Free(openKey);
            }
            OS.GCHandle_Free(openCommand);
        }
        OS.GCHandle_Free(shellKey);
        int iconName = 0;
        if (command != 0) {
            int defaultIconCommand = Program.createDotNetString("DefaultIcon");
            int defaultIconKey = OS.RegistryKey_OpenSubKey(registryKey, defaultIconCommand);
            if (defaultIconKey != 0) {
                iconName = Program.getKeyValue(defaultIconKey, true);
                OS.GCHandle_Free(defaultIconKey);
            }
            OS.GCHandle_Free(defaultIconCommand);
        }
        OS.GCHandle_Free(registryKey);
        if (command == 0) {
            return null;
        }
        Program program = new Program();
        program.name = programName;
        program.command = Program.createJavaString(command);
        OS.GCHandle_Free(command);
        program.iconName = iconName != 0 ? Program.createJavaString(iconName) : "";
        OS.GCHandle_Free(iconName);
        return program;
    }

    public static Program[] getPrograms() {
        Program[] programs = new Program[1024];
        int classesRoot = OS.Registry_ClassesRoot();
        int subKeyNames = OS.RegistryKey_GetSubKeyNames(classesRoot);
        OS.GCHandle_Free(classesRoot);
        int count = 0;
        int length = OS.ICollection_Count(subKeyNames);
        int i = 0;
        while (i < length) {
            int keyName = OS.IList_default(subKeyNames, i);
            Program program = Program.getProgram(keyName);
            OS.GCHandle_Free(keyName);
            if (program != null) {
                if (count == programs.length) {
                    Program[] newPrograms = new Program[programs.length + 1024];
                    System.arraycopy(programs, 0, newPrograms, 0, programs.length);
                    programs = newPrograms;
                }
                programs[count++] = program;
            }
            ++i;
        }
        OS.GCHandle_Free(subKeyNames);
        if (count != programs.length) {
            Program[] newPrograms = new Program[count];
            System.arraycopy(programs, 0, newPrograms, 0, count);
            programs = newPrograms;
        }
        return programs;
    }

    public static boolean launch(String fileName) {
        if (fileName == null) {
            SWT.error(4);
        }
        int hHeap = OS.GetProcessHeap();
        int length = fileName.length();
        char[] buffer = new char[length + 1];
        fileName.getChars(0, length, buffer, 0);
        int byteCount = buffer.length * 2;
        int lpFile = OS.HeapAlloc(hHeap, OS.HEAP_ZERO_MEMORY, byteCount);
        OS.MoveMemory(lpFile, buffer, byteCount);
        SHELLEXECUTEINFOW info = new SHELLEXECUTEINFOW();
        info.cbSize = SHELLEXECUTEINFOW.sizeof;
        info.lpFile = lpFile;
        info.nShow = OS.SW_SHOW;
        boolean result = OS.ShellExecuteExW(info);
        if (lpFile != 0) {
            OS.HeapFree(hHeap, 0, lpFile);
        }
        return result;
    }

    public boolean execute(String fileName) {
        if (fileName == null) {
            SWT.error(4);
        }
        int index = 0;
        boolean append = true;
        String prefix = this.command;
        String suffix = "";
        while (index < ARGUMENTS.length) {
            int i = this.command.indexOf(ARGUMENTS[index]);
            if (i != -1) {
                append = false;
                prefix = this.command.substring(0, i);
                suffix = this.command.substring(i + ARGUMENTS[index].length(), this.command.length());
                break;
            }
            ++index;
        }
        if (append) {
            fileName = " \"" + fileName + "\"";
        }
        String commandLine = String.valueOf(prefix) + fileName + suffix;
        int length = commandLine.length();
        char[] buffer = new char[length + 1];
        commandLine.getChars(0, length, buffer, 0);
        STARTUPINFOW lpStartupInfo = new STARTUPINFOW();
        lpStartupInfo.cb = STARTUPINFOW.sizeof;
        PROCESS_INFORMATION lpProcessInformation = new PROCESS_INFORMATION();
        boolean success = OS.CreateProcessW(0, buffer, 0, 0, false, 0, 0, 0, lpStartupInfo, lpProcessInformation);
        if (lpProcessInformation.hProcess != 0) {
            OS.CloseHandle(lpProcessInformation.hProcess);
        }
        if (lpProcessInformation.hThread != 0) {
            OS.CloseHandle(lpProcessInformation.hThread);
        }
        return success;
    }

    public ImageData getImageData() {
        int nIconIndex = 0;
        String fileName = this.iconName;
        int index = this.iconName.indexOf(44);
        if (index != -1) {
            fileName = this.iconName.substring(0, index);
            String iconIndex = this.iconName.substring(index + 1, this.iconName.length()).trim();
            try {
                nIconIndex = Integer.parseInt(iconIndex);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        int length = fileName.length();
        char[] buffer = new char[length + 1];
        fileName.getChars(0, length, buffer, 0);
        int[] phiconSmall = new int[1];
        int[] phiconLarge = null;
        OS.ExtractIconExW(buffer, nIconIndex, phiconLarge, phiconSmall, 1);
        if (phiconSmall[0] == 0) {
            return null;
        }
        int empty = OS.Int32Rect_Empty();
        int source = OS.Imaging_CreateBitmapSourceFromHIcon(phiconSmall[0], empty, 0);
        Image image = Image.wpf_new(null, 1, source);
        OS.GCHandle_Free(empty);
        ImageData imageData = image.getImageData();
        image.dispose();
        return imageData;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Program) {
            Program program = (Program)other;
            return this.name.equals(program.name) && this.command.equals(program.command) && this.iconName.equals(program.iconName);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.command.hashCode() ^ this.iconName.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

