/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Button
extends Control {
    String text = "";
    Image image;
    int textHandle;
    int imageHandle;
    boolean ignoreSelection;

    public Button(Composite parent, int style) {
        super(parent, Button.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        if (((style = Button.checkBits(style, 8, 4, 32, 16, 2, 0)) & 0xA) != 0) {
            return Button.checkBits(style, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((style & 0x30) != 0) {
            return Button.checkBits(style, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((style & 4) != 0) {
            return Button.checkBits(style |= 0x80000, 128, 1024, 16384, 131072, 0, 0);
        }
        return style;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point size = this.computeSize(this.handle, wHint, hHint, changed);
        if ((this.style & 4) == 0) {
            int border = this.getBorderWidth();
            size.x += border * 2;
            size.y += border * 2;
        }
        return size;
    }

    void createArrow() {
        int geometry = OS.gcnew_StreamGeometry();
        int context = OS.StreamGeometry_Open(geometry);
        int start = 0;
        int point = 0;
        int end = 0;
        int mask = 148608;
        switch (this.style & mask) {
            case 131072: {
                start = OS.gcnew_Point(1.0, 0.0);
                point = OS.gcnew_Point(4.0, 3.0);
                end = OS.gcnew_Point(1.0, 6.0);
                break;
            }
            case 16384: {
                start = OS.gcnew_Point(4.0, 1.0);
                point = OS.gcnew_Point(1.0, 3.0);
                end = OS.gcnew_Point(4.0, 6.0);
                break;
            }
            case 1024: {
                start = OS.gcnew_Point(0.0, 1.0);
                point = OS.gcnew_Point(3.0, 4.0);
                end = OS.gcnew_Point(6.0, 1.0);
                break;
            }
            case 128: {
                start = OS.gcnew_Point(0.0, 4.0);
                point = OS.gcnew_Point(3.0, 1.0);
                end = OS.gcnew_Point(6.0, 4.0);
            }
        }
        OS.StreamGeometryContext_BeginFigure(context, start, true, true);
        OS.StreamGeometryContext_LineTo(context, point, true, true);
        OS.StreamGeometryContext_LineTo(context, end, true, true);
        OS.StreamGeometryContext_Close(context);
        int path = OS.gcnew_Path();
        OS.Path_Data(path, geometry);
        int padding = OS.gcnew_Thickness(3.0, 3.0, 3.0, 3.0);
        OS.FrameworkElement_Margin(path, padding);
        int brush = OS.Brushes_Black();
        OS.Path_Fill(path, brush);
        OS.FrameworkElement_Width(path, 6.0);
        OS.FrameworkElement_Height(path, 6.0);
        OS.FrameworkElement_HorizontalAlignment(path, 1);
        OS.FrameworkElement_VerticalAlignment(path, 1);
        OS.ContentControl_Content(this.handle, path);
        OS.GCHandle_Free(padding);
        OS.GCHandle_Free(start);
        OS.GCHandle_Free(point);
        OS.GCHandle_Free(end);
        OS.GCHandle_Free(brush);
        OS.GCHandle_Free(path);
        OS.GCHandle_Free(context);
        OS.GCHandle_Free(geometry);
    }

    void createHandle() {
        if ((this.style & 8) == 0) {
            this.state |= 0x100;
        }
        int bits = 62;
        switch (this.style & bits) {
            case 2: {
                this.handle = OS.gcnew_ToggleButton();
                if (this.handle != 0) break;
                this.error(2);
                break;
            }
            case 4: {
                this.handle = OS.gcnew_Button();
                if (this.handle == 0) {
                    this.error(2);
                }
                this.createArrow();
                break;
            }
            case 16: {
                this.handle = OS.gcnew_RadioButton();
                if (this.handle != 0) break;
                this.error(2);
                break;
            }
            case 32: {
                this.handle = OS.gcnew_CheckBox();
                if (this.handle != 0) break;
                this.error(2);
                break;
            }
            default: {
                this.handle = OS.gcnew_Button();
                if (this.handle != 0) break;
                this.error(2);
            }
        }
        if ((this.style & 4) != 0) {
            return;
        }
        int value = 0;
        if ((this.style & 0x1000000) != 0) {
            value = 1;
        }
        if ((this.style & 0x20000) != 0) {
            value = 2;
        }
        OS.Control_HorizontalContentAlignment(this.handle, value);
        this.imageHandle = OS.gcnew_Image();
        if (this.imageHandle == 0) {
            this.error(2);
        }
        OS.Image_Stretch(this.imageHandle, 0);
        OS.UIElement_Visibility(this.imageHandle, (byte)2);
        this.textHandle = OS.gcnew_AccessText();
        if (this.textHandle == 0) {
            this.error(2);
        }
        OS.FrameworkElement_VerticalAlignment(this.textHandle, 1);
        int panel = OS.gcnew_StackPanel();
        if (panel == 0) {
            this.error(2);
        }
        OS.StackPanel_Orientation(panel, 0);
        int thickness = OS.gcnew_Thickness(1.0, 1.0, 1.0, 1.0);
        if (thickness == 0) {
            this.error(2);
        }
        OS.FrameworkElement_Margin(panel, thickness);
        OS.GCHandle_Free(thickness);
        int children = OS.Panel_Children(panel);
        OS.UIElementCollection_Add(children, this.imageHandle);
        OS.UIElementCollection_Add(children, this.textHandle);
        OS.ContentControl_Content(this.handle, panel);
        OS.GCHandle_Free(children);
        OS.GCHandle_Free(panel);
    }

    int defaultBackground() {
        if ((this.style & 8) == 0) {
            return OS.SystemColors_ControlColor;
        }
        return 0;
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x80) != 0) {
                return 128;
            }
            if ((this.style & 0x400) != 0) {
                return 1024;
            }
            if ((this.style & 0x4000) != 0) {
                return 16384;
            }
            if ((this.style & 0x20000) != 0) {
                return 131072;
            }
            return 128;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        return OS.ToggleButton_IsChecked(this.handle);
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return "";
        }
        return this.text;
    }

    void HandleClick(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        if (!this.ignoreSelection) {
            this.postEvent(13);
        }
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.style & 0x32) != 0) {
            int handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleClick");
            if (handler == 0) {
                this.error(2);
            }
            OS.ToggleButton_Checked(this.handle, handler);
            OS.GCHandle_Free(handler);
            handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleClick");
            if (handler == 0) {
                this.error(2);
            }
            OS.ToggleButton_Unchecked(this.handle, handler);
            OS.GCHandle_Free(handler);
        } else {
            int handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleClick");
            if (handler == 0) {
                this.error(2);
            }
            OS.ButtonBase_Click(this.handle, handler);
            OS.GCHandle_Free(handler);
        }
    }

    boolean mnemonicHit(char ch) {
        return false;
    }

    boolean mnemonicMatch(char key) {
        return super.mnemonicMatch(this.textHandle, key);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.textHandle != 0) {
            OS.GCHandle_Free(this.textHandle);
        }
        this.textHandle = 0;
        if (this.imageHandle != 0) {
            OS.GCHandle_Free(this.imageHandle);
        }
        this.imageHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.text = null;
        this.image = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x24480) == 0) {
                return;
            }
            this.style &= 0xFFFDBB7F;
            this.style |= alignment & 0x24480;
            this.createArrow();
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        int value = 0;
        if ((this.style & 0x1000000) != 0) {
            value = 1;
        }
        if ((this.style & 0x20000) != 0) {
            value = 2;
        }
        OS.Control_HorizontalContentAlignment(this.handle, value);
    }

    void setDefault(boolean value) {
        if ((this.style & 8) == 0) {
            return;
        }
        OS.Button_IsDefault(this.handle, value);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.image = image;
        OS.Image_Source(this.imageHandle, image != null ? image.handle : 0);
        OS.UIElement_Visibility(this.imageHandle, image != null ? (byte)0 : 2);
        OS.UIElement_Visibility(this.textHandle, (byte)(image != null && this.text.length() == 0 ? 2 : 0));
        int spacing = image != null && this.text.length() != 0 ? 3 : 0;
        int margin = OS.gcnew_Thickness(0.0, 0.0, spacing, 0.0);
        if (margin == 0) {
            this.error(2);
        }
        OS.FrameworkElement_Margin(this.imageHandle, margin);
        OS.GCHandle_Free(margin);
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        this.ignoreSelection = true;
        OS.ToggleButton_IsChecked(this.handle, selected);
        this.ignoreSelection = false;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        int strPtr = this.createDotNetString(this.text, true);
        if (strPtr == 0) {
            this.error(2);
        }
        OS.AccessText_Text(this.textHandle, strPtr);
        OS.GCHandle_Free(strPtr);
        OS.UIElement_Visibility(this.textHandle, (byte)(string.length() == 0 && this.image != null ? 2 : 0));
        int spacing = this.image != null && this.text.length() != 0 ? 3 : 0;
        int margin = OS.gcnew_Thickness(0.0, 0.0, spacing, 0.0);
        if (margin == 0) {
            this.error(2);
        }
        OS.FrameworkElement_Margin(this.imageHandle, margin);
        OS.GCHandle_Free(margin);
    }

    int traversalCode(int key, int event) {
        int code = super.traversalCode(key, event);
        if ((this.style & 0x10) != 0) {
            code |= 0x60;
        }
        return code;
    }
}

