/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.TypedListener;

public class ExpandBar
extends Composite {
    int parentingHandle;
    Control[] children;
    int itemCount;
    int childCount;
    int spacing;

    public ExpandBar(Composite parent, int style) {
        super(parent, ExpandBar.checkStyle(style));
    }

    Control[] _getChildren() {
        Control[] result = new Control[this.childCount];
        int i = 0;
        while (i < this.childCount) {
            result[this.childCount - i - 1] = this.children[i];
            ++i;
        }
        return result;
    }

    void addChild(Control control) {
        super.addChild(control);
        if (this.childCount == this.children.length) {
            Control[] newChildren = new Control[this.childCount + 4];
            System.arraycopy(this.children, 0, newChildren, 0, this.childCount);
            this.children = newChildren;
        }
        this.children[this.childCount++] = control;
    }

    public void addExpandListener(ExpandListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int style) {
        return style &= 0xFFFFFEFF;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point size = this.computeSize(this.handle, wHint, hHint, changed);
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    void createHandle() {
        this.state |= 0x100;
        this.parentingHandle = OS.gcnew_Canvas();
        if (this.parentingHandle == 0) {
            this.error(2);
        }
        this.scrolledHandle = OS.gcnew_ScrollViewer();
        if (this.scrolledHandle == 0) {
            this.error(2);
        }
        this.handle = OS.gcnew_StackPanel();
        if (this.handle == 0) {
            this.error(2);
        }
        int children = OS.Panel_Children(this.parentingHandle);
        OS.UIElementCollection_Add(children, this.scrolledHandle);
        OS.GCHandle_Free(children);
        OS.ContentControl_Content(this.scrolledHandle, this.handle);
    }

    void createItem(ExpandItem item, int style, int index) {
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        item.createWidget();
        int items = OS.Panel_Children(this.handle);
        OS.UIElementCollection_Insert(items, index, item.topHandle());
        int count = OS.UIElementCollection_Count(items);
        OS.GCHandle_Free(items);
        if (this.itemCount == count) {
            this.error(14);
        }
        ++this.itemCount;
    }

    void createWidget() {
        super.createWidget();
        this.children = new Control[4];
    }

    int defaultBackground() {
        return OS.SystemColors_ControlColor;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.parentingHandle);
    }

    void destroyItem(ExpandItem item) {
        int items = OS.Panel_Children(this.handle);
        OS.UIElementCollection_Remove(items, item.topHandle());
        int count = OS.UIElementCollection_Count(items);
        OS.GCHandle_Free(items);
        if (this.itemCount == count) {
            this.error(15);
        }
        --this.itemCount;
    }

    void fixScrollbarVisibility() {
        OS.ScrollViewer_SetHorizontalScrollBarVisibility(this.scrolledHandle, 2);
        if ((this.style & 0x200) == 0) {
            OS.ScrollViewer_SetVerticalScrollBarVisibility(this.scrolledHandle, 2);
        } else {
            OS.ScrollViewer_SetVerticalScrollBarVisibility(this.scrolledHandle, 1);
        }
    }

    Point getLocation(Control child) {
        int topHandle = child.topHandle();
        int point = OS.gcnew_Point(0.0, 0.0);
        if (point == 0) {
            this.error(2);
        }
        int location = OS.UIElement_TranslatePoint(topHandle, point, this.handle);
        int x = (int)OS.Point_X(location);
        int y = (int)OS.Point_Y(location);
        OS.GCHandle_Free(point);
        OS.GCHandle_Free(location);
        return new Point(x, y);
    }

    public ExpandItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        int items = OS.Panel_Children(this.handle);
        ExpandItem item = this.getItem(items, index);
        OS.GCHandle_Free(items);
        return item;
    }

    ExpandItem getItem(int items, int index) {
        int item = OS.UIElementCollection_default(items, index);
        ExpandItem result = (ExpandItem)this.display.getWidget(item);
        OS.GCHandle_Free(item);
        return result;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ExpandItem[] getItems() {
        this.checkWidget();
        ExpandItem[] result = new ExpandItem[this.itemCount];
        int items = OS.Panel_Children(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            result[i] = this.getItem(items, i);
            ++i;
        }
        OS.GCHandle_Free(items);
        return result;
    }

    int getScrollBarHandle(int style) {
        if ((style & 0x100) != 0) {
            return 0;
        }
        this.updateLayout(this.handle);
        int template = OS.Control_Template(this.scrolledHandle);
        int part = this.createDotNetString("PART_VerticalScrollBar", false);
        int scrollbar = OS.FrameworkTemplate_FindName(template, part, this.scrolledHandle);
        OS.GCHandle_Free(part);
        OS.GCHandle_Free(template);
        return scrollbar;
    }

    public int getSpacing() {
        this.checkWidget();
        return this.spacing;
    }

    boolean hasItems() {
        return true;
    }

    public int indexOf(ExpandItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        int items = OS.Panel_Children(this.handle);
        int index = OS.UIElementCollection_IndexOf(items, item.topHandle());
        OS.GCHandle_Free(items);
        return index;
    }

    int parentingHandle() {
        return this.parentingHandle;
    }

    void register() {
        super.register();
        this.display.addWidget(this.parentingHandle, this);
    }

    void releaseChildren(boolean destroy) {
        int items = OS.Panel_Children(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            ExpandItem item = this.getItem(items, i);
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        OS.GCHandle_Free(items);
        super.releaseChildren(destroy);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.parentingHandle != 0) {
            OS.GCHandle_Free(this.parentingHandle);
        }
        this.parentingHandle = 0;
    }

    void removeChild(Control control) {
        super.removeChild(control);
        int index = 0;
        while (index < this.childCount) {
            if (this.children[index] == control) break;
            ++index;
        }
        if (index == this.childCount) {
            return;
        }
        System.arraycopy(this.children, index + 1, this.children, index, --this.childCount - index);
        this.children[this.childCount] = null;
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int items = OS.Panel_Children(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            ExpandItem item = this.getItem(items, i);
            if (item.control == control) {
                item.setControl(null);
                break;
            }
            ++i;
        }
        OS.GCHandle_Free(items);
    }

    public void removeExpandListener(ExpandListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, listener);
        this.eventTable.unhook(18, listener);
    }

    int setBounds(int x, int y, int width, int height, int flags) {
        int result = super.setBounds(x, y, width, height, flags);
        if ((result & 0x4000) != 0) {
            OS.FrameworkElement_Height(this.scrolledHandle, height);
            OS.FrameworkElement_Width(this.scrolledHandle, width);
        }
        return result;
    }

    public void setSpacing(int spacing) {
        this.checkWidget();
        if (spacing < 0) {
            return;
        }
        if (spacing == this.spacing) {
            return;
        }
        this.spacing = spacing;
        int thickness = OS.gcnew_Thickness(spacing, spacing, spacing, spacing);
        int items = OS.Panel_Children(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            ExpandItem item = this.getItem(items, i);
            OS.FrameworkElement_Margin(item.handle, thickness);
            ++i;
        }
        OS.GCHandle_Free(items);
        OS.GCHandle_Free(thickness);
    }

    int topHandle() {
        return this.parentingHandle;
    }
}

