/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolTip
extends Widget {
    Shell parent;
    Shell tip;
    int x;
    int y;
    int[] borderPolygon;
    boolean spikeAbove;
    boolean autohide;
    Listener listener;
    TextLayout layoutText;
    TextLayout layoutMessage;
    Region region;
    Font boldFont;
    Runnable runnable;
    static final int BORDER = 5;
    static final int PADDING = 5;
    static final int INSET = 4;
    static final int TIP_HEIGHT = 20;
    static final int IMAGE_SIZE = 16;
    static final int DELAY = 10000;

    public ToolTip(Shell parent, int style) {
        super(parent, ToolTip.checkStyle(style));
        this.parent = parent;
        this.autohide = true;
        this.y = -1;
        this.x = -1;
        Display display = this.getDisplay();
        this.tip = new Shell(parent, 16392);
        Color background = display.getSystemColor(29);
        this.tip.setBackground(background);
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        ToolTip.this.onDispose(event);
                        break;
                    }
                    case 9: {
                        ToolTip.this.onPaint(event);
                        break;
                    }
                    case 3: {
                        ToolTip.this.onMouseDown(event);
                    }
                }
            }
        };
        this.addListener(12, this.listener);
        this.tip.addListener(9, this.listener);
        this.tip.addListener(3, this.listener);
    }

    static int checkStyle(int style) {
        int mask = 11;
        if ((style & mask) == 0) {
            return style;
        }
        return ToolTip.checkBits(style, 2, 8, 1, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void configure() {
        int[] polyline;
        Display display = this.parent.getDisplay();
        if (this.x == -1 || this.y == -1) {
            Point point = display.getCursorLocation();
            this.x = point.x;
            this.y = point.y;
        }
        Monitor monitor = this.parent.getMonitor();
        Rectangle dest = monitor.getBounds();
        Point size = this.getSize(dest.width / 4);
        int w = size.x;
        int h = size.y;
        int t = (this.style & 0x1000) != 0 ? 20 : 0;
        int i = (this.style & 0x1000) != 0 ? 16 : 0;
        this.tip.setSize(w, h + t);
        boolean bl = this.spikeAbove = dest.height >= this.y + size.y + t;
        if (dest.width >= this.x + size.x) {
            if (dest.height >= this.y + size.y + t) {
                int[] nArray = new int[68];
                nArray[1] = 5 + t;
                nArray[2] = 1;
                nArray[3] = 5 + t;
                nArray[4] = 1;
                nArray[5] = 3 + t;
                nArray[6] = 3;
                nArray[7] = 1 + t;
                nArray[8] = 5;
                nArray[9] = 1 + t;
                nArray[10] = 5;
                nArray[11] = t;
                nArray[12] = 16;
                nArray[13] = t;
                nArray[14] = 16;
                nArray[16] = 35;
                nArray[17] = t;
                nArray[18] = w - 5;
                nArray[19] = t;
                nArray[20] = w - 5;
                nArray[21] = 1 + t;
                nArray[22] = w - 3;
                nArray[23] = 1 + t;
                nArray[24] = w - 1;
                nArray[25] = 3 + t;
                nArray[26] = w - 1;
                nArray[27] = 5 + t;
                nArray[28] = w;
                nArray[29] = 5 + t;
                nArray[30] = w;
                nArray[31] = h - 5 + t;
                nArray[32] = w - 1;
                nArray[33] = h - 5 + t;
                nArray[34] = w - 1;
                nArray[35] = h - 3 + t;
                nArray[36] = w - 2;
                nArray[37] = h - 3 + t;
                nArray[38] = w - 2;
                nArray[39] = h - 2 + t;
                nArray[40] = w - 3;
                nArray[41] = h - 2 + t;
                nArray[42] = w - 3;
                nArray[43] = h - 1 + t;
                nArray[44] = w - 5;
                nArray[45] = h - 1 + t;
                nArray[46] = w - 5;
                nArray[47] = h + t;
                nArray[48] = 5;
                nArray[49] = h + t;
                nArray[50] = 5;
                nArray[51] = h - 1 + t;
                nArray[52] = 3;
                nArray[53] = h - 1 + t;
                nArray[54] = 3;
                nArray[55] = h - 2 + t;
                nArray[56] = 2;
                nArray[57] = h - 2 + t;
                nArray[58] = 2;
                nArray[59] = h - 3 + t;
                nArray[60] = 1;
                nArray[61] = h - 3 + t;
                nArray[62] = 1;
                nArray[63] = h - 5 + t;
                nArray[65] = h - 5 + t;
                nArray[67] = 5 + t;
                polyline = nArray;
                int[] nArray2 = new int[56];
                nArray2[1] = 5 + t;
                nArray2[2] = 1;
                nArray2[3] = 4 + t;
                nArray2[4] = 1;
                nArray2[5] = 3 + t;
                nArray2[6] = 3;
                nArray2[7] = 1 + t;
                nArray2[8] = 4;
                nArray2[9] = 1 + t;
                nArray2[10] = 5;
                nArray2[11] = t;
                nArray2[12] = 16;
                nArray2[13] = t;
                nArray2[14] = 16;
                nArray2[15] = 1;
                nArray2[16] = 35;
                nArray2[17] = t;
                nArray2[18] = w - 6;
                nArray2[19] = 0 + t;
                nArray2[20] = w - 5;
                nArray2[21] = 1 + t;
                nArray2[22] = w - 4;
                nArray2[23] = 1 + t;
                nArray2[24] = w - 2;
                nArray2[25] = 3 + t;
                nArray2[26] = w - 2;
                nArray2[27] = 4 + t;
                nArray2[28] = w - 1;
                nArray2[29] = 5 + t;
                nArray2[30] = w - 1;
                nArray2[31] = h - 6 + t;
                nArray2[32] = w - 2;
                nArray2[33] = h - 5 + t;
                nArray2[34] = w - 2;
                nArray2[35] = h - 4 + t;
                nArray2[36] = w - 4;
                nArray2[37] = h - 2 + t;
                nArray2[38] = w - 5;
                nArray2[39] = h - 2 + t;
                nArray2[40] = w - 6;
                nArray2[41] = h - 1 + t;
                nArray2[42] = 5;
                nArray2[43] = h - 1 + t;
                nArray2[44] = 4;
                nArray2[45] = h - 2 + t;
                nArray2[46] = 3;
                nArray2[47] = h - 2 + t;
                nArray2[48] = 1;
                nArray2[49] = h - 4 + t;
                nArray2[50] = 1;
                nArray2[51] = h - 5 + t;
                nArray2[53] = h - 6 + t;
                nArray2[55] = 5 + t;
                this.borderPolygon = nArray2;
                this.tip.setLocation(Math.max(0, this.x - i), this.y);
            } else {
                int[] nArray = new int[68];
                nArray[1] = 5;
                nArray[2] = 1;
                nArray[3] = 5;
                nArray[4] = 1;
                nArray[5] = 3;
                nArray[6] = 3;
                nArray[7] = 1;
                nArray[8] = 5;
                nArray[9] = 1;
                nArray[10] = 5;
                nArray[12] = w - 5;
                nArray[14] = w - 5;
                nArray[15] = 1;
                nArray[16] = w - 3;
                nArray[17] = 1;
                nArray[18] = w - 1;
                nArray[19] = 3;
                nArray[20] = w - 1;
                nArray[21] = 5;
                nArray[22] = w;
                nArray[23] = 5;
                nArray[24] = w;
                nArray[25] = h - 5;
                nArray[26] = w - 1;
                nArray[27] = h - 5;
                nArray[28] = w - 1;
                nArray[29] = h - 3;
                nArray[30] = w - 2;
                nArray[31] = h - 3;
                nArray[32] = w - 2;
                nArray[33] = h - 2;
                nArray[34] = w - 3;
                nArray[35] = h - 2;
                nArray[36] = w - 3;
                nArray[37] = h - 1;
                nArray[38] = w - 5;
                nArray[39] = h - 1;
                nArray[40] = w - 5;
                nArray[41] = h;
                nArray[42] = 35;
                nArray[43] = h;
                nArray[44] = 16;
                nArray[45] = h + t;
                nArray[46] = 16;
                nArray[47] = h;
                nArray[48] = 5;
                nArray[49] = h;
                nArray[50] = 5;
                nArray[51] = h - 1;
                nArray[52] = 3;
                nArray[53] = h - 1;
                nArray[54] = 3;
                nArray[55] = h - 2;
                nArray[56] = 2;
                nArray[57] = h - 2;
                nArray[58] = 2;
                nArray[59] = h - 3;
                nArray[60] = 1;
                nArray[61] = h - 3;
                nArray[62] = 1;
                nArray[63] = h - 5;
                nArray[65] = h - 5;
                nArray[67] = 5;
                polyline = nArray;
                int[] nArray3 = new int[56];
                nArray3[1] = 5;
                nArray3[2] = 1;
                nArray3[3] = 4;
                nArray3[4] = 1;
                nArray3[5] = 3;
                nArray3[6] = 3;
                nArray3[7] = 1;
                nArray3[8] = 4;
                nArray3[9] = 1;
                nArray3[10] = 5;
                nArray3[12] = w - 6;
                nArray3[14] = w - 5;
                nArray3[15] = 1;
                nArray3[16] = w - 4;
                nArray3[17] = 1;
                nArray3[18] = w - 2;
                nArray3[19] = 3;
                nArray3[20] = w - 2;
                nArray3[21] = 4;
                nArray3[22] = w - 1;
                nArray3[23] = 5;
                nArray3[24] = w - 1;
                nArray3[25] = h - 6;
                nArray3[26] = w - 2;
                nArray3[27] = h - 5;
                nArray3[28] = w - 2;
                nArray3[29] = h - 4;
                nArray3[30] = w - 4;
                nArray3[31] = h - 2;
                nArray3[32] = w - 5;
                nArray3[33] = h - 2;
                nArray3[34] = w - 6;
                nArray3[35] = h - 1;
                nArray3[36] = 36;
                nArray3[37] = h - 1;
                nArray3[38] = 16;
                nArray3[39] = h + t - 1;
                nArray3[40] = 16;
                nArray3[41] = h - 1;
                nArray3[42] = 5;
                nArray3[43] = h - 1;
                nArray3[44] = 4;
                nArray3[45] = h - 2;
                nArray3[46] = 3;
                nArray3[47] = h - 2;
                nArray3[48] = 1;
                nArray3[49] = h - 4;
                nArray3[50] = 1;
                nArray3[51] = h - 5;
                nArray3[53] = h - 6;
                nArray3[55] = 5;
                this.borderPolygon = nArray3;
                this.tip.setLocation(Math.max(0, this.x - i), this.y - size.y - t);
            }
        } else if (dest.height >= this.y + size.y + t) {
            int[] nArray = new int[68];
            nArray[1] = 5 + t;
            nArray[2] = 1;
            nArray[3] = 5 + t;
            nArray[4] = 1;
            nArray[5] = 3 + t;
            nArray[6] = 3;
            nArray[7] = 1 + t;
            nArray[8] = 5;
            nArray[9] = 1 + t;
            nArray[10] = 5;
            nArray[11] = t;
            nArray[12] = w - 35;
            nArray[13] = t;
            nArray[14] = w - 16;
            nArray[16] = w - 16;
            nArray[17] = t;
            nArray[18] = w - 5;
            nArray[19] = t;
            nArray[20] = w - 5;
            nArray[21] = 1 + t;
            nArray[22] = w - 3;
            nArray[23] = 1 + t;
            nArray[24] = w - 1;
            nArray[25] = 3 + t;
            nArray[26] = w - 1;
            nArray[27] = 5 + t;
            nArray[28] = w;
            nArray[29] = 5 + t;
            nArray[30] = w;
            nArray[31] = h - 5 + t;
            nArray[32] = w - 1;
            nArray[33] = h - 5 + t;
            nArray[34] = w - 1;
            nArray[35] = h - 3 + t;
            nArray[36] = w - 2;
            nArray[37] = h - 3 + t;
            nArray[38] = w - 2;
            nArray[39] = h - 2 + t;
            nArray[40] = w - 3;
            nArray[41] = h - 2 + t;
            nArray[42] = w - 3;
            nArray[43] = h - 1 + t;
            nArray[44] = w - 5;
            nArray[45] = h - 1 + t;
            nArray[46] = w - 5;
            nArray[47] = h + t;
            nArray[48] = 5;
            nArray[49] = h + t;
            nArray[50] = 5;
            nArray[51] = h - 1 + t;
            nArray[52] = 3;
            nArray[53] = h - 1 + t;
            nArray[54] = 3;
            nArray[55] = h - 2 + t;
            nArray[56] = 2;
            nArray[57] = h - 2 + t;
            nArray[58] = 2;
            nArray[59] = h - 3 + t;
            nArray[60] = 1;
            nArray[61] = h - 3 + t;
            nArray[62] = 1;
            nArray[63] = h - 5 + t;
            nArray[65] = h - 5 + t;
            nArray[67] = 5 + t;
            polyline = nArray;
            int[] nArray4 = new int[56];
            nArray4[1] = 5 + t;
            nArray4[2] = 1;
            nArray4[3] = 4 + t;
            nArray4[4] = 1;
            nArray4[5] = 3 + t;
            nArray4[6] = 3;
            nArray4[7] = 1 + t;
            nArray4[8] = 4;
            nArray4[9] = 1 + t;
            nArray4[10] = 5;
            nArray4[11] = t;
            nArray4[12] = w - 35;
            nArray4[13] = t;
            nArray4[14] = w - 17;
            nArray4[15] = 2;
            nArray4[16] = w - 17;
            nArray4[17] = t;
            nArray4[18] = w - 6;
            nArray4[19] = t;
            nArray4[20] = w - 5;
            nArray4[21] = 1 + t;
            nArray4[22] = w - 4;
            nArray4[23] = 1 + t;
            nArray4[24] = w - 2;
            nArray4[25] = 3 + t;
            nArray4[26] = w - 2;
            nArray4[27] = 4 + t;
            nArray4[28] = w - 1;
            nArray4[29] = 5 + t;
            nArray4[30] = w - 1;
            nArray4[31] = h - 6 + t;
            nArray4[32] = w - 2;
            nArray4[33] = h - 5 + t;
            nArray4[34] = w - 2;
            nArray4[35] = h - 4 + t;
            nArray4[36] = w - 4;
            nArray4[37] = h - 2 + t;
            nArray4[38] = w - 5;
            nArray4[39] = h - 2 + t;
            nArray4[40] = w - 6;
            nArray4[41] = h - 1 + t;
            nArray4[42] = 5;
            nArray4[43] = h - 1 + t;
            nArray4[44] = 4;
            nArray4[45] = h - 2 + t;
            nArray4[46] = 3;
            nArray4[47] = h - 2 + t;
            nArray4[48] = 1;
            nArray4[49] = h - 4 + t;
            nArray4[50] = 1;
            nArray4[51] = h - 5 + t;
            nArray4[53] = h - 6 + t;
            nArray4[55] = 5 + t;
            this.borderPolygon = nArray4;
            this.tip.setLocation(Math.min(dest.width - size.x, this.x - size.x + i), this.y);
        } else {
            int[] nArray = new int[68];
            nArray[1] = 5;
            nArray[2] = 1;
            nArray[3] = 5;
            nArray[4] = 1;
            nArray[5] = 3;
            nArray[6] = 3;
            nArray[7] = 1;
            nArray[8] = 5;
            nArray[9] = 1;
            nArray[10] = 5;
            nArray[12] = w - 5;
            nArray[14] = w - 5;
            nArray[15] = 1;
            nArray[16] = w - 3;
            nArray[17] = 1;
            nArray[18] = w - 1;
            nArray[19] = 3;
            nArray[20] = w - 1;
            nArray[21] = 5;
            nArray[22] = w;
            nArray[23] = 5;
            nArray[24] = w;
            nArray[25] = h - 5;
            nArray[26] = w - 1;
            nArray[27] = h - 5;
            nArray[28] = w - 1;
            nArray[29] = h - 3;
            nArray[30] = w - 2;
            nArray[31] = h - 3;
            nArray[32] = w - 2;
            nArray[33] = h - 2;
            nArray[34] = w - 3;
            nArray[35] = h - 2;
            nArray[36] = w - 3;
            nArray[37] = h - 1;
            nArray[38] = w - 5;
            nArray[39] = h - 1;
            nArray[40] = w - 5;
            nArray[41] = h;
            nArray[42] = w - 16;
            nArray[43] = h;
            nArray[44] = w - 16;
            nArray[45] = h + t;
            nArray[46] = w - 35;
            nArray[47] = h;
            nArray[48] = 5;
            nArray[49] = h;
            nArray[50] = 5;
            nArray[51] = h - 1;
            nArray[52] = 3;
            nArray[53] = h - 1;
            nArray[54] = 3;
            nArray[55] = h - 2;
            nArray[56] = 2;
            nArray[57] = h - 2;
            nArray[58] = 2;
            nArray[59] = h - 3;
            nArray[60] = 1;
            nArray[61] = h - 3;
            nArray[62] = 1;
            nArray[63] = h - 5;
            nArray[65] = h - 5;
            nArray[67] = 5;
            polyline = nArray;
            int[] nArray5 = new int[56];
            nArray5[1] = 5;
            nArray5[2] = 1;
            nArray5[3] = 4;
            nArray5[4] = 1;
            nArray5[5] = 3;
            nArray5[6] = 3;
            nArray5[7] = 1;
            nArray5[8] = 4;
            nArray5[9] = 1;
            nArray5[10] = 5;
            nArray5[12] = w - 6;
            nArray5[14] = w - 5;
            nArray5[15] = 1;
            nArray5[16] = w - 4;
            nArray5[17] = 1;
            nArray5[18] = w - 2;
            nArray5[19] = 3;
            nArray5[20] = w - 2;
            nArray5[21] = 4;
            nArray5[22] = w - 1;
            nArray5[23] = 5;
            nArray5[24] = w - 1;
            nArray5[25] = h - 6;
            nArray5[26] = w - 2;
            nArray5[27] = h - 5;
            nArray5[28] = w - 2;
            nArray5[29] = h - 4;
            nArray5[30] = w - 4;
            nArray5[31] = h - 2;
            nArray5[32] = w - 5;
            nArray5[33] = h - 2;
            nArray5[34] = w - 6;
            nArray5[35] = h - 1;
            nArray5[36] = w - 17;
            nArray5[37] = h - 1;
            nArray5[38] = w - 17;
            nArray5[39] = h + t - 2;
            nArray5[40] = w - 36;
            nArray5[41] = h - 1;
            nArray5[42] = 5;
            nArray5[43] = h - 1;
            nArray5[44] = 4;
            nArray5[45] = h - 2;
            nArray5[46] = 3;
            nArray5[47] = h - 2;
            nArray5[48] = 1;
            nArray5[49] = h - 4;
            nArray5[50] = 1;
            nArray5[51] = h - 5;
            nArray5[53] = h - 6;
            nArray5[55] = 5;
            this.borderPolygon = nArray5;
            this.tip.setLocation(Math.min(dest.width - size.x, this.x - size.x + i), this.y - size.y - t);
        }
        if ((this.style & 0x1000) != 0) {
            if (this.region != null) {
                this.region.dispose();
            }
            this.region = new Region(display);
            this.region.add(polyline);
            this.tip.setRegion(this.region);
        }
    }

    public boolean getAutoHide() {
        this.checkWidget();
        return this.autohide;
    }

    Point getSize(int maxWidth) {
        int textWidth = 0;
        int messageWidth = 0;
        if (this.layoutText != null) {
            this.layoutText.setWidth(-1);
            textWidth = this.layoutText.getBounds().width;
        }
        if (this.layoutMessage != null) {
            this.layoutMessage.setWidth(-1);
            messageWidth = this.layoutMessage.getBounds().width;
        }
        int messageTrim = 28;
        boolean hasImage = this.layoutText != null && (this.style & 0x1000) != 0 && (this.style & 0xB) != 0;
        int textTrim = messageTrim + (hasImage ? 16 : 0);
        int width = Math.min(maxWidth, Math.max(textWidth + textTrim, messageWidth + messageTrim));
        int textHeight = 0;
        int messageHeight = 0;
        if (this.layoutText != null) {
            this.layoutText.setWidth(maxWidth - textTrim);
            textHeight = this.layoutText.getBounds().height;
        }
        if (this.layoutMessage != null) {
            this.layoutMessage.setWidth(maxWidth - messageTrim);
            messageHeight = this.layoutMessage.getBounds().height;
        }
        int height = 20 + messageHeight;
        if (this.layoutText != null) {
            height += Math.max(16, textHeight) + 10;
        }
        return new Point(width, height);
    }

    public String getMessage() {
        this.checkWidget();
        return this.layoutMessage != null ? this.layoutMessage.getText() : "";
    }

    public Shell getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getText() {
        this.checkWidget();
        return this.layoutText != null ? this.layoutText.getText() : "";
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.tip.getVisible();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void onDispose(Event event) {
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        if (this.runnable != null) {
            Display display = this.getDisplay();
            display.timerExec(-1, this.runnable);
        }
        this.runnable = null;
        this.tip.dispose();
        this.tip = null;
        if (this.region != null) {
            this.region.dispose();
        }
        this.region = null;
        if (this.layoutText != null) {
            this.layoutText.dispose();
        }
        this.layoutText = null;
        if (this.layoutMessage != null) {
            this.layoutMessage.dispose();
        }
        this.layoutMessage = null;
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        this.boldFont = null;
        this.borderPolygon = null;
    }

    void onMouseDown(Event event) {
        this.notifyListeners(13, new Event());
        this.setVisible(false);
    }

    void onPaint(Event event) {
        GC gc = event.gc;
        int x = 10;
        int y = 10;
        if ((this.style & 0x1000) != 0) {
            if (this.spikeAbove) {
                y += 20;
            }
            gc.drawPolygon(this.borderPolygon);
        } else {
            Rectangle rect = this.tip.getClientArea();
            gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
        }
        if (this.layoutText != null) {
            int id = this.style & 0xB;
            if ((this.style & 0x1000) != 0 && id != 0) {
                Display display = this.getDisplay();
                Image image = display.getSystemImage(id);
                Rectangle rect = image.getBounds();
                gc.drawImage(image, 0, 0, rect.width, rect.height, x, y, 16, 16);
                x += 16;
            }
            this.layoutText.draw(gc, x += 4, y);
            y += 10 + Math.max(16, this.layoutText.getBounds().height);
        }
        if (this.layoutMessage != null) {
            x = 14;
            this.layoutMessage.draw(gc, x, y);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setAutoHide(boolean autohide) {
        this.checkWidget();
        this.autohide = autohide;
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        if (this.x == x && this.y == y) {
            return;
        }
        this.x = x;
        this.y = y;
        if (this.tip.getVisible()) {
            this.configure();
        }
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            SWT.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.layoutMessage != null) {
            this.layoutMessage.dispose();
        }
        this.layoutMessage = null;
        if (string.length() != 0) {
            Display display = this.getDisplay();
            this.layoutMessage = new TextLayout(display);
            this.layoutMessage.setText(string);
        }
        if (this.tip.getVisible()) {
            this.configure();
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (this.layoutText != null) {
            this.layoutText.dispose();
        }
        this.layoutText = null;
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        this.boldFont = null;
        if (string.length() != 0) {
            Display display = this.getDisplay();
            this.layoutText = new TextLayout(display);
            this.layoutText.setText(string);
            Font font = display.getSystemFont();
            FontData data = font.getFontData()[0];
            this.boldFont = new Font(display, data.getName(), data.getHeight(), 1);
            TextStyle style = new TextStyle(this.boldFont, null, null);
            this.layoutText.setStyle(style, 0, string.length());
        }
        if (this.tip.getVisible()) {
            this.configure();
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.configure();
        }
        this.tip.setVisible(visible);
        Display display = this.getDisplay();
        if (this.runnable != null) {
            display.timerExec(-1, this.runnable);
        }
        this.runnable = null;
        if (this.autohide && visible) {
            this.runnable = new Runnable(){

                public void run() {
                    if (!ToolTip.this.isDisposed()) {
                        ToolTip.this.setVisible(false);
                    }
                }
            };
            display.timerExec(10000, this.runnable);
        }
    }
}

