/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class MessageBox
extends Dialog {
    String message;

    public MessageBox(Shell parent) {
        this(parent, 65570);
    }

    public MessageBox(Shell parent, int style) {
        super(parent, MessageBox.checkStyle(style));
        this.checkSubclass();
        this.message = "";
    }

    static int checkStyle(int style) {
        int mask;
        int bits;
        if ((style & 0x38000) == 0) {
            style |= 0x10000;
        }
        if ((bits = style & (mask = 4064)) == 32 || bits == 256 || bits == 288) {
            return style;
        }
        if (bits == 64 || bits == 128 || bits == 192 || bits == 448) {
            return style;
        }
        if (bits == 1280 || bits == 3584) {
            return style;
        }
        style = style & ~mask | 0x20;
        return style;
    }

    public String getMessage() {
        return this.message;
    }

    public int open() {
        int buttonBits = 0;
        if ((this.style & 0x20) == 32) {
            buttonBits = 0;
        }
        if ((this.style & 0x120) == 288) {
            buttonBits = 1;
        }
        if ((this.style & 0xC0) == 192) {
            buttonBits = 4;
        }
        if ((this.style & 0x1C0) == 448) {
            buttonBits = 3;
        }
        if ((this.style & 0x500) == 1280) {
            buttonBits = 1;
        }
        if ((this.style & 0xE00) == 3584) {
            buttonBits = 1;
        }
        if (buttonBits == 0) {
            buttonBits = 0;
        }
        int iconBits = 0;
        if ((this.style & 1) != 0) {
            iconBits = 16;
        }
        if ((this.style & 2) != 0) {
            iconBits = 64;
        }
        if ((this.style & 4) != 0) {
            iconBits = 32;
        }
        if ((this.style & 8) != 0) {
            iconBits = 48;
        }
        if ((this.style & 0x10) != 0) {
            iconBits = 64;
        }
        int messagePtr = this.parent.createDotNetString(this.message, false);
        int titlePtr = this.parent.createDotNetString(this.title, false);
        int code = OS.MessageBox_Show(messagePtr, titlePtr, buttonBits, iconBits, 0);
        OS.GCHandle_Free(titlePtr);
        OS.GCHandle_Free(messagePtr);
        switch (code) {
            case 7: {
                return 128;
            }
            case 1: {
                if ((this.style & 0x500) == 1280) {
                    return 1024;
                }
                if ((this.style & 0xE00) == 3584) {
                    return 512;
                }
                return 32;
            }
            case 6: {
                return 64;
            }
        }
        return 256;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }
}

