/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;

public class TableItem
extends Item {
    Table parent;
    Image[] images;
    int stringList;
    int imageList;
    int foregroundList;
    int backgroundList;
    int fontList;
    int checkState;
    boolean checked;
    boolean grayed;
    boolean cached;
    boolean ignoreNotify;

    public TableItem(Table parent, int style) {
        this(parent, style, -1);
    }

    public TableItem(Table parent, int style, int index) {
        this(parent, style, index, 0);
    }

    TableItem(Table parent, int style, int index, int handle) {
        super(parent, style);
        this.parent = parent;
        this.handle = handle;
        if (handle == 0) {
            parent.createItem(this, index);
        } else {
            this.createWidget();
        }
    }

    double computeWidth(int columnIndex) {
        int rowPresenterType = OS.GridViewRowPresenter_typeid();
        int rowPresenter = this.findRowPresenter(this.handle, rowPresenterType);
        double width = 0.0;
        if (rowPresenter != 0) {
            int contentPresenter = OS.VisualTreeHelper_GetChild(rowPresenter, columnIndex);
            if (columnIndex != 0) {
                int availSize = OS.gcnew_Size(2.147483647E9, 2.147483647E9);
                OS.UIElement_Measure(contentPresenter, availSize);
                OS.GCHandle_Free(availSize);
            }
            int size = OS.UIElement_DesiredSize(contentPresenter);
            width = OS.Size_Width(size);
            OS.GCHandle_Free(size);
            OS.GCHandle_Free(contentPresenter);
            OS.GCHandle_Free(rowPresenter);
        }
        OS.GCHandle_Free(rowPresenterType);
        return width;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void columnAdded(int index) {
        int newLength = this.parent.columnCount + 1;
        if (this.images != null) {
            Image[] temp = new Image[newLength];
            System.arraycopy(this.images, 0, temp, 0, index);
            System.arraycopy(this.images, index, temp, index + 1, this.parent.columnCount - index);
            this.images = temp;
        }
        OS.ArrayList_Insert(this.stringList, index, 0);
        OS.ArrayList_Insert(this.imageList, index, 0);
    }

    void columnRemoved(int index) {
        if (this.images != null) {
            Image[] temp = new Image[this.parent.columnCount];
            System.arraycopy(this.images, 0, temp, 0, index);
            System.arraycopy(this.images, index + 1, temp, index, this.parent.columnCount - index);
            this.images = temp;
        }
        OS.ArrayList_RemoveAt(this.stringList, index);
        OS.ArrayList_RemoveAt(this.imageList, index);
    }

    void createHandle() {
        if (this.handle == 0) {
            this.handle = OS.gcnew_ListViewItem();
            if (this.handle == 0) {
                this.error(2);
            }
            int row = OS.gcnew_SWTRow(this.parent.jniRef, this.handle);
            OS.ContentControl_Content(this.handle, row);
            OS.GCHandle_Free(row);
        }
        OS.Control_HorizontalContentAlignment(this.handle, 3);
        OS.Control_VerticalContentAlignment(this.handle, 3);
        this.updateCheckState(false);
    }

    void clear() {
        if (this.imageList != 0) {
            OS.GCHandle_Free(this.imageList);
        }
        this.imageList = 0;
        this.images = null;
        if (this.stringList != 0) {
            OS.GCHandle_Free(this.stringList);
        }
        this.stringList = 0;
        this.grayed = false;
        this.checked = false;
        this.updateCheckState(false);
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = false;
        }
        if (this.ignoreNotify) {
            return;
        }
        int row = OS.ContentControl_Content(this.handle);
        OS.SWTRow_NotifyPropertyChanged(row, 0);
        OS.SWTRow_NotifyPropertyChanged(row, 1);
        OS.GCHandle_Free(row);
    }

    void deregister() {
        this.display.removeWidget(this.handle);
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    int findRowPresenter(int current, int rowPresenterType) {
        int type = OS.Object_GetType(current);
        boolean found = OS.Object_Equals(rowPresenterType, type);
        OS.GCHandle_Free(type);
        if (found) {
            return current;
        }
        int childCount = OS.VisualTreeHelper_GetChildrenCount(current);
        int i = 0;
        while (i < childCount) {
            int result;
            int child = OS.VisualTreeHelper_GetChild(current, i);
            if (child != (result = this.findRowPresenter(child, rowPresenterType))) {
                OS.GCHandle_Free(child);
            }
            if (result != 0) {
                return result;
            }
            ++i;
        }
        return 0;
    }

    int findPart(int column, String partName) {
        if (!OS.FrameworkElement_IsLoaded(this.handle)) {
            this.updateLayout(this.handle);
        }
        if (!OS.FrameworkElement_IsLoaded(this.handle)) {
            return 0;
        }
        int rowPresenterType = OS.GridViewRowPresenter_typeid();
        int rowPresenter = this.findRowPresenter(this.handle, rowPresenterType);
        int contentPresenter = OS.VisualTreeHelper_GetChild(rowPresenter, column);
        int columns = OS.GridView_Columns(this.parent.gridViewHandle);
        int columnHandle = OS.GridViewColumnCollection_default(columns, column);
        int cellTemplate = OS.GridViewColumn_CellTemplate(columnHandle);
        int name = this.createDotNetString(partName, false);
        int result = OS.FrameworkTemplate_FindName(cellTemplate, name, contentPresenter);
        OS.GCHandle_Free(rowPresenterType);
        OS.GCHandle_Free(rowPresenter);
        OS.GCHandle_Free(contentPresenter);
        OS.GCHandle_Free(columns);
        OS.GCHandle_Free(columnHandle);
        OS.GCHandle_Free(cellTemplate);
        OS.GCHandle_Free(name);
        return result;
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.parent.getBackground();
    }

    public Color getBackground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return this.getBackground();
        }
        return this.parent.getBackground();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int parentHandle = this.parent.topHandle();
        int point = OS.gcnew_Point(0.0, 0.0);
        if (point == 0) {
            this.error(2);
        }
        int location = OS.UIElement_TranslatePoint(this.handle, point, parentHandle);
        int x = (int)OS.Point_X(location);
        int y = (int)OS.Point_Y(location);
        OS.GCHandle_Free(point);
        OS.GCHandle_Free(location);
        int width = (int)OS.FrameworkElement_ActualWidth(this.handle);
        int height = (int)OS.FrameworkElement_ActualHeight(this.handle);
        return new Rectangle(x, y, width, height);
    }

    public Rectangle getBounds(int index) {
        this.checkWidget();
        if (index != 0 && !this.parent.checkData(this)) {
            this.error(24);
        }
        if (index < 0 || index >= this.parent.columnCount) {
            return new Rectangle(0, 0, 0, 0);
        }
        int rowPresenterType = OS.GridViewRowPresenter_typeid();
        int rowPresenter = this.findRowPresenter(this.handle, rowPresenterType);
        int contentPresenter = OS.VisualTreeHelper_GetChild(rowPresenter, index);
        int point = OS.gcnew_Point(0.0, 0.0);
        if (point == 0) {
            this.error(2);
        }
        int parentHandle = this.parent.topHandle();
        int location = OS.UIElement_TranslatePoint(contentPresenter, point, parentHandle);
        int x = (int)OS.Point_X(location);
        int y = (int)OS.Point_Y(location);
        int width = (int)OS.FrameworkElement_ActualWidth(contentPresenter);
        int height = (int)OS.FrameworkElement_ActualHeight(this.handle);
        OS.GCHandle_Free(rowPresenter);
        OS.GCHandle_Free(rowPresenterType);
        OS.GCHandle_Free(point);
        OS.GCHandle_Free(location);
        OS.GCHandle_Free(contentPresenter);
        return new Rectangle(x, y, width, height);
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.checked;
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.parent.getFont();
    }

    public Font getFont(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return this.getFont();
        }
        return this.parent.getFont();
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.parent.getForeground();
    }

    public Color getForeground(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return this.getForeground();
        }
        return this.parent.getForeground();
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.getImage(0);
    }

    public Image getImage(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (this.images != null && index >= 0 && index < this.images.length) {
            return this.images[index];
        }
        return null;
    }

    public Rectangle getImageBounds(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (index != 0 && (index < 0 || index >= this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        int parentHandle = this.parent.topHandle();
        int part = this.findPart(index, "SWT_PART_IMAGE");
        int point = OS.gcnew_Point(0.0, 0.0);
        if (point == 0) {
            this.error(2);
        }
        int location = OS.UIElement_TranslatePoint(part, point, parentHandle);
        int x = (int)OS.Point_X(location);
        int y = (int)OS.Point_Y(location);
        OS.GCHandle_Free(point);
        OS.GCHandle_Free(location);
        int width = (int)OS.FrameworkElement_ActualWidth(part);
        int height = (int)OS.FrameworkElement_ActualHeight(part);
        OS.GCHandle_Free(part);
        return new Rectangle(x, y, width, height);
    }

    public int getImageIndent() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return 0;
    }

    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Rectangle getTextBounds(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (index != 0 && (index < 0 || index >= this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        int parentHandle = this.parent.topHandle();
        int part = this.findPart(index, "SWT_PART_TEXT");
        int point = OS.gcnew_Point(0.0, 0.0);
        if (point == 0) {
            this.error(2);
        }
        int location = OS.UIElement_TranslatePoint(part, point, parentHandle);
        int x = (int)OS.Point_X(location);
        int y = (int)OS.Point_Y(location);
        OS.GCHandle_Free(point);
        OS.GCHandle_Free(location);
        int width = (int)OS.FrameworkElement_ActualWidth(part);
        int height = (int)OS.FrameworkElement_ActualHeight(part);
        OS.GCHandle_Free(part);
        return new Rectangle(x, y, width, height);
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.getText(0);
    }

    public String getText(int index) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (this.stringList != 0 && index >= 0 && index < OS.ArrayList_Count(this.stringList)) {
            int ptr = OS.ArrayList_default(this.stringList, index);
            String result = TableItem.createJavaString(ptr);
            OS.GCHandle_Free(ptr);
            return result;
        }
        return "";
    }

    Control getWidgetControl() {
        return this.parent;
    }

    void register() {
        this.display.addWidget(this.handle, this);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.handle != 0) {
            OS.GCHandle_Free(this.handle);
        }
        this.handle = 0;
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != 0) {
            OS.GCHandle_Free(this.imageList);
        }
        this.imageList = 0;
        if (this.stringList != 0) {
            OS.GCHandle_Free(this.stringList);
        }
        this.stringList = 0;
        if (this.checkState != 0) {
            OS.GCHandle_Free(this.checkState);
        }
        this.checkState = 0;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public void setBackground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public void setChecked(boolean checked) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.checked == checked) {
            return;
        }
        this.checked = checked;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.updateCheckState(true);
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public void setFont(int index, Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public void setForeground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.grayed == grayed) {
            return;
        }
        this.grayed = grayed;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.updateCheckState(true);
    }

    public void setImage(Image[] images) {
        this.checkWidget();
        if (images == null) {
            this.error(4);
        }
        int i = 0;
        while (i < images.length) {
            this.setImage(i, images[i]);
            ++i;
        }
    }

    public void setImage(int index, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if (this.images == null) {
            this.images = new Image[count];
        }
        this.images[index] = image;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.imageList == 0) {
            this.imageList = OS.gcnew_ArrayList(count);
            int i = 0;
            while (i < count) {
                OS.ArrayList_Insert(this.imageList, i, 0);
                ++i;
            }
        }
        int imageHandle = image != null ? image.handle : 0;
        OS.ArrayList_default(this.imageList, index, imageHandle);
        if (this.ignoreNotify) {
            return;
        }
        int row = OS.ContentControl_Content(this.handle);
        OS.SWTRow_NotifyPropertyChanged(row, 1);
        OS.GCHandle_Free(row);
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setImageIndent(int indent) {
        this.checkWidget();
    }

    public void setText(String[] strings) {
        this.checkWidget();
        if (strings == null) {
            this.error(4);
        }
        int i = 0;
        while (i < strings.length) {
            String string = strings[i];
            if (string != null) {
                this.setText(i, string);
            }
            ++i;
        }
    }

    public void setText(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int count = Math.max(1, this.parent.getColumnCount());
        if (index < 0 || index > count - 1) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (this.stringList == 0) {
            this.stringList = OS.gcnew_ArrayList(count);
            int i = 0;
            while (i < count) {
                OS.ArrayList_Insert(this.stringList, i, 0);
                ++i;
            }
        }
        int str = this.createDotNetString(string, false);
        OS.ArrayList_default(this.stringList, index, str);
        OS.GCHandle_Free(str);
        if (this.ignoreNotify) {
            return;
        }
        int row = OS.ContentControl_Content(this.handle);
        OS.SWTRow_NotifyPropertyChanged(row, 0);
        OS.GCHandle_Free(row);
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }

    void updateCheckState(boolean notify) {
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.checkState != 0) {
            OS.GCHandle_Free(this.checkState);
        }
        this.checkState = this.checked ? (this.grayed ? OS.gcnew_IntPtr(2) : OS.gcnew_IntPtr(1)) : OS.gcnew_IntPtr(0);
        if (notify) {
            int row = OS.ContentControl_Content(this.handle);
            OS.SWTRow_NotifyPropertyChanged(row, 4);
            OS.GCHandle_Free(row);
        }
    }
}

