/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    public int handle;
    int jniRef;
    int style;
    int state;
    Display display;
    EventTable eventTable;
    Object data;
    static final int DISPOSED = 1;
    static final int CANVAS = 2;
    static final int KEYED_DATA = 4;
    static final int DISABLED = 8;
    static final int HIDDEN = 16;
    static final int LAYOUT_NEEDED = 32;
    static final int LAYOUT_CHANGED = 64;
    static final int LAYOUT_CHILD = 128;
    static final int THEME_BACKGROUND = 256;
    static final int DRAW_BACKGROUND = 512;
    static final int PARENT_BACKGROUND = 1024;
    static final int RELEASED = 2048;
    static final int DISPOSE_SENT = 4096;
    static final int MOVED = 8192;
    static final int RESIZED = 16384;
    static final int DRAG_DETECT = 32768;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int CLICK = 1;

    Widget() {
    }

    public Widget(Widget parent, int style) {
        this.checkSubclass();
        this.checkParent(parent);
        this.style = style;
        this.display = parent.display;
    }

    void _addListener(int eventType, Listener listener) {
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, listener);
    }

    public void addListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this._addListener(eventType, listener);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(12, typedListener);
    }

    void addWidget() {
    }

    static int checkBits(int style, int int0, int int1, int int2, int int3, int int4, int int5) {
        int mask = int0 | int1 | int2 | int3 | int4 | int5;
        if ((style & mask) == 0) {
            style |= int0;
        }
        if ((style & int0) != 0) {
            style = style & ~mask | int0;
        }
        if ((style & int1) != 0) {
            style = style & ~mask | int1;
        }
        if ((style & int2) != 0) {
            style = style & ~mask | int2;
        }
        if ((style & int3) != 0) {
            style = style & ~mask | int3;
        }
        if ((style & int4) != 0) {
            style = style & ~mask | int4;
        }
        if ((style & int5) != 0) {
            style = style & ~mask | int5;
        }
        return style;
    }

    boolean checkEvent(int e) {
        if (this.isDisposed()) {
            return false;
        }
        int routedEventType = OS.RoutedEventArgs_typeid();
        int source = 0;
        if (OS.Type_IsInstanceOfType(routedEventType, e)) {
            source = OS.RoutedEventArgs_OriginalSource(e);
        }
        OS.GCHandle_Free(routedEventType);
        if (source == 0) {
            return true;
        }
        if (OS.Object_Equals(source, this.handle)) {
            OS.GCHandle_Free(source);
            return true;
        }
        Widget widget = this.display.getWidget(source);
        OS.GCHandle_Free(source);
        if (widget == this) {
            return true;
        }
        return this.hasItems() && this == widget.getWidgetControl();
    }

    void checkOrientation(Widget parent) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && parent != null) {
            if ((parent.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((parent.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    void checkOpened() {
    }

    void checkParent(Widget parent) {
        if (parent == null) {
            this.error(4);
        }
        if (parent.isDisposed()) {
            this.error(5);
        }
        parent.checkWidget();
        parent.checkOpened();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    void createHandle() {
    }

    int createDotNetString(String string, boolean fixMnemonic) {
        char[] buffer;
        if (string == null) {
            return 0;
        }
        if (fixMnemonic) {
            buffer = this.fixMnemonic(string);
        } else {
            int length = string.length();
            buffer = new char[length + 1];
            string.getChars(0, length, buffer, 0);
        }
        int ptr = OS.gcnew_String(buffer);
        if (ptr == 0) {
            this.error(2);
        }
        return ptr;
    }

    static String createJavaString(int ptr) {
        int charArray = OS.String_ToCharArray(ptr);
        char[] chars = new char[OS.String_Length(ptr)];
        OS.memcpy(chars, charArray, chars.length * 2);
        OS.GCHandle_Free(charArray);
        return new String(chars);
    }

    void createWidget() {
        this.jniRef = OS.NewGlobalRef(this);
        if (this.jniRef == 0) {
            this.error(2);
        }
        this.createHandle();
        this.addWidget();
        this.register();
        this.hookEvents();
    }

    void deregister() {
    }

    void destroyWidget() {
        this.releaseHandle();
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.release(true);
    }

    boolean dragOverride() {
        return false;
    }

    static void dumpObjectType(int object) {
        int objectType = OS.Object_GetType(object);
        int type = OS.Type_FullName(objectType);
        String typeName = Widget.createJavaString(type);
        OS.GCHandle_Free(objectType);
        OS.GCHandle_Free(type);
        System.out.println(typeName);
    }

    void dumpVisualTree(int visual, int depth) {
        int i = 0;
        while (i < depth) {
            System.out.print("\t");
            ++i;
        }
        int type = OS.Object_GetType(visual);
        int typeNamePtr = OS.Type_FullName(type);
        OS.GCHandle_Free(type);
        String typeName = Widget.createJavaString(typeNamePtr);
        OS.GCHandle_Free(typeNamePtr);
        int name = OS.FrameworkElement_Name(visual);
        String widgetName = Widget.createJavaString(name);
        OS.GCHandle_Free(name);
        System.out.println(String.valueOf(typeName) + " [" + widgetName + "]");
        int count = OS.VisualTreeHelper_GetChildrenCount(visual);
        int i2 = 0;
        while (i2 < count) {
            int child = OS.VisualTreeHelper_GetChild(visual, i2);
            this.dumpVisualTree(child, depth + 1);
            OS.GCHandle_Free(child);
            ++i2;
        }
    }

    void error(int code) {
        SWT.error(code);
    }

    boolean filters(int eventType) {
        return this.display.filters(eventType);
    }

    char[] fixMnemonic(String string) {
        int length = string.length();
        char[] text = new char[length];
        string.getChars(0, length, text, 0);
        int i = 0;
        int j = 0;
        char[] result = new char[length * 2 + 1];
        while (i < length) {
            switch (text[i]) {
                case '&': {
                    if (i + 1 < length && text[i + 1] == '&') break;
                    text[i] = 95;
                    break;
                }
                case '_': {
                    result[j++] = 95;
                }
            }
            int n = j++;
            int n2 = ++i;
            ++i;
            result[n] = text[n2];
        }
        return result;
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String key) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        if ((this.state & 4) != 0) {
            Object[] table = (Object[])this.data;
            int i = 1;
            while (i < table.length) {
                if (key.equals(table[i])) {
                    return table[i + 1];
                }
                i += 2;
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        return display;
    }

    Menu getMenu() {
        return null;
    }

    String getName() {
        String string = this.getClass().getName();
        int index = string.lastIndexOf(46);
        if (index == -1) {
            return string;
        }
        return string.substring(index + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    Control getWidgetControl() {
        return null;
    }

    boolean hasItems() {
        return false;
    }

    void hookEvents() {
    }

    boolean hooks(int eventType) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(eventType);
    }

    public boolean isDisposed() {
        return (this.state & 1) != 0;
    }

    public boolean isListening(int eventType) {
        this.checkWidget();
        return this.hooks(eventType);
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    void mapEvent(int hwnd, Event event) {
    }

    boolean mnemonicMatch(int accessText, char key) {
        if (accessText == 0) {
            return false;
        }
        char mnemonic = OS.AccessText_AccessKey(accessText);
        return Character.toLowerCase(key) == Character.toLowerCase(mnemonic);
    }

    public void notifyListeners(int eventType, Event event) {
        this.checkWidget();
        if (event == null) {
            event = new Event();
        }
        this.sendEvent(eventType, event);
    }

    void postEvent(int eventType) {
        this.sendEvent(eventType, null, false);
    }

    void postEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, false);
    }

    void register() {
    }

    void release(boolean destroy) {
        if ((this.state & 0x1000) == 0) {
            this.state |= 0x1000;
            this.sendEvent(12);
        }
        if ((this.state & 1) == 0) {
            this.releaseChildren(destroy);
        }
        if ((this.state & 0x800) == 0) {
            this.state |= 0x800;
            if (destroy) {
                this.releaseParent();
                this.releaseWidget();
                this.destroyWidget();
            } else {
                this.releaseWidget();
                this.releaseHandle();
            }
        }
    }

    void releaseChildren(boolean destroy) {
    }

    void releaseHandle() {
        this.state |= 1;
        this.display = null;
        if (this.jniRef != 0) {
            OS.DeleteGlobalRef(this.jniRef);
        }
        this.jniRef = 0;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        this.deregister();
        this.eventTable = null;
        this.data = null;
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    protected void removeListener(int eventType, SWTEventListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, listener);
    }

    boolean sendDragEvent(int e) {
        return this.sendMouseEvent(29, e, false);
    }

    boolean sendDragEvent(int button, int stateMask, int x, int y) {
        Event event = new Event();
        event.button = button;
        event.x = x;
        event.y = y;
        event.stateMask = stateMask;
        this.postEvent(29, event);
        return event.doit;
    }

    void sendEvent(Event event) {
        Display display = event.display;
        if (!display.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    void sendEvent(int eventType) {
        this.sendEvent(eventType, null, true);
    }

    void sendEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, true);
    }

    void sendEvent(int eventType, Event event, boolean send) {
        if (this.eventTable == null && !this.display.filters(eventType)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = eventType;
        event.display = this.display;
        event.widget = this;
        if (event.time == 0) {
            event.time = this.display.getLastEventTime();
        }
        if (send) {
            this.sendEvent(event);
        } else {
            this.display.postEvent(event);
        }
    }

    boolean sendKeyEvent(int type, int e, boolean textInput) {
        if (textInput) {
            int text = OS.TextCompositionEventArgs_Text(e);
            if (OS.String_Length(text) == 0) {
                OS.GCHandle_Free(text);
                text = OS.TextCompositionEventArgs_SystemText(e);
                if (OS.String_Length(text) == 0) {
                    OS.GCHandle_Free(text);
                    text = OS.TextCompositionEventArgs_ControlText(e);
                    if (OS.String_Length(text) == 0) {
                        return false;
                    }
                }
            }
            int chars = OS.String_ToCharArray(text);
            char[] buffer = new char[OS.String_Length(text)];
            OS.memcpy(buffer, chars, buffer.length * 2);
            OS.GCHandle_Free(chars);
            OS.GCHandle_Free(text);
            int i = 0;
            while (i < buffer.length) {
                Event event = new Event();
                if (buffer.length == 1) {
                    event.keyCode = Display.translateKey(this.display.lastKey);
                }
                event.character = buffer[i];
                if (this.display.deadChar) {
                    event.character = this.display.lastChar;
                    this.display.deadChar = false;
                }
                this.setInputState(event, type, 0, 0);
                this.sendEvent(type, event);
                if (this.isDisposed()) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        Event event = new Event();
        if (!this.setKeyState(event, type, e)) {
            return true;
        }
        this.sendEvent(type, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    boolean sendMouseEvent(int type, int e, boolean send) {
        if (!this.hooks(type) && !this.filters(type)) {
            return true;
        }
        Event event = new Event();
        if (type == 3 || type == 4 || type == 29) {
            event.button = OS.MouseButtonEventArgs_ChangedButton(e) + 1;
            event.count = OS.MouseButtonEventArgs_ClickCount(e);
        }
        if (type == 37) {
            int lines = OS.SystemParameters_WheelScrollLines();
            int delta = OS.MouseWheelEventArgs_Delta(e);
            if (lines == -1) {
                event.detail = 2;
                event.count = delta / 120;
            } else {
                event.detail = 1;
                event.count = delta * lines / 120;
            }
        }
        int point = OS.MouseEventArgs_GetPosition(e, this.handle);
        event.x = (int)OS.Point_X(point);
        event.y = (int)OS.Point_Y(point);
        OS.GCHandle_Free(point);
        this.setInputState(event, type, e, 0);
        Event doubleClick = null;
        if (type == 3 && (event.count & 1) == 0) {
            doubleClick = new Event();
            doubleClick.button = event.button;
            doubleClick.x = event.x;
            doubleClick.y = event.y;
            doubleClick.count = event.count;
            doubleClick.stateMask = event.stateMask;
        }
        if (send) {
            this.sendEvent(type, event);
            if (this.isDisposed()) {
                return false;
            }
        } else {
            this.postEvent(type, event);
        }
        if (doubleClick != null) {
            if (send) {
                this.sendEvent(8, doubleClick);
                if (this.isDisposed()) {
                    return false;
                }
            } else {
                this.postEvent(8, doubleClick);
            }
        }
        return event.doit;
    }

    void setClipping(int widget, boolean clip) {
        int drawingVisualType;
        int type = OS.Object_GetType(widget);
        if (!OS.Object_Equals(type, drawingVisualType = OS.DrawingVisual_typeid())) {
            OS.UIElement_ClipToBounds(widget, clip);
        }
        OS.GCHandle_Free(drawingVisualType);
        OS.GCHandle_Free(type);
        int count = OS.VisualTreeHelper_GetChildrenCount(widget);
        int i = 0;
        while (i < count) {
            int child = OS.VisualTreeHelper_GetChild(widget, i);
            this.setClipping(child, clip);
            OS.GCHandle_Free(child);
            ++i;
        }
    }

    public void setData(Object data) {
        this.checkWidget();
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = data;
        } else {
            this.data = data;
        }
    }

    public void setData(String key, Object value) {
        String string;
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        int index = 1;
        Object[] table = null;
        if ((this.state & 4) != 0) {
            table = (Object[])this.data;
            while (index < table.length) {
                if (key.equals(table[index])) break;
                index += 2;
            }
        }
        if (value != null) {
            if ((this.state & 4) != 0) {
                if (index == table.length) {
                    Object[] newTable = new Object[table.length + 2];
                    System.arraycopy(table, 0, newTable, 0, table.length);
                    table = newTable;
                    this.data = newTable;
                }
            } else {
                table = new Object[3];
                table[0] = this.data;
                this.data = table;
                this.state |= 4;
            }
            table[index] = key;
            table[index + 1] = value;
        } else if ((this.state & 4) != 0 && index != table.length) {
            int length = table.length - 2;
            if (length == 1) {
                this.data = table[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] newTable = new Object[length];
                System.arraycopy(table, 0, newTable, 0, index);
                System.arraycopy(table, index + 2, newTable, index, length - index);
                this.data = newTable;
            }
        }
        if ("XAML".equals(key) && value instanceof String) {
            this.setClipping(this.topHandle(), false);
            string = (String)value;
            int ptr = this.createDotNetString(string, false);
            int stringReader = OS.gcnew_StringReader(ptr);
            int xmlReader = OS.XmlReader_Create(stringReader);
            int resource = OS.XamlReader_Load(xmlReader);
            if (resource != 0) {
                OS.FrameworkElement_Resources(this.handle, resource);
                OS.GCHandle_Free(resource);
            }
            OS.GCHandle_Free(xmlReader);
            OS.GCHandle_Free(stringReader);
            OS.GCHandle_Free(ptr);
        }
        if ("ResourceDictionary".equals(key) && value instanceof String) {
            string = (String)value;
            int ptr = this.createDotNetString(string, false);
            int uri = OS.gcnew_Uri(ptr, 0);
            int resources = OS.gcnew_ResourceDictionary();
            OS.ResourceDictionary_Source(resources, uri);
            OS.FrameworkElement_Resources(this.handle, resources);
            OS.GCHandle_Free(resources);
            OS.GCHandle_Free(uri);
            OS.GCHandle_Free(ptr);
        }
    }

    boolean sendFocusEvent(int type) {
        this.sendEvent(type);
        return true;
    }

    boolean setInputState(Event event, int type, int mouseEvent, int keyEvent) {
        int modifiers;
        if (keyEvent != 0) {
            int keyboardDevice = OS.KeyboardEventArgs_KeyboardDevice(keyEvent);
            modifiers = OS.KeyboardDevice_Modifiers(keyboardDevice);
            OS.GCHandle_Free(keyboardDevice);
        } else {
            modifiers = OS.Keyboard_Modifiers();
        }
        if ((modifiers & 1) != 0) {
            event.stateMask |= 0x10000;
        }
        if ((modifiers & 4) != 0) {
            event.stateMask |= 0x20000;
        }
        if ((modifiers & 2) != 0) {
            event.stateMask |= 0x40000;
        }
        if (mouseEvent != 0) {
            if (OS.MouseEventArgs_LeftButton(mouseEvent) == 1) {
                event.stateMask |= 0x80000;
            }
            if (OS.MouseEventArgs_MiddleButton(mouseEvent) == 1) {
                event.stateMask |= 0x100000;
            }
            if (OS.MouseEventArgs_RightButton(mouseEvent) == 1) {
                event.stateMask |= 0x200000;
            }
            if (OS.MouseEventArgs_XButton1(mouseEvent) == 1) {
                event.stateMask |= 0x800000;
            }
            if (OS.MouseEventArgs_XButton2(mouseEvent) == 1) {
                event.stateMask |= 0x2000000;
            }
        } else {
            if (OS.Mouse_LeftButton() == 1) {
                event.stateMask |= 0x80000;
            }
            if (OS.Mouse_MiddleButton() == 1) {
                event.stateMask |= 0x100000;
            }
            if (OS.Mouse_RightButton() == 1) {
                event.stateMask |= 0x200000;
            }
            if (OS.Mouse_XButton1() == 1) {
                event.stateMask |= 0x800000;
            }
            if (OS.Mouse_XButton2() == 1) {
                event.stateMask |= 0x2000000;
            }
        }
        switch (type) {
            case 3: 
            case 8: {
                if (event.button == 1) {
                    event.stateMask &= 0xFFF7FFFF;
                }
                if (event.button == 2) {
                    event.stateMask &= 0xFFEFFFFF;
                }
                if (event.button == 3) {
                    event.stateMask &= 0xFFDFFFFF;
                }
                if (event.button == 4) {
                    event.stateMask &= 0xFF7FFFFF;
                }
                if (event.button != 5) break;
                event.stateMask &= 0xFDFFFFFF;
                break;
            }
            case 4: {
                if (event.button == 1) {
                    event.stateMask |= 0x80000;
                }
                if (event.button == 2) {
                    event.stateMask |= 0x100000;
                }
                if (event.button == 3) {
                    event.stateMask |= 0x200000;
                }
                if (event.button == 4) {
                    event.stateMask |= 0x800000;
                }
                if (event.button != 5) break;
                event.stateMask |= 0x2000000;
                break;
            }
            case 1: 
            case 31: {
                if (event.keyCode == 65536) {
                    event.stateMask &= 0xFFFEFFFF;
                }
                if (event.keyCode == 131072) {
                    event.stateMask &= 0xFFFDFFFF;
                }
                if (event.keyCode != 262144) break;
                event.stateMask &= 0xFFFBFFFF;
                break;
            }
            case 2: {
                if (event.keyCode == 65536) {
                    event.stateMask |= 0x10000;
                }
                if (event.keyCode == 131072) {
                    event.stateMask |= 0x20000;
                }
                if (event.keyCode != 262144) break;
                event.stateMask |= 0x40000;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean setKeyState(Event event, int type, int e) {
        int key = this.display.lastKey = OS.KeyEventArgs_Key(e);
        boolean repeat = OS.KeyEventArgs_IsRepeat(e);
        switch (key) {
            case 155: {
                return false;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                if (!repeat) break;
                return false;
            }
            case 156: {
                key = OS.KeyEventArgs_SystemKey(e);
                switch (key) {
                    case 120: 
                    case 121: {
                        if (!repeat) break;
                        return false;
                    }
                }
                break;
            }
        }
        boolean textual = false;
        int vKey = OS.KeyInterop_VirtualKeyFromKey(key);
        int mapKey = OS.MapVirtualKeyW(vKey, 2);
        if ((mapKey & Integer.MIN_VALUE) != 0) {
            this.display.deadChar = true;
            return false;
        }
        char[] result = new char[1];
        byte[] keyboard = new byte[256];
        OS.GetKeyboardState(keyboard);
        boolean bl = textual = OS.ToUnicode(vKey, 0, keyboard, result, 1, 0) == 1;
        if (textual && type == 1) {
            if (this.display.deadChar) {
                this.display.lastChar = result[0];
            }
            return false;
        }
        event.keyCode = Display.translateKey(key);
        switch (key) {
            case 2: {
                event.character = (char)8;
                break;
            }
            case 4: {
                event.character = (char)10;
                break;
            }
            case 6: {
                event.character = (char)13;
                break;
            }
            case 32: {
                event.character = (char)127;
                break;
            }
            case 13: {
                event.character = (char)27;
                break;
            }
            case 3: {
                event.character = (char)9;
                break;
            }
        }
        if (type == 2) {
            event.character = result[0];
        }
        return this.setInputState(event, type, 0, e);
    }

    boolean showMenu(int x, int y) {
        Event event = new Event();
        event.x = x;
        event.y = y;
        this.sendEvent(35, event);
        if (!event.doit) {
            return true;
        }
        Menu menu = this.getMenu();
        if (menu != null && !menu.isDisposed()) {
            if (x != event.x || y != event.y) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            return true;
        }
        return false;
    }

    int topHandle() {
        return this.handle;
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return String.valueOf(this.getName()) + " {" + string + "}";
    }

    void updateLayout(int updateHandle) {
        boolean ignore = this.display.ignoreRender;
        this.display.ignoreRender = true;
        OS.UIElement_UpdateLayout(updateHandle);
        this.display.ignoreRender = ignore;
    }
}

