package jp.sourceforge.talisman.csvio;

/*
 * $Id: CsvLineBuilder.java 6 2007-08-11 02:25:00Z tama3 $
 */

/**
 * Interface for building {@link CsvLine <code>CsvLine</code>} from given a line.
 * 
 * @author Haruaki Tamada
 * @version $Revision: 6 $ $Date: 2007-08-11 11:25:00 +0900 (Sat, 11 Aug 2007) $
 */
public interface CsvLineBuilder{
    /**
     * returns parsing settings.
     */
    public CsvIOSetting getSetting();

    /**
     * sets parsing settings.
     */
    public void setSetting(CsvIOSetting setting);

    /**
     * build CsvLine from given line.
     */
    public CsvLine buildCsvLine(String line);
}
