package jp.sourceforge.talisman.csvio.builder;

/*
 * $Id: CsvLineBuilderFactory.java 4 2007-08-11 01:41:41Z tama3 $
 */

import jp.sourceforge.talisman.csvio.CsvIOSetting;
import jp.sourceforge.talisman.csvio.CsvLineBuilder;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision: 4 $ $Date: 2007-08-11 10:41:41 +0900 (Sat, 11 Aug 2007) $
 */
public class CsvLineBuilderFactory{
    private static final CsvLineBuilderFactory factory = new CsvLineBuilderFactory();

    private CsvLineBuilderFactory(){
        // singleton pattern
    }

    public static CsvLineBuilderFactory getInstance(){
        return factory;
    }

    public CsvLineBuilder createBuilder(){
        return createBuilder(new CsvIOSetting());
    }

    public CsvLineBuilder createBuilder(CsvIOSetting setting){
        CsvLineBuilder builder = null;

        switch(setting.getQuotationMode()){
        case ALWAYS:
        case AS_NEEDED:
            builder = new QuoteAsNeededCsvLineBuilder(setting);
            break;
        case NEVER:
            builder = new NoQuoteCsvLineBuilder(setting);
            break;
        }
        return builder;
    }
}
