package jp.sourceforge.talisman.csvio.translator;

/*
 * $Id: Transpose.java 6 2007-08-11 02:25:00Z tama3 $
 */

import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.talisman.csvio.CsvLine;

/**
 * Transpose given csv file.
 * For example,
 * <pre>1,2,3
 * 4,5
 * 6</pre>
 * <p>is translated to</p>
 * <pre>1,4,6
 * 2,5
 * 3</pre> 
 * 
 * @author Haruaki TAMADA
 * @version $Revision: 6 $ $Date: 2007-08-11 11:25:00 +0900 (Sat, 11 Aug 2007) $
 */
public class Transpose implements Translator{

    public CsvLine[] translate(CsvLine[] file){
        List<CsvLine> list = new ArrayList<CsvLine>();

        for(int i = 0; i < file.length; i++){
            for(int j = 0; j < file[i].size(); j++){
                if(list.size() <= j){
                    list.add(new CsvLine());
                }
                String element = file[i].getValue(j);
                list.get(j).addValue(i, element);
            }
        }

        return list.toArray(new CsvLine[list.size()]);
    }

}
