package jp.sourceforge.talisman.xmlcli.builder;

/*
 * $Id: SaxOptionsBuilder.java,v 1.2 2006/02/26 09:47:59 harua-t Exp $
 */

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import jp.sourceforge.talisman.xmlcli.OptionsBuilder;

/**
 * {@link OptionsBuilder <code>OptionsBuilder</code>} from xml document.
 *
 * @author Haruaki TAMADA
 * @version $Revision: 1.2 $ $Date: 2006/02/26 09:47:59 $
 */
public class SaxOptionsBuilder extends AbstractOptionsBuilder{
    private String optionTarget;

    public SaxOptionsBuilder(InputStream in){
        super(in);
    }

    public String getDefinitionName(){
        return optionTarget;
    }

    public Options buildOptions() throws IOException, SAXException{
        Options options = new Options();

        try{
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            SAXParser parser = spfactory.newSAXParser();

            parser.parse(getStream(), new OptionsBuilderHandler(options));
        } catch(Exception e){
            e.printStackTrace();
        }

        return options;
    }

    public class OptionsBuilderHandler extends DefaultHandler{
        private Map<String, Option> map = new HashMap<String, Option>();
        private String tag;
        private String optionName = null;
        private boolean definitionPart = false;
        private boolean optionBuildPart = false;
        private Options options;

        public OptionsBuilderHandler(Options options){
            this.options = options;
        }

        public void startDocument(){

        }

        public void startElement(String uri, String localName, String name,
                                 Attributes attributes){
            tag = name;
            if(name.equals("definitions")){
                definitionPart = true;
            }
            else if(name.equals("command-line")){
                int index = attributes.getIndex("name");
                if(index != -1){
                    optionTarget = attributes.getValue(index);
                }
            }
            else if(name.equals("definition")){
                int index = attributes.getIndex("name");
                if(index != -1){
                    optionName = attributes.getValue(index);
                }
            }
            else if(name.equals("available-options")){
                optionBuildPart = true;
            }
            else if(name.equals("group")){
                group = new OptionGroup();
            }
        }

        private String opt;
        private String longopt;
        private String arg = "NONE";
        private String description;
        private String argname;
        private boolean require;
        private boolean multipleArg;
        private String valueSeparator;
        private String type;
        private OptionGroup group;
        private int argumentCount = -1;

        public void characters(char[] ch, int offset, int length){
            String value = new String(ch, offset, length).trim();
            if(value.equals("")) return;

            if(definitionPart){
                if(tag.equals("short-option"))         opt = value;
                else if(tag.equals("long-option"))     longopt = value;
                else if(tag.equals("argument"))        arg = value;
                else if(tag.equals("argument-name"))   argname = value;
                else if(tag.equals("require"))         require = true;
                else if(tag.equals("type"))            type = value;
                else if(tag.equals("value-separator")) valueSeparator = value;
                else if(tag.equals("multiple-args")){
                    if(value.trim().length() > 0){
                        argumentCount = Integer.parseInt(value);
                    }
                    multipleArg = true;
                }
                else if(tag.equals("description")){
                    if(description == null) description = "";
                    try{
                        BufferedReader reader = new BufferedReader(new StringReader(value));
                        StringBuffer sb = new StringBuffer(description);
                        String line;
                        while((line = reader.readLine()) != null){
                            sb.append(line).append(" ");
                        }
                        description = new String(sb);
                    } catch(IOException e){ }
                }
            }
            else if(optionBuildPart){
                if(tag.equals("option")){
                    Option o = (Option)map.get(value);
                    if(o != null){
                        if(group != null) group.addOption(o);
                        else              options.addOption(o);
                    }
                }
                else if(tag.equals("group")){
                    group = new OptionGroup();
                }
            }
        }

        public void endElement(String uri, String localName, String name){
            if(name.equals("definitions")){
                definitionPart = false;
            }
            else if(name.equals("available-options")){
                optionBuildPart = false;
            }
            else if(name.equals("definition")){
                Option option = createOption();
                map.put(optionName, option);
                optionName = null;
                opt = null;
                longopt = null;
                arg = "NONE";
                description = null;
                argname = null;
                argumentCount = -1;
                require = false;
                multipleArg = false;
                valueSeparator = null;
            }
            else if(optionBuildPart && name.equals("group")){
                options.addOptionGroup(group);
                group = null;
            }
        }

        public void endDocument(){
        }

        @SuppressWarnings("static-access")
        private Option createOption(){
            boolean hasArg = false;
            if(!arg.equals("NONE")) hasArg = true;
            description.trim();

            Option option;
            OptionBuilder builder = null;
            if(longopt != null)            builder = builder.withLongOpt(longopt);
            if(hasArg)                     builder = builder.hasArg(hasArg);
            if(argname != null)            builder = builder.withArgName(argname);
            if(description != null)        builder = builder.withDescription(description);
            if(valueSeparator != null)     builder = builder.withValueSeparator(valueSeparator.charAt(0));
            if(type != null)               builder = builder.withType(type);
            if(arg.equals("OPTIONAL"))     builder = builder.hasOptionalArg();
            if(multipleArg){
                if(arg.equals("OPTIONAL")){
                    if(argumentCount > 0)  builder = builder.hasOptionalArgs(argumentCount);
                    else                   builder = builder.hasOptionalArgs();
                }
                else{
                    if(argumentCount > 0)  builder = builder.hasArgs(argumentCount);
                    else                   builder = builder.hasArgs();
                }
            }
            if(require)                    builder = builder.isRequired();

            if(opt != null) option = builder.create(opt);
            else            option = builder.create();

            return option;
        }
    };
}
