package jp.sourceforge.talisman.xmlcli.io;

/*
 * $Id: ArgfInputStream.java,v 1.2 2006/02/26 09:47:59 harua-t Exp $
 */

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;


/**
 * @author Haruaki TAMADA
 * @version $Revision: 1.2 $ $Date: 2006/02/26 09:47:59 $
 */
public class ArgfInputStream extends InputStream implements Argf{
    private boolean stdin = false;
    private String[] fileNames;
    private InputStream current;
    private String currentFile;
    private List<StreamChangeListener> listeners = new ArrayList<StreamChangeListener>();
    private int index = 0;

    public ArgfInputStream(String[] fileNames){
        this.fileNames = fileNames;

        if(fileNames == null){
            current = System.in;
            stdin = true;
        }
    }

    public boolean isStdin(){
        return stdin;
    }

    public String getFileName(){
        return currentFile;
    }

    public int read() throws IOException {
        if(current == null){
            boolean flag = next();
            if(!flag) return -1;
        }
        int c = current.read();
        boolean flag = false;
        if(c == -1){
            flag = next();
        }
        if(flag) return read();
        return c;
    }

    public int read(byte[] data, int off, int len) throws IOException{
        int size = 0;
        if(current == null){
            return -1;
        }
        for(int i = 0; i < len; i++){
            int d = current.read();
            if(d == -1){
                next();
                break;
            }
            data[i + off] = (byte)d;
            size++;
        }

        return size;
    }

    public void addStreamChangeListener(StreamChangeListener listener){
        if(!listeners.contains(listener)){
            listeners.add(listener);
        }
    }

    public void removeStreamChangeListener(StreamChangeListener listener){
        listeners.remove(listener);
    }

    public int available() throws IOException{
        if(current == null) return -1;
        return current.available();
    }

    public long skip(long n) throws IOException{
        if(current == null) 
            throw new IOException("Already closed stream");
        return current.skip(n);
    }

    public boolean markSupported(){
        if(current == null) return false;
        return current.markSupported();
    }

    public void mark(int limit){
        if(current != null) current.mark(limit);
    }

    public void reset() throws IOException{
        if(current != null) current.reset();
    }

    public void close() throws IOException{
        fileNames = null;
        if(current != null) current.close();
        current = null;
    }

    @SuppressWarnings("unchecked")
    private void fireEvent(StreamChangeEvent e){
        for(Iterator i = listeners.iterator(); i.hasNext(); ){
            StreamChangeListener listener = (StreamChangeListener)i.next();
            switch(e.getID()){
            case StreamChangeEvent.CHANGE_STREAM:
                listener.changeStream(e);
                break;
            case StreamChangeEvent.FILE_NOT_FOUND:
                listener.fileNotFound(e);
                break;
            }
        }
    }

    private boolean next() throws IOException{
        if(current != null && !isStdin()){
            current.close();
        }
        if(fileNames == null || index >= fileNames.length){
            return false;
        }
        if(fileNames != null && index >= fileNames.length){
            try{
                FileInputStream in = new FileInputStream(fileNames[index]);
                currentFile = fileNames[index];
                this.current = in;
                fireEvent(new StreamChangeEvent(this, StreamChangeEvent.CHANGE_STREAM));
            } catch(FileNotFoundException e){
                fireEvent(new StreamChangeEvent(this, StreamChangeEvent.FILE_NOT_FOUND));
            }
        }
        return true;
    }
}
