class TestDate < Test::Unit::TestCase
	include TapKit

	def setup
		@date = Date.new(2003,12,15)
	end

	def test_new
		date = Date.new(2003,12,15)
		assert_equal(2003, date.year)
		assert_equal(12, date.month)
		assert_equal(15, date.day)
	end

	def test_new_with_date
		_date = ::Date.new(2003,12,15)
		date = Date.new_with_date _date

		assert_equal(2003, date.year)
		assert_equal(12, date.month)
		assert_equal(15, date.day)
	end

	def test_new_with_time
		time = ::Time.new
		date = Date.new_with_time time

		assert_equal(time.year, date.year)
		assert_equal(time.month, date.month)
		assert_equal(time.day, date.day)
	end

	def test_today
		time = ::Time.new
		date = Date.today

		assert_equal(time.year, date.year)
		assert_equal(time.month, date.month)
		assert_equal(time.day, date.day)
	end

	# +, -
	def test_calc
		date    = Date.new(2003,12,20)
		date2   = Date.new(2003,12,10)
		date3   = ::Date.new(2003,12,10)
		plus    = @date + 5
		minus1  = @date - date
		_minus1 = @date.to_date - date.to_date
		minus2  = @date - 5
		minus3  = @date - date3

		assert_equal(date, plus)
		assert_equal(_minus1, minus1)
		assert_equal(date2, minus2)
		assert_equal(5, minus3)
	end

	# <=>, ===
	def test_compare
		compare1 = @date <=> Date.new(2003,12,15)
		compare2 = @date <=> Date.new(2003,12,10)
		compare3 = @date <=> Date.new(2003,12,20)
		compare4 = @date <=> ::Date.new(2003,12,15)

		assert_equal(0, compare1)
		assert_equal(1, compare2)
		assert_equal(-1, compare3)
		assert_equal(0, compare4)
	end

	def test_to_date
		date = ::Date.new(2003,12,15)
		assert_equal(date, @date.to_date)
	end

	def test_to_time
		time = ::Time.local(2003, 12, 15, 0, 0, 0)
		assert_equal(time, @date.to_time)
	end

	def test_to_s
		str = '2003-12-15'
		assert_equal(str, @date.to_s)
	end
end


