#ifndef TMSP_UTIL_HPP
#define TMSP_UTIL_HPP

#include <iostream>

#define DECLARE_SP_FUNCTIONS (TYPE) \
template<class T> bool operator==( const TYPE<T> & lhs, const TYPE<T> & rhs ){ return  (lhs.get() == rhs.get()); }\
template<class T> bool operator!=( const TYPE<T> & lhs, const TYPE<T> & rhs ){ return  (lhs.get() != rhs.get()); }\
template<class T> bool operator< ( const TYPE<T> & lhs, const TYPE<T> & rhs ){ return  (lhs.get()  < rhs.get()); }\
template<class T> bool operator> ( const TYPE<T> & lhs, const TYPE<T> & rhs ){ return  (lhs.get()  > rhs.get()); }\
template<class T> bool operator<=( const TYPE<T> & lhs, const TYPE<T> & rhs ){ return !(lhs.get()  > rhs.get()); }\
template<class T> bool operator>=( const TYPE<T> & lhs, const TYPE<T> & rhs ){ return !(lhs.get()  < rhs.get()); }\
template<class T> T * get_pointer(TYPE<T> const & p){ return p->get();}\ //boost::mem_fn
template<class T, class U> TYPE<T> static_pointer_cast(TYPE<U> const & r) { return TYPE<T>(  static_cast<T*>(r.get()) );}\
template<class T, class U> TYPE<T> dynamic_pointer_cast(TYPE<U> const & r){ return TYPE<T>( dynamic_cast<T*>(r.get()) );}\
template<class E, class T, class Y> std::basic_ostream<E, T> & operator<< (std::basic_ostream<E, T> & os, TYPE<Y> const & p){os << p.get(); return os;}}


namespace tempest{
	DECLARE_SP_FUNCTIONS (direct_counted_ptr)
	DECLARE_SP_FUNCTIONS (counted_ptr)
	DECLARE_SP_FUNCTIONS (slisted_ptr)
	DECLARE_SP_FUNCTIONS (dlisted_ptr)	
}

#undef DECLARE_SP_FUNCTIONS	


#endif

