#include<iostream>
template<class T> class CRTP_base{
	int get(){return 0;};
};


class A;
class B;
template <class T> class vector_base{};

class A:public vector_base<A>{
public:
	explicit A(int i):a(i){}
	const char* get()const{return "A";}
	int get_value()const{ return a;}
private:
	int a;

};


class B:public vector_base<B>{
public:
	explicit B(int i):a(i){}
	const char* get()const{return "B";}
	int get_value()const{ return a;}
private:
	int a;
};

template<class T>
std::ostream& operator<<(std::ostream & os, const vector_base<T> & rhs){
	os << static_cast<const T&>(rhs).get();
	os << static_cast<const T&>(rhs).get_value();
	return os;	
}

template<class T>
T operator+ (const vector_base<T>& lhs, const vector_base<T>& rhs){
	return T(static_cast<const T&>(rhs).get_value() + static_cast<const T&>(lhs).get_value());
}


int main(){
	A a(1);
	B b(2);

	std::cout << a << std::endl;
	std::cout << b << std::endl;
	
	std::cout << a+a << std::endl;
	std::cout << b+b << std::endl;
	
	std::cout << sizeof(A) << std::endl;
	std::cout << sizeof(B) << std::endl;
}

