

#include<iostream>
#include<string>
#include <assert.h>
#include <vector>
#include <list>
#include <algorithm>
#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <typeinfo>

#include "../pointer/slisted_ptr.hpp"
#include "../pointer/dlisted_ptr.hpp"
//#include "../pointer/linked_ptr.hpp"
#include "../pointer/counted_ptr.hpp"

#include <boost/shared_ptr.hpp>


class B 
{
public:

   B() : val( rand() ) {}
   bool operator<( const B & other ) const { return val < other.val; }

private:

   int val;
};

template <typename ptr_type> double test_smart_pointer( std::size_t num_of_it, std::size_t num_of_sets, std::size_t num_in_set )
{
   std::size_t it, i, j;
   clock_t     start, finish;
   clock_t     rolling = 0;

   ptr_type*   pointers     = new ptr_type[num_in_set];
   B**         raw_pointers = new B*[num_of_sets];;

   for ( it = 0; it < num_of_it; ++it )
   {
      for ( i = 0; i < num_of_sets; ++i )
      {
         raw_pointers[i] = new B;
      }

      start = clock();

      for ( i = 0; i < num_of_sets; ++i )
      {
         ptr_type ident( raw_pointers[i] );

         for ( j = 0; j < num_in_set; ++j )
         {
            pointers[j] = ptr_type( ident );
         }
      }

      for ( j = 0; j < num_in_set; ++j )
      {
         pointers[j].reset();
      }

      finish = clock();

      rolling += finish - start;
   }

   delete [] raw_pointers;
   delete [] pointers;

   return (double( rolling ) / double( CLOCKS_PER_SEC ));
}


double test_raw_pointer( std::size_t num_of_it, std::size_t num_of_sets, std::size_t num_in_set )
{
   std::size_t it, i, j;
   clock_t     start, finish;
   clock_t     rolling = 0;

   B**   pointers     = new B*[num_in_set];
   B**   raw_pointers = new B*[num_of_sets];
   B*    pointer_copy;

   for ( it = 0; it < num_of_it; ++it )
   {
      for ( i = 0; i < num_of_sets; ++i )
      {
         raw_pointers[i] = new B;
      }

      start = clock();

      for ( i = 0; i < num_of_sets; ++i )
      {
         B* ident = raw_pointers[i];

         for ( j = 0; j < num_in_set; ++j )
         {
            pointers[j]  = pointer_copy = ident;
         }

         delete ident;
      }

      for ( j = 0; j < num_in_set; ++j )
      {
      }

      finish = clock();

      rolling += finish - start;
   }

   delete [] raw_pointers;
   delete [] pointers;

   return (double( rolling ) / double( CLOCKS_PER_SEC ));
}

using namespace tempest;
using namespace std;
using namespace boost;

int main()
{
   const double convert_to_ns = 1000000000.0;

   std::size_t number_of_iterations[] = { 100000, 100000, 100000, 10000, 10000, 10000, 10000, 5000, 2000, 1000 };
   std::size_t number_of_sets[]       = {    100,     50,     25,   167,   125,   100,    67,   67,  100,  100 };
   std::size_t number_in_set[]        = {      1,      2,      4,     6,     8,    10,    15,   30,   50,  100 };

   std::size_t number_of_tests = sizeof( number_in_set ) / sizeof( number_in_set[0] );

   FILE* out = fopen( "smarts.txt", "w" );

   for ( int i = 0; i < number_of_tests; ++i )
   {
      std::size_t n_iterations = number_of_iterations[i];
      std::size_t n_sets       = number_of_sets[i];
      std::size_t n_in_set     = number_in_set[i];
      std::size_t n_objects    = n_iterations * n_sets;
      std::size_t n_operations_per_el  = 2;
      std::size_t n_operations_per_set = (n_operations_per_el * n_in_set);    // copy operations (assignment + copy cons)
      std::size_t n_operations_per_it  = n_operations_per_set * n_sets;
      std::size_t n_operations         = n_operations_per_it  * n_iterations;
   	
   	//typedef B* ptr_int;
   	//typedef slisted_ptr<B> ptr_int;
	//typedef dlisted_ptr<B> ptr_int;
	//typedef counted_ptr<B> ptr_int;
	//typedef shared_ptr<B> ptr_int;

      double slisted_time      	= test_smart_pointer< slisted_ptr<B> >( n_iterations, n_sets, n_in_set );
      double dlisted_time 		= test_smart_pointer< dlisted_ptr<B> >( n_iterations, n_sets, n_in_set );
      double counted_time      	= test_smart_pointer< counted_ptr<B> >( n_iterations, n_sets, n_in_set );
   	  double dcounted_time      = test_smart_pointer< direct_counted_ptr<B> >( n_iterations, n_sets, n_in_set );
   	
      double shared_time      	= test_smart_pointer< counted_ptr<B>  >( n_iterations, n_sets, n_in_set );

      double raw_time         = test_raw_pointer ( n_iterations, n_sets, n_in_set );
      double overhead_time    = raw_time; // std::min( dumb_time, raw_time ); VC problem

      double slisted_overhead   = ( slisted_time     - overhead_time ) / n_operations;
      double dlisted_overhead 	= ( dlisted_time     - overhead_time ) / n_operations;
      double counted_overhead   = ( counted_time     - overhead_time ) / n_operations;
   	  double dcounted_overhead  = ( dcounted_time    - overhead_time ) / n_operations;
   	
      double shared_overhead    = ( shared_time      - overhead_time ) / n_operations;

      slisted_overhead      *= convert_to_ns;
      dlisted_overhead   	*= convert_to_ns;
      counted_overhead      *= convert_to_ns;
   	  dcounted_overhead     *= convert_to_ns;
      shared_overhead       *= convert_to_ns;

      fprintf( out, "%7d, %8d, %8d: (SL,DL,IC,DC,SH,Raw): (%7.3f,%7.3f,%7.3f,%7.3f,%7.3f,%7.3f )\n", n_in_set, n_objects, n_operations, slisted_time, dlisted_time, counted_time, dcounted_time, shared_time, raw_time );
      printf (      "%7d, %8d, %8d: (SL,DL,IC,DC,SH,Raw): (%7.3f,%7.3f,%7.3f,%7.3f,%7.3f,%7.3f )\n", n_in_set, n_objects, n_operations, slisted_time, dlisted_time, counted_time, dcounted_time, shared_time, raw_time );
   }
}
/*
*[study]
-X}[g|C^l@
X}[g|C^C++ɂēIꂽIuWFNgǗ̂ɂƂĂ֗ȃNX̂ƂB
C++Wɂauto_ptr݂邪Aɂ́uLvƂTOAЂƂ̃IuWFNgauto_ptr͂ЂƂł悤݌vĂB̂ߕWReiƋɎgȂ_BŏWCułboostɂ̓IuWFNgLłshared_ptrȂX}[g|C^pӂĂB̓ReiƋɗpoB݂shared_ptr͒xƂĂBōshared_ptr̂悤ȃIuWFNgL^̃X}[g|C^ɂčlĂ݂邱ƂɂB
boostł͂̃X}[g|C^̃ptH[}Xɂ<a href ="http://boost.cppll.jp/HEAD/libs/smart_ptr/smarttests.htm">Smart Pointer Timings</a>Ȃy[WŎEl@ĂBy[Wł͈ȉ̂T̃|C^rĂB
>>
<OL type=i><!--
  <li>Counted pointer using a heap allocated reference count, this is referred 
    to as <b>simple counted</b>.</li>
		-->
  <LI>q[vɊ蓖ĂꂽQƃJE^ɂ|C^JEǵB ȌA<B>simple counted</B> ƌĂԁB <!--
  <li>Counted pointer using a special purpose allocator for the reference count 
    - <b>special counted</b>.</li>
		-->
  <LI>QƃJE^<!--special purpose-->p<!>̃AP[^𗘗pă|C^JEǵB - <B>special 
  counted</B> ƌĂԁB <!--li>Counted pointer using an intrusive reference count - <b>intrusive</b>.</li-->
  <LI>ߍݎQƃJE^pă|C^JEǵB - <B>intrusive</B> ƌĂԁB <!--li>Linked pointer as described above - <b>linked</b>.</li-->
  <LI>qꂽNXgŌꂽ|C^ṕB - <B>linked</B> ƌĂԁB <!--li>Cyclic pointer, a counted implementation using a std::deque for allocation 
    with provision for weak pointers and garbage collection of cycles of pointers 
    - <b>cyclic</b>.</li-->
  <LI><!--???-->|C^̏z̃Kx[WRNVƃEB[N|C^񋟂A AP[V̂߂ std::deque 
  pz|C^ǵB - <B>cyclic</B> ƌĂԁB </LI></OL><!--p>on two compilers:</p-->
<P>2̃RpCɂ:</P>
<OL type=i>
<<
̂ǗIuWFNgɕύXȂŎĝ@ACADD̓Kx[WRN^ɎgȂǗ_̂̐EpɂĕʓrlȂĂ͂ȂȂ̂ŔėpIɎĝ@ACłB
݂shared_ptr@̃IuWFNg̎QƐ𐔂グ@iȉAvjƂĂBC͏zNpĂiȉAzNjB
IuWFNgL^̃X}[g|C^͂P̃IuWFNg𕡐̃X}[g|C^QƂB̂ƂIuWFNgQƁiLjĂX}[g|C^́uO[vvƍlBăO[v̍Ō̂P̃X}[g|C^IuWFNg폜`BăIuWFNgL^̃X}[g|C^̓O[vǗ邱Ƃ̖{ƂȂBvƏzNO[vǗ@B
𓥂܂Ŗl͏L̃y[WA񂾌vƏzN̎쐬AĂ݂B

ȂƂIuWFNgABƂ
A = B
ŃIuWFNgB͉EӒlłύXƂ͒N((ꕔ̊l͂̂āEEE))vĂȂBŃonextmutablełȂĂ͂ȂB
mutable

*/


