#ifndef _TMMATRIX_FUNCTIONS
#define _TMMATRIX_FUNCTIONS
/**
	@file matrix_functions.hpp
	@brief Defines matrix functions.
	@author ototoi / Toru Matsuoka
	@date 2004/05/12 
*/

//#include<iosfwd>
#include<ostream>
#include<sstream>

#include <algorithm>//fill_n


namespace tempest{
	
//-----------------------------------------------
//Not a member!
//-----------------------------------------------
	
//-----------------------------------------------
//operators
template<class T,std::size_t RowSz, std::size_t ColumnSz>
inline matrix<T,RowSz,ColumnSz> operator- (const matrix<T,RowSz,ColumnSz> & rhs){
	return matrix<T,RowSz,ColumnSz>(rhs) *= T(-1);
}
	
template<class T,std::size_t RowSz, std::size_t ColumnSz> 
inline matrix<T,RowSz,ColumnSz> operator+ (const matrix<T,RowSz,ColumnSz> &lhs, const matrix<T,RowSz,ColumnSz> &rhs){
	return matrix<T,RowSz,ColumnSz>(lhs) += rhs;
}

template<class T,std::size_t RowSz, std::size_t ColumnSz> 
inline matrix<T,RowSz,ColumnSz> operator- (const matrix<T,RowSz,ColumnSz> &lhs, const matrix<T,RowSz,ColumnSz> &rhs){
	return matrix<T,RowSz,ColumnSz>(lhs) -= rhs;
}

template<class T,std::size_t ASz, std::size_t BSz,std::size_t CSz> //This functon is NOT recommended.
matrix<T,ASz,CSz> operator* (const matrix<T,ASz,BSz> &lhs, const matrix<T,BSz,CSz> &rhs){
	matrix<T,ASz,CSz> temp;
	
	std::fill_n<T>(temp.begin(),ASz*CSz,T());
	
	for(std::size_t i =0;i<ASz;++i){
		for(std::size_t k=0;k<BSz;k++){
			for(std::size_t j =0;j<CSz;++j){			
				temp[i][j] += lhs[i][k]*rhs[k][j];	
			}
		}
	}
	return temp;
}

template<class T,std::size_t ASz, std::size_t BSz,std::size_t CSz>
void multiply(matrix<T,ASz,CSz> *out,const matrix<T,ASz,BSz> &lhs, const matrix<T,BSz,CSz> &rhs){
	
	std::fill_n<T>((*out).begin(),ASz*CSz,T());
	
	for(std::size_t i =0;i<ASz;++i){
		for(std::size_t k=0;k<BSz;k++){
			for(std::size_t j =0;j<CSz;++j){			
				(*out)[i][j] += lhs[i][k]*rhs[k][j];	
			}
		}
	}
	
	return;
}

	
//-----------------------------------------------
//specific scalar
	
template<class T, class X, std::size_t RowSz, std::size_t ColumnSz> 
inline matrix<T,RowSz,ColumnSz> operator* (const X lhs,const matrix<T,RowSz,ColumnSz> & rhs){ 
	return matrix<T,RowSz,ColumnSz>(rhs) *= lhs ; 
}
template<class T, class X, std::size_t RowSz, std::size_t ColumnSz>
inline matrix<T,RowSz,ColumnSz> operator* (const matrix<T,RowSz,ColumnSz> &lhs,const X rhs){ 
	return matrix<T,RowSz,ColumnSz>(lhs) *= rhs ;
}
template<class T, class X, std::size_t RowSz, std::size_t ColumnSz> 
inline matrix<T,RowSz,ColumnSz> operator/ (const X lhs,const matrix<T,RowSz,ColumnSz> & rhs){ 
	return matrix<T,RowSz,ColumnSz>(rhs) /= lhs ; 
}
template<class T, class X, std::size_t RowSz, std::size_t ColumnSz>
inline matrix<T,RowSz,ColumnSz> operator/ (const matrix<T,RowSz,ColumnSz> &lhs,const X rhs){ 
	return matrix<T,RowSz,ColumnSz>(lhs) /= rhs ;
}
	
	
//-----------------------------------------------	
// utilities
template<class T, std::size_t RowSz, std::size_t ColumnSz>
matrix<T,ColumnSz,RowSz>	 transpose(const matrix<T,RowSz,ColumnSz>& rhs){ 
	
	matrix<T,ColumnSz,RowSz> temp;
	for(std::size_t i = 0;i<ColumnSz;i++){
		for(std::size_t j = 0;j<RowSz;j++){
			temp[i][j] = rhs[j][i];
		}
	}
	return temp;
}

	
//--------------------------------------------------
//compare

template<class T, std::size_t RowSz, std::size_t ColumnSz>
bool operator==(const matrix<T,RowSz,ColumnSz> &lhs,const matrix<T,RowSz,ColumnSz> &rhs){
	typename matrix<T,RowSz,ColumnSz>::const_iterator l_i = lhs.begin();
	typename matrix<T,RowSz,ColumnSz>::const_iterator r_i = rhs.begin();
	
	typename matrix<T,RowSz,ColumnSz>::const_iterator end = lhs.end();
	while(l_i != end){
		if(*l_i != *r_i)return false;
		++l_i;
		++r_i;
	}
	return true;
}

template<class T, std::size_t RowSz, std::size_t ColumnSz>
inline bool operator!=(const matrix<T,RowSz,ColumnSz> &lhs,const matrix<T,RowSz,ColumnSz> &rhs){
	return !(lhs == rhs);
}

/*
template<class T,std::size_t Sz>
inline bool operator< (const matrix<T,Sz> &lhs,const matrix<T,Sz> &rhs){
	return lhs.sqr_length() < rhs.sqr_length();
}

template<class T,std::size_t Sz>
inline bool operator> (const matrix<T,Sz> &lhs,const matrix<T,Sz> &rhs){
	return rhs < lhs;
}

template<class T,std::size_t Sz>
inline bool operator>= (const matrix<T,Sz> &lhs,const matrix<T,Sz> &rhs){
	return !(lhs < rhs);
}

template<class T,std::size_t Sz>
inline bool operator<= (const matrix<T,Sz> &lhs,const matrix<T,Sz> &rhs){
	return !(rhs < lhs);
}
*/

//-----------------------------------------------
//output

/** 
 *	ostream << 
 */
template<typename T, std::size_t RowSz, std::size_t ColumnSz, typename _CharT, class _Traits>
std::basic_ostream<_CharT, _Traits>& operator<<(std::basic_ostream<_CharT, _Traits>& os,  const matrix<T,RowSz,ColumnSz>& rhs){
	
	std::basic_ostringstream<_CharT, _Traits> s;
	s.flags(os.flags());
	s.imbue(os.getloc());
	s.precision(os.precision());
	for(std::size_t i=0;i<RowSz;i++){
		s <<"(";
		for(std::size_t j = 0;j < ColumnSz-1;++j){
			s << rhs[i][j] <<",";
		}
		s <<rhs[i][ColumnSz-1];
		s <<")";
		if(i != RowSz-1){s << "\n";}
	}
	return os << s.str();
}

}//end of namespace 

#endif

