/* ********************************************************* teo_pixel.h *** *
 * This library is a auxiliary teo library
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-09-14 22:51:03 sugaya>
 * ************************************************************************* */
#ifndef _TEO_PIXEL_H_
#define _TEO_PIXEL_H_

/* ************************************************************************* *
   These functions are about pixel access that can call without 
   explicit pixel type.
 * ************************************************************************* */
double	TeoGetAnyPixel		(TEOIMAGE	*img,
				 int		col,
				 int 		row,
				 int		p);

void	TeoPutAnyPixel		(TEOIMAGE	*img,
				 int		col,
				 int		row,
				 int		p,
				 double		val);

void	TeoGetAnyPixelRGB	(TEOIMAGE	*img,
				 int		col,
				 int 		row,
				 double 	val[3]);

void	TeoPutAnyPixelRGB	(TEOIMAGE	*img,
				 int		col,
				 int		row,
				 double		val[3]);

#endif	/* _TEO_PIXEL_H_ */

/* ************************************************** End of teo_pixel.h *** */
