/* pnm2teo
   PNM $B%U%)!<%^%C%H$+$i(B TEO $B%U%)!<%^%C%H$KJQ49$9$k(B
   */

#include        <stdio.h>
#include        <teo.h>		/* Header File of libteo */
#include <stdlib.h>

int main(int argc,char *argv[])
{
  int		i,frame,fsize;
  TEOFILE	*fileIn,*fileOut;
  TEOIMAGE	*img;

  if(argc < 2){
    fileIn = TeoOpenFile("-");
    frame = 1;
  } else{
    if ((fileIn = TeoOpenFile(argv[1]))==NULL) TeoError();
    frame = argc-1;
  }

  fileOut = TeoCreateFile("-",teo_width(fileIn),teo_height(fileIn),0,0,
			  teo_type(fileIn),teo_bit(fileIn),teo_plane(fileIn),
			  frame);
  img = TeoAllocSimilarImage(fileIn);
  fsize = teo_fsize(fileIn);

  TeoReadFrame(fileIn,img);
  TeoWriteFrame(fileOut,img);
  TeoCloseFile(fileIn);

  for(i=2;i<argc;i++){
    if ((fileIn = TeoOpenFile(argv[i]))==NULL) TeoError();
    if(teo_fsize(fileIn) != fsize){
	fprintf(stderr,"image size miss match.\n");
	exit(-1);
    }
    TeoReadFrame(fileIn,img);
    TeoWriteFrame(fileOut,img);
    TeoCloseFile(fileIn);
  }

  TeoCloseFile(fileOut);
  TeoFreeImage(img);

  return 0;
}
