#ifndef TEO_EXCEPTION_H
#define TEO_EXCEPTION_H
#include <cstring>
#include <exception>
#include <string>
#include <iostream>

class TeoErr : public std::exception {
  int code;
  std::string message;
  std::string name;
 public:
  TeoErr(int c,char *msg,char *n){
    code = c;
    message= std::string(msg);
    name = std::string(n);
  }
  ~TeoErr()throw(){}

  virtual void operator()(char *file=NULL,int line=0){
    if(file) TeoErrorBase(file,line);
    else TeoErrorBase((char*)name.c_str(),code);
  }
  int error_code(){return code;}
  const char *what()const throw() {return message.c_str();}
};
#endif
