//-*- Mode: C++ -*-
#ifndef _TEOPP_TEOSEQUENCE_H_
#define _TEOPP_TEOSEQUENCE_H_
// TEO $BF02hMQ%/%i%9(B($BCj>]%/%i%9(B)
class TeoSequence {
public:
  TeoSequence(){};
  virtual ~TeoSequence(){};

  virtual TeoAnyImage GetImage(int frame_num=-1){return TeoAnyImage();}
  friend TeoSequence &operator>>(TeoSequence &tseq,TeoAnyImage &img){
    img = tseq.GetImage();
    return tseq;
  }
  virtual TeoAnyImage operator[](int frame_num){
    return GetImage(frame_num);
  }

  virtual void PutImage(const TeoAnyImage &image,int frame_num=-1){}
  friend TeoSequence &operator<<(TeoSequence &tseq,const TeoAnyImage &img){
    tseq.PutImage(img);
    return tseq;
  }


  virtual bool SetAbsFrame(int frame_num=0){return false;}
  virtual bool SetRelFrame(int frame_num=0){return false;}
  virtual TeoSequence &operator++(){
    SetRelFrame(1);
    return *this;
  }
  virtual TeoSequence &operator+(int frame_num){
    SetRelFrame(frame_num);
    return *this;
  }

  virtual int Width()const{return 0;}
  virtual int Height()const{return 0;}
  virtual int Type()const{return 0;}
  virtual int Bit()const{return 0;}
  virtual int Plane()const{return 0;}
  virtual int Frame()const{return 0;}
  virtual int Fsize()const{return Width()*Height()*Plane()*Bit()/8;};
  
  virtual int Xoffset()const{return 0;}
  virtual int Yoffset()const{return 0;}
  virtual int Xstart()const{return Xoffset();};
  virtual int Xend()const{return Width() + Xoffset() - 1;};
  virtual int Ystart()const{return Yoffset();};
  virtual int Yend()const{return Height() + Yoffset() - 1;};

  virtual bool CheckFrame()const{return false;}
  virtual operator bool(){return CheckFrame();}
};
#endif
