#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <teo.h>

int TeoUtilCopyArea(TEOIMAGE *src, TEOIMAGE *dst,
		    int src_x, int src_y, int width, int height,
		    int dst_x, int dst_y){
  char *src_p,*dst_p;
  int bytes;
  int src_bytewidth,dst_bytewidth;
  int i,j,p;

  if( (TeoPlane(src) != TeoPlane(dst)) ||
      (src_x < TeoXstart(src)) ||
      (src_y < TeoYstart(src)) ||
      (src_x + width - 1 > TeoXend(src)) ||
      (src_y + height - 1 > TeoYend(src)) ||
      (dst_x < TeoXstart(dst)) ||
      (dst_y < TeoYstart(dst)) ||
      (dst_x + width - 1 > TeoXend(dst)) ||
      (dst_y + height - 1 > TeoYend(dst)) )
    return 0;

  if(TeoBit(src) == 1){
    if(TeoBit(dst) != 1) return 0;

    for(j=0;j<height;j++)
      for(i=0;i<width;i++)
	for(p=0;p<TeoPlane(src);p++)
	  TeoPutBit(dst,dst_x+TeoXoffset(dst)+i,
		    dst_y+TeoYoffset(dst)+j,p,
		    TeoGetBit(src,src_x+TeoXoffset(src)+i,
			      src_y+TeoYoffset(src)+j,p));
  } else {
    if((TeoType(src) != TeoType(dst)) ||
       (TeoBit(src) != TeoBit(dst))) return 0;
    /*
    bytes = (TeoBit(src)/8);
    src_bytewidth = TeoWidth(src) * TeoPlane(src) * bytes;
    dst_bytewidth = TeoWidth(dst) * TeoPlane(src) * bytes;
    */
    /* 2002.05.27 */
    bytes = (TeoBit(src)/8) * TeoPlane(src);
    src_bytewidth = TeoWidth(src) * bytes;
    dst_bytewidth = TeoWidth(dst) * bytes;
    
    src_p = TeoData(src) + (src_y-TeoYoffset(src)) * src_bytewidth;
    dst_p = TeoData(dst) + (dst_y-TeoYoffset(dst)) * dst_bytewidth;
    for(i=0;i<height;i++){
      memcpy((void*)(dst_p + (dst_x - TeoXoffset(dst))*bytes),
	     (void*)(src_p + (src_x - TeoXoffset(src))*bytes),
	     width * bytes);
      src_p += src_bytewidth;
      dst_p += dst_bytewidth;
    }
  }
  return 1;
}
