/* ************************************************** libteoeyesplugin.c *** *
 * ƥץ饰饤֥
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <05/05/17 22:51:15 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "teoeyes_plugin.h"

#define WINDOW_WIDTH	500
#define	WINDOW_HEIGHT	500
#define	CANVAS_SIZE	480

#define	G_SET_OBJECT(parent,name,object) g_object_set_data_full (G_OBJECT (parent), name, g_object_ref (object), (GDestroyNotify) g_object_unref)

#define	G_SET_WIDGET(parent,name,widget) g_object_set_data_full (G_OBJECT (parent), name, gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)


static void	cb_preview (void);

/* ************************************************************************* */
static void
cb_destroy (GtkWidget	*widget,
	    gpointer	data) {
  return;
}

/* ************************************************************************* */
static void
draw_dialog_image (GtkWidget	*canvas,
		   GdkPixbuf	*pixbuf) {
  GdkPixbuf	*background;
  GdkPixmap	*pixmap;
  GdkBitmap	*mask;
  gint		w, h;

  gdk_window_set_back_pixmap (canvas->window, NULL, FALSE);
  w = gdk_pixbuf_get_width  (pixbuf);
  h = gdk_pixbuf_get_height (pixbuf);

  background = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, w, h);
  gdk_pixbuf_composite_color (pixbuf, background, 0, 0, w, h, 0, 0, 1.0, 1.0,
			      GDK_INTERP_TILES, 255, 0, 0, 16,
			      0xaaaaaa, 0x555555);
  gdk_pixbuf_render_pixmap_and_mask (background, &pixmap, &mask, 255);
  
  gdk_window_set_back_pixmap (canvas->window, pixmap, FALSE);
  gdk_window_clear (canvas->window);
  gdk_window_shape_combine_mask (canvas->window, mask, 0, 0);
  gdk_flush ();

  gdk_pixbuf_unref (background);
  gdk_pixmap_unref (pixmap);
  if (mask) gdk_bitmap_unref (mask);
  
  gtk_widget_set_size_request (canvas, w, h);
}

/* ************************************************************************* */
static void
cb_adj (GtkWidget	*widget,
	GtkSpinButton	*spinbutton) {
  gint	val;

  val = (gint) pdialog->adj->value;
  gtk_spin_button_set_value (spinbutton, val);
  if (!pdialog->use_preview) cb_preview();
}

/* ************************************************************************* */
static void
cb_spinbutton (GtkWidget	*widget,
	       gpointer		data) {
  gint	val;
  gchar	buf[64];

  val = (gint)
    gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON(pdialog->spinbutton));
  
  if (val < (gint) pdialog->adj->lower) {
    val = (gint) pdialog->adj->lower;
    sprintf (buf, "%d", val);
    gtk_entry_set_text (GTK_ENTRY(widget), buf);
  }
  if (val > (gint) (pdialog->adj->upper - pdialog->adj->page_increment)) {
    val = (gint) (pdialog->adj->upper - pdialog->adj->page_increment);
    sprintf (buf, "%d", val);
    gtk_entry_set_text (GTK_ENTRY(widget), buf);
  }
  if (!pdialog->use_preview) {
    plugin_preview_image (pdialog->src, pdialog->work, (double) val, 0, 0);
    draw_dialog_image (pdialog->canvas, pdialog->work);
  }
}

/* ************************************************************************* */
static void
cb_preview (void) {
  plugin_preview_image (pdialog->src,
			pdialog->work,
			(double) gtk_spin_button_get_value_as_int
			(GTK_SPIN_BUTTON(pdialog->spinbutton)), 0, 0);
  draw_dialog_image (pdialog->canvas, pdialog->work);
}

/* ************************************************************************* */
static void
cb_apply (void) {
  plugin_preview_image (pdialog->src,
			pdialog->dest,
			(double) gtk_spin_button_get_value_as_int
			(GTK_SPIN_BUTTON(pdialog->spinbutton)), 0, 0);
  draw_dialog_image (pdialog->canvas, pdialog->dest);

  gdk_pixbuf_unref (pdialog->work);
  
  gtk_grab_remove (pdialog->dialog);
  gtk_widget_destroy (pdialog->dialog);
  gtk_main_quit ();
}

/* ************************************************************************* */
static void
cb_cancel (void) {
  gdk_pixbuf_unref (pdialog->work);  
  gtk_grab_remove (pdialog->dialog);
  gtk_widget_destroy (pdialog->dialog);
  gtk_main_quit ();  
}

/* ************************************************************************* */
void
teoeyes_plugin_progressbar_update (double	val) {
  gtk_progress_bar_update (GTK_PROGRESS_BAR (pdialog->progressbar), val);
  while (gtk_events_pending ()) gtk_main_iteration ();
}

/* ץ饰ؿ ****************************************** */
void
teoeyes_plugin_dialog_new (gchar		*title, 
			   void	(*func) 	(GdkPixbuf	*src,
						 GdkPixbuf	*dest,
						 double		param1,
						 double		param2,
						 double		param3),
			   GdkPixbuf		*src,
			   GdkPixbuf		*dest,		    
			   gchar		*label,
			   double		min,
			   double		max,
			   double 		step,
			   double 		page,
			   gboolean		use_preview,
			   gboolean		use_progressbar) {
  GtkWidget	*obj;		
  GtkWidget	*vbox;
  GtkWidget	*hbox;
  GtkWidget	*alignment;
  GtkWidget	*scrolledwindow;
  
  plugin_preview_image = func;

  pdialog = g_new0(TeoeyesPluginDialog, 1);
  pdialog->use_preview = use_preview;

  pdialog->dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (pdialog->dialog), title);
  g_signal_connect (G_OBJECT(pdialog->dialog),
		    "destroy", G_CALLBACK(cb_destroy), NULL);
  g_signal_connect (G_OBJECT(pdialog->dialog),
		    "delete_event", G_CALLBACK(cb_destroy), NULL);
  if (use_progressbar) {
    gtk_widget_set_size_request (pdialog->dialog,
				 WINDOW_WIDTH, WINDOW_HEIGHT+20);
  } else {
    gtk_widget_set_size_request (pdialog->dialog,
				 WINDOW_WIDTH, WINDOW_HEIGHT);
  }
  gtk_window_set_resizable(GTK_WINDOW (pdialog->dialog), FALSE);
  gtk_widget_show (pdialog->dialog);
  {
    obj = gtk_viewport_new (NULL, NULL);
    gtk_widget_show (obj);
    gtk_container_add (GTK_CONTAINER(pdialog->dialog), obj);
    gtk_container_set_border_width (GTK_CONTAINER(obj), 2);
    G_SET_WIDGET(pdialog->dialog, "viewport", obj);
    {
      vbox = gtk_vbox_new (FALSE, 0);
      gtk_widget_show (vbox);
      gtk_container_add (GTK_CONTAINER(obj), vbox);
      G_SET_WIDGET(pdialog->dialog, "vbox1", vbox);
      {
	scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(scrolledwindow),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_widget_show (scrolledwindow);
	gtk_box_pack_start (GTK_BOX(vbox), scrolledwindow, TRUE, TRUE, 0);
	G_SET_WIDGET(pdialog->dialog, "scrolledwindow", scrolledwindow);
	{
	  alignment = gtk_alignment_new (0.5, 0.5, 0.0, 0.0);
	  gtk_widget_show (alignment);
	  gtk_scrolled_window_add_with_viewport
	    (GTK_SCROLLED_WINDOW(scrolledwindow), alignment);
	  G_SET_WIDGET(pdialog->dialog, "alignment", alignment);

	  pdialog->canvas = gtk_drawing_area_new();
	  gtk_widget_show (pdialog->canvas);
	  gtk_container_add (GTK_CONTAINER(alignment), pdialog->canvas);
	  gtk_widget_set_size_request (GTK_WIDGET(pdialog->canvas),
				       CANVAS_SIZE, CANVAS_SIZE);
	  G_SET_WIDGET(pdialog->dialog, "canvas", pdialog->canvas);
	}
	hbox = gtk_hbox_new (FALSE, 3);
	gtk_widget_show (hbox);
	gtk_box_pack_start (GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
	G_SET_WIDGET(pdialog->dialog, "hbox1", hbox);
	{
	  obj = gtk_label_new (label);
	  gtk_widget_show (obj);
	  gtk_box_pack_start (GTK_BOX(hbox), obj, TRUE, TRUE, 0);
	  G_SET_WIDGET(pdialog->dialog, "label1", obj);

	  pdialog->adj
	    = GTK_ADJUSTMENT(gtk_adjustment_new (min, min,
						 max, step, page, page));
	  pdialog->spinbutton = gtk_spin_button_new (pdialog->adj, 1, 0);
	  g_signal_connect (G_OBJECT(pdialog->spinbutton), "activate",
			    G_CALLBACK (cb_spinbutton), NULL);
	  g_signal_connect (G_OBJECT(pdialog->adj), "value_changed",
			    G_CALLBACK(cb_adj),
			    (gpointer) pdialog->spinbutton);
	  gtk_box_pack_start (GTK_BOX(hbox),
			      pdialog->spinbutton, TRUE, TRUE, 0);
	  gtk_widget_show (pdialog->spinbutton);
	  G_SET_OBJECT(pdialog->dialog, "adjustment", pdialog->adj);
	  G_SET_WIDGET(pdialog->dialog, "spinbutton", pdialog->spinbutton);
	}
	pdialog->box = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX(vbox), pdialog->box, FALSE, FALSE, 0);
      
	obj = gtk_hseparator_new ();
	gtk_widget_show (obj);
	gtk_box_pack_start (GTK_BOX(vbox), obj, FALSE, FALSE, 5);
	G_SET_WIDGET (pdialog->dialog, "separator1", obj);

	hbox = gtk_hbox_new (TRUE, 3);
	gtk_widget_show (hbox);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	G_SET_WIDGET (pdialog->dialog, "hbox2", hbox);
	{
	  if (use_preview) {
	    obj = gtk_button_new_with_label (_("Preview"));
	    g_signal_connect (G_OBJECT (obj), "clicked",
			      G_CALLBACK (cb_preview), NULL);
	    gtk_box_pack_start (GTK_BOX (hbox), obj, TRUE, TRUE, 0);
	    gtk_widget_show (obj);
	    G_SET_WIDGET (pdialog->dialog, "button1", obj);
	  }
	  obj = gtk_button_new_from_stock (GTK_STOCK_APPLY);
	  g_signal_connect (G_OBJECT(obj),
			    "clicked", G_CALLBACK (cb_apply), NULL);
	  gtk_box_pack_start (GTK_BOX (hbox), obj, TRUE, TRUE, 0);
	  gtk_widget_show (obj);
	  G_SET_WIDGET (pdialog->dialog, "button2", obj);

	  obj = gtk_button_new_from_stock (GTK_STOCK_CANCEL);
	  g_signal_connect (G_OBJECT(obj),
			    "clicked", G_CALLBACK (cb_cancel), NULL);
	  gtk_box_pack_start (GTK_BOX (hbox), obj, TRUE, TRUE, 0);
	  gtk_widget_show (obj);
	  G_SET_WIDGET (pdialog->dialog, "button3", obj);
	}
	if (use_progressbar) {
	  obj = gtk_hseparator_new ();
	  gtk_widget_show (obj);
	  gtk_box_pack_start (GTK_BOX (vbox), obj, FALSE, FALSE, 5);
	  G_SET_WIDGET (pdialog->dialog, "separator2", obj);

	  pdialog->progressbar = gtk_progress_bar_new ();
	  
	  gtk_box_pack_start (GTK_BOX (vbox),
			      pdialog->progressbar, FALSE, FALSE, 0);
	  gtk_widget_show (pdialog->progressbar);
	  G_SET_WIDGET (pdialog->dialog, "progressbar", pdialog->progressbar);
	}
      }
    }
  }
  pdialog->src  = src;
  pdialog->dest = dest;
  pdialog->work = gdk_pixbuf_copy (src);

  gdk_pixbuf_copy_area (pdialog->src, 
			0, 0,
			gdk_pixbuf_get_width  (pdialog->src),
			gdk_pixbuf_get_height (pdialog->src),
			pdialog->dest, 
			0, 0);
  
  plugin_preview_image (pdialog->src, pdialog->work, min, 0, 0);
  draw_dialog_image (pdialog->canvas, pdialog->work);

  gtk_grab_add (pdialog->dialog);
}

/* ********************************************* End of teoeyes_plugin.c *** */
